/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.navigator.action.GenerateAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.NewActionGroup;
import org.eclipse.hyades.test.ui.internal.navigator.action.OpenEditorAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.OpenReportAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.StopAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleEObjectChildrenAction;
import org.eclipse.hyades.test.ui.internal.navigator.action.ToggleFolderAction;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.ITreeNavigator;
import org.eclipse.hyades.ui.internal.navigator.action.FrameListActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorSorterActionGroup;
import org.eclipse.hyades.ui.internal.navigator.action.ToggleLinkingAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.actions.AddTaskAction;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class TestNavigatorActionGroup
extends NavigatorActionGroup {
    protected OpenEditorAction openAction;
    protected AddBookmarkAction addBookmarkAction;
    protected AddTaskAction addTaskAction;
    protected PropertyDialogAction propertyDialogAction;
    protected CollapseAllAction collapseAllAction;
    protected ToggleLinkingAction toggleLinkingAction;
    protected ToggleFolderAction toggleFolderAction;
    protected ToggleEObjectChildrenAction toggleEObjectChildren;
    protected OpenReportAction openReportAction;
    protected GenerateAction generateAction;
    protected RefreshAction refreshAction;
    protected OpenResourceAction openProjectAction;
    protected CloseResourceAction closeProjectAction;
    protected StopAction stopAction;
    protected DeleteResourceAction deleteResourceAction;
    protected RemoveChildrenAction deleteChildEObject;
    protected NavigatorSorterActionGroup sorterActionGroup;
    protected NewActionGroup newActionGroup;
    protected WorkingSetFilterActionGroup workingSetFilterActionGroup;
    protected FrameListActionGroup frameListActionGroup;
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;

    public TestNavigatorActionGroup(TestNavigator testNavigator) {
        super((INavigator)testNavigator);
    }

    public void dispose() {
        this.newActionGroup.dispose();
        this.workingSetFilterActionGroup.dispose();
        this.sorterActionGroup.dispose();
        this.frameListActionGroup.dispose();
        this.generateAction.dispose();
        this.stopAction.dispose();
        super.dispose();
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        this.sorterActionGroup.setContext(context);
        this.newActionGroup.setContext(context);
        this.workingSetFilterActionGroup.setContext(context);
        this.frameListActionGroup.setContext(context);
    }

    protected void createActions() {
        super.createActions();
        Shell shell = this.getNavigator().getSite().getShell();
        this.openAction = new OpenEditorAction((TestNavigator)this.getNavigator(), TestUIPlugin.getString("ACT_OPEN"));
        this.addBookmarkAction = new AddBookmarkAction(shell);
        this.addTaskAction = new AddTaskAction(shell);
        this.propertyDialogAction = new PropertyDialogAction(shell, (ISelectionProvider)this.getNavigator().getViewer());
        this.collapseAllAction = new CollapseAllAction(((ITreeNavigator)this.getNavigator()).getTreeViewer());
        this.collapseAllAction.useDefaultDecorators();
        this.toggleLinkingAction = new ToggleLinkingAction(this.getNavigator(), ResourceNavigatorMessages.getString((String)"ToggleLinkingAction.text"));
        this.toggleLinkingAction.setToolTipText(ResourceNavigatorMessages.getString((String)"ToggleLinkingAction.toolTip"));
        this.toggleLinkingAction.setImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleLinkingAction.setHoverImageDescriptor(this.getImageDescriptor("elcl16/synced.gif"));
        this.toggleFolderAction = new ToggleFolderAction((TestNavigator)this.getNavigator(), TestUIPlugin.getString("ACT_SHOW_FLD_TXT"));
        this.toggleFolderAction.setToolTipText(TestUIPlugin.getString("ACT_SHOW_FLD_DSC"));
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleFolderAction, "showfolders_co.gif");
        this.toggleEObjectChildren = new ToggleEObjectChildrenAction((TestNavigator)this.getNavigator(), TestUIPlugin.getString("ACT_SHOW_EOBJ_CH_TXT"));
        this.toggleEObjectChildren.setToolTipText(TestUIPlugin.getString("ACT_SHOW_EOBJ_CH_DSC"));
        TestUIImages.INSTANCE.setImageDescriptors((IAction)this.toggleEObjectChildren, "showchild_co.gif");
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.deleteResourceAction = new DeleteResourceAction(shell);
        this.deleteResourceAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteResourceAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteResourceAction.setHoverImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_HOVER"));
        this.deleteChildEObject = new RemoveChildrenAction(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List saveResources(Set changedResources) {
                TestNavigator testNavigator = (TestNavigator)TestNavigatorActionGroup.this.getNavigator();
                testNavigator.getTreeViewer().remove(this.getStructuredSelection().toArray());
                testNavigator.setMonitoringResourceChange(false);
                try {
                    List list = super.saveResources(changedResources);
                    return list;
                }
                finally {
                    testNavigator.setMonitoringResourceChange(true);
                }
            }
        };
        this.deleteChildEObject.setStructuredViewer(((TestNavigator)this.getNavigator()).getViewer());
        this.deleteChildEObject.setShowErrorDialog(true);
        this.openReportAction = new OpenReportAction();
        this.generateAction = new GenerateAction();
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setDisabledImageDescriptor(this.getImageDescriptor("dlcl16/refresh_nav.gif"));
        this.refreshAction.setImageDescriptor(this.getImageDescriptor("elcl16/refresh_nav.gif"));
        this.openProjectAction = new OpenResourceAction(shell);
        this.closeProjectAction = new CloseResourceAction(shell);
        this.stopAction = new StopAction();
    }

    protected void createActionGroups() {
        super.createActionGroups();
        this.sorterActionGroup = new NavigatorSorterActionGroup(this.getNavigator());
        this.newActionGroup = new NewActionGroup((TestNavigator)this.getNavigator());
        IPropertyChangeListener workingSetUpdater = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("changeWorkingSet".equals(property)) {
                    INavigator navigator = TestNavigatorActionGroup.this.getNavigator();
                    Object newValue = event.getNewValue();
                    if (newValue instanceof IWorkingSet) {
                        ((TestNavigator)navigator).setWorkingSet((IWorkingSet)newValue);
                    } else if (newValue == null) {
                        ((TestNavigator)navigator).setWorkingSet(null);
                    }
                }
            }
        };
        this.workingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getNavigator().getViewer().getControl().getShell(), workingSetUpdater);
        this.workingSetFilterActionGroup.setWorkingSet(((TestNavigator)this.getNavigator()).getWorkingSet());
        this.frameListActionGroup = new FrameListActionGroup((ITreeNavigator)((TestNavigator)this.getNavigator()));
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        boolean hasClosedProjects = false;
        boolean hasOpenProjects = false;
        boolean isProjectSelection = true;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection resSelection = this.getResourceSelection(selection);
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || isProjectSelection)) {
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable) {
                project = (IProject)((IAdaptable)next).getAdapter(class$org$eclipse$core$resources$IProject == null ? TestNavigatorActionGroup.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                continue;
            }
            hasClosedProjects = true;
        }
        this.newActionGroup.fillContextMenu(menu);
        this.frameListActionGroup.fillContextMenu(menu);
        this.openAction.selectionChanged(selection);
        if (this.openAction.isApplicableForSelection()) {
            menu.appendToGroup("org.eclipse.ui.OpenWithSubMenu", (IAction)this.openAction);
        }
        if (!hasClosedProjects) {
            this.refreshAction.selectionChanged(selection);
            menu.appendToGroup("group.refresh", (IAction)this.refreshAction);
        }
        if (isProjectSelection) {
            if (hasClosedProjects) {
                this.openProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.refresh", (IAction)this.openProjectAction);
            }
            if (hasOpenProjects) {
                this.closeProjectAction.selectionChanged(selection);
                menu.appendToGroup("group.refresh", (IAction)this.closeProjectAction);
            }
        }
        this.generateAction.selectionChanged(selection);
        if (this.generateAction.isApplicableForSelection()) {
            menu.appendToGroup("group.import", (IAction)this.generateAction);
        }
        this.openReportAction.selectionChanged(selection);
        if (this.openReportAction.isApplicableForSelection()) {
            menu.appendToGroup("group.import", (IAction)this.openReportAction);
        }
        this.stopAction.selectionChanged(selection);
        if (this.stopAction.isApplicableForSelection()) {
            menu.appendToGroup("group.delete", (IAction)this.stopAction);
            this.stopAction.setEnabled(this.stopAction.isApplicableForEnablement());
        }
        this.deleteResourceAction.setEnabled(false);
        if (resSelection.size() == selection.size()) {
            this.deleteResourceAction.selectionChanged(resSelection);
            menu.appendToGroup("group.delete", (IAction)this.deleteResourceAction);
            this.addBookmarkAction.selectionChanged(resSelection);
            if (this.addBookmarkAction.isEnabled()) {
                menu.appendToGroup("group.delete", (IAction)this.addBookmarkAction);
            }
        }
        if (!this.deleteResourceAction.isEnabled()) {
            menu.add((IContributionItem)new Separator());
            this.deleteChildEObject.selectionChanged(selection);
            if (this.deleteChildEObject.isEnabled()) {
                menu.add((IAction)this.deleteChildEObject);
            }
        }
        if (selection.size() == 1) {
            this.propertyDialogAction.selectionChanged(selection);
            if (this.propertyDialogAction.isApplicableForSelection()) {
                menu.appendToGroup("group.properties", (IAction)this.propertyDialogAction);
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertyDialogAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.addBookmarkAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.addTaskAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteResourceAction);
        this.frameListActionGroup.fillActionBars(actionBars);
        this.newActionGroup.fillActionBars(actionBars);
        this.workingSetFilterActionGroup.fillActionBars(actionBars);
        this.sorterActionGroup.fillActionBars(actionBars);
        super.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.toggleLinkingAction);
        menu.add((IAction)this.toggleEObjectChildren);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.collapseAllAction);
        toolBar.add((IAction)this.toggleLinkingAction);
    }

    public void updateActionBars() {
        TestNavigator testNavigator = (TestNavigator)this.getNavigator();
        Object currentFrameInput = ((TreeFrame)testNavigator.getFrameList().getCurrentFrame()).getInput();
        this.toggleFolderAction.setEnabled(currentFrameInput == null || testNavigator.getInitialViewerInput() == currentFrameInput);
        this.toggleEObjectChildren.setEnabled(currentFrameInput == null || !(currentFrameInput instanceof EObject));
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection resourceStructuredSelection = this.getResourceSelection(structuredSelection);
        this.propertyDialogAction.setEnabled(structuredSelection.size() == 1);
        this.addBookmarkAction.selectionChanged(resourceStructuredSelection);
        this.deleteResourceAction.selectionChanged(resourceStructuredSelection);
        this.addTaskAction.selectionChanged(structuredSelection);
        this.refreshAction.selectionChanged(structuredSelection);
        this.openProjectAction.selectionChanged(structuredSelection);
        this.closeProjectAction.selectionChanged(structuredSelection);
        this.frameListActionGroup.updateActionBars();
        this.sorterActionGroup.updateActionBars();
        this.newActionGroup.updateActionBars();
        this.workingSetFilterActionGroup.updateActionBars();
    }

    public void runDefaultAction(IStructuredSelection selection) {
        this.openAction.selectionChanged(selection);
        this.openAction.run();
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0 && this.deleteResourceAction.isEnabled()) {
            this.deleteResourceAction.run();
        }
        super.handleKeyPressed(event);
    }

    protected IStructuredSelection getResourceSelection(IStructuredSelection structuredSelection) {
        TestNavigator testNavigator = (TestNavigator)this.getNavigator();
        ArrayList resources = new ArrayList();
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (object instanceof IResource && ((IResource)object).getType() != 1) {
                resources.add(object);
                continue;
            }
            IFile file = testNavigator.getFile(object);
            if (file == null) continue;
            resources.add(file);
        }
        return new StructuredSelection(resources);
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, iconPath + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

