/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.preference;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
ModifyListener {
    private Button openEditorAfterCreationCheckBox;
    private Text saveManagerIntervalText;
    private Text localPort;
    private Text defaultHostName;

    public TestPreferencePage() {
        this.setPreferenceStore(TestUIPlugin.getInstance().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        this.openEditorAfterCreationCheckBox = new Button(composite, 32);
        this.openEditorAfterCreationCheckBox.setText(TestUIPlugin.getString("OPEN_EDITOR_PREF"));
        Composite threeCol = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        threeCol.setLayout((Layout)layout);
        threeCol.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        Label label = new Label(threeCol, 0);
        label.setText(TestUIPlugin.getString("SAVE_INT_PREF"));
        this.saveManagerIntervalText = new Text(threeCol, 2048);
        this.saveManagerIntervalText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        label = new Label(threeCol, 0);
        label.setText(TestUIPlugin.getString("STR_MSEC"));
        Composite twoCol = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.makeColumnsEqualWidth = false;
        twoCol.setLayout((Layout)layout);
        twoCol.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        label = new Label(twoCol, 0);
        label.setText(TestUIPlugin.getString("RAC_LOCALHOST_PORT_TEXT"));
        this.localPort = new Text(twoCol, 2048);
        this.localPort.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.localPort.addModifyListener((ModifyListener)this);
        label = new Label(twoCol, 0);
        label.setText(TestUIPlugin.getString("DEF_HOST_NME"));
        this.defaultHostName = new Text(twoCol, 2048);
        this.defaultHostName.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.defaultHostName.addModifyListener((ModifyListener)this);
        this.initializeValues();
        WorkbenchHelp.setHelp((Control)parent, (String)(TestUIPlugin.getID() + ".tgpp0001"));
        WorkbenchHelp.setHelp((Control)this.defaultHostName, (String)(TestUIPlugin.getID() + ".tgpp0003"));
        WorkbenchHelp.setHelp((Control)this.localPort, (String)(TestUIPlugin.getID() + ".tgpp0004"));
        WorkbenchHelp.setHelp((Control)this.openEditorAfterCreationCheckBox, (String)(TestUIPlugin.getID() + ".tgpp0002"));
        WorkbenchHelp.setHelp((Control)this.saveManagerIntervalText, (String)(TestUIPlugin.getID() + ".tgpp0005"));
        return composite;
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.openEditorAfterCreationCheckBox.setSelection(store.getBoolean("openEditor"));
        this.saveManagerIntervalText.setText(String.valueOf(store.getLong("saveInterval")));
        this.localPort.setText(store.getString("localhost_port"));
        this.defaultHostName.setText(store.getString("default_host_name"));
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return TestUIPlugin.getInstance().getPreferenceStore();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.openEditorAfterCreationCheckBox.setSelection(store.getDefaultBoolean("openEditor"));
        this.saveManagerIntervalText.setText(String.valueOf(store.getDefaultLong("saveInterval")));
        this.localPort.setText(store.getDefaultString("localhost_port"));
        this.defaultHostName.setText(store.getDefaultString("default_host_name"));
    }

    public boolean performOk() {
        this.storeValues();
        TestUIPlugin.getInstance().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("openEditor", this.openEditorAfterCreationCheckBox.getSelection());
        try {
            store.setValue("saveInterval", Long.parseLong(this.saveManagerIntervalText.getText().trim()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        store.setValue("localhost_port", this.localPort.getText().trim());
        store.setValue("default_host_name", this.defaultHostName.getText().trim());
    }

    public void init(IWorkbench workbench) {
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.localPort) {
            try {
                if (this.localPort.getText().trim() == "") {
                    this.setErrorMessage(TestUIPlugin.getString("_ERROR_RAC_EMPTY_PORT"));
                    return;
                }
                int value = Integer.parseInt(this.localPort.getText().trim());
                if (value < 0) {
                    this.setErrorMessage(TestUIPlugin.getString("_ERROR_RAC_INVALID_PORT"));
                    this.localPort.setFocus();
                    return;
                }
                this.setErrorMessage(null);
            }
            catch (NumberFormatException nfe) {
                this.setErrorMessage(TestUIPlugin.getString("_ERROR_RAC_INVALID_PORT"));
                this.localPort.setFocus();
            }
        }
    }
}

