/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.parsers.ApacheAccessLogParser;
import org.eclipse.hyades.logging.parsers.ApacheErrorLogParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.trace.sample.HyadesSamplePlugin;
import org.eclipse.hyades.trace.sample.loganalyzer.AnalyzeCorrelateOperation;
import org.eclipse.hyades.trace.sample.loganalyzer.AnalyzeLogAction;
import org.eclipse.hyades.trace.sample.loganalyzer.CorrelateLogAction;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerCreationPage;
import org.eclipse.hyades.trace.sample.loganalyzer.LogAnalyzerSamplePage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizard;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.CreationWizardPage;
import org.eclipse.hyades.ui.internal.wizard.exampleproject.ZipAdjusterCreationWizard;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class LogAnalyzerCreationWizard
extends ZipAdjusterCreationWizard {
    LogAnalyzerCreationPage pageOne = null;
    LogAnalyzerSamplePage pageTwo = null;
    private ResourceBundle resourceBundle;

    protected void addZipExtensions() {
        this.addZipExtension("trcpxmi");
        this.addZipExtension("trcaxmi");
        this.addZipExtension("trcdbxmi");
        this.setResourceBundle(HyadesSamplePlugin.getInstance().getResourceBundle());
    }

    protected void logError(String error) {
        HyadesSamplePlugin.logError(error);
    }

    protected CreationWizardPage createWizardPage(String suggestedName, IConfigurationElement configurationElement) {
        if (suggestedName.equals("newProject1")) {
            this.pageTwo = new LogAnalyzerSamplePage((CreationWizard)this, suggestedName, configurationElement, this.pageOne);
            return this.pageTwo;
        }
        this.pageOne = new LogAnalyzerCreationPage((CreationWizard)this, suggestedName, configurationElement);
        return this.pageOne;
    }

    public boolean correlateAccessLog(AnalyzeCorrelateOperation aco) {
        CorrelateLogAction runnable = null;
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        TRCMonitor monitor = aco.getTRCMonitor();
        runnable = new CorrelateLogAction();
        runnable.setMofObject((EObject)monitor);
        op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        runnable.dispose();
        return true;
    }

    public boolean analyzeErrorLog(String projectName, String fileName, String symptomDBPath, AnalyzeCorrelateOperation aco) {
        AnalyzeLogAction runnable = null;
        TRCAgentProxy emfObject = aco.getAgent().getAgentProxy();
        runnable = new AnalyzeLogAction();
        runnable.setSymptomDBPath(symptomDBPath);
        runnable.setProjectName(projectName);
        runnable.setSDBFileName(fileName);
        runnable.setMofObject((EObject)emfObject);
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public AnalyzeCorrelateOperation importLogFile(String logFile, Parser parser, String name) {
        INavigator fViewer = null;
        AnalyzeCorrelateOperation runnable = null;
        try {
            IWorkbenchPage page = UIPlugin.getActivePage();
            fViewer = (INavigator)page.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
        }
        catch (Exception e) {
            return null;
        }
        runnable = new AnalyzeCorrelateOperation(parser, name);
        runnable.setFViewer(fViewer);
        runnable.setLogFilePath(logFile);
        runnable.setProjectName(this.pageOne.getProjectName());
        runnable.setTcMonitor("LogCorrelationAnalyzerSample_TCMonitor");
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.handleException(e.getTargetException());
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        runnable.dispose();
        return runnable;
    }

    protected boolean finishWork() {
        AnalyzeCorrelateOperation acoLog = this.importLogFile(this.pageTwo.getLogPath(), (Parser)new ApacheAccessLogParser(), HyadesSamplePlugin.getString("LOG_FILE_LABEL"));
        AnalyzeCorrelateOperation acoErrorLog = this.importLogFile(this.pageTwo.getErrorLogPath(), (Parser)new ApacheErrorLogParser(), HyadesSamplePlugin.getString("ERRORLOG_FILE_LABEL"));
        if (this.pageTwo.getAnalyzeLogButton().getSelection()) {
            this.analyzeErrorLog(this.pageTwo.getProjectName(), this.pageTwo.getSDBFileName(), this.pageTwo.getSymptomDBFilePath(), acoErrorLog);
        }
        if (this.pageTwo.getCorrelateLogButton().getSelection()) {
            this.correlateAccessLog(acoLog);
        }
        return true;
    }

    private void handleException(Throwable throwable) {
        this.logError(CoreUtil.getStackTrace((Throwable)throwable));
        String[] options = new String[]{IDialogConstants.OK_LABEL};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), this.getString("W_ERROR"), null, this.getString("ERR_UNABLE_CREATE"), 1, options, 0);
    }

    protected String getString(String key) {
        if (this.resourceBundle != null) {
            try {
                return this.resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
            }
        }
        return key;
    }

    protected String getString(String key, String[] args) {
        String ret = this.getString(key);
        int i = args.length;
        while (i > 0) {
            ret = StringUtil.replace((String)ret, (String)("%" + i), (String)args[i - 1]);
            --i;
        }
        return ret;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.resourceBundle = bundle;
    }

    public LogAnalyzerSamplePage getPageTwo() {
        return this.pageTwo;
    }
}

