/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.hyades.collection.threadanalyzer.Arg;
import org.eclipse.hyades.collection.threadanalyzer.DummyDialog;
import org.eclipse.hyades.collection.threadanalyzer.TAReaderThread;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaTimedOutException;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ThreadAnalyzer {
    private static ThreadAnalyzer instance = null;
    private static boolean cmdLine = false;
    protected static Hashtable _args = new Hashtable();
    protected static String[] _validArgNames = new String[]{"analyze", "serverName", "was_home", "logLevel", "dumpOut", "dumpWait", "streamIn", "streamOut", "dumpIn", "detailXML", "reportOut", "reportType", "tmpDir", "dbDriver", "dbURL", "dumpType", "soapPort"};
    protected static Properties _pathMap = new Properties();
    protected static String _edition = null;
    public static final int DEBUG = 4;
    public static final int DETAIL = 3;
    public static final int INFO = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 0;
    protected static int _logLevel = 2;
    protected static String _adminClasspath = null;
    protected static String _adminPath = null;
    protected static Properties _adminProperties = null;
    private static DummyDialog myDummyDialog = null;
    private static Process browserProcess = null;

    public static void main(String[] stringArray) {
        instance = new ThreadAnalyzer();
        cmdLine = true;
        myDummyDialog = new DummyDialog();
        try {
            instance.doIt(stringArray);
        }
        catch (TaTimedOutException taTimedOutException) {
            // empty catch block
        }
        System.exit(0);
    }

    public static DummyDialog getDummyDialog() {
        return myDummyDialog;
    }

    public static boolean inCmdLineMode() {
        return cmdLine;
    }

    public boolean doIt(String[] stringArray) throws TaTimedOutException {
        block37: {
            Object object;
            Object object2;
            String string;
            Object object3;
            String string2;
            Vector<String> vector;
            block36: {
                vector = new Vector<String>();
                String string3 = null;
                String string4 = null;
                string2 = null;
                try {
                    object3 = new BufferedReader(new InputStreamReader(System.in));
                    while (((BufferedReader)object3).ready()) {
                        int n;
                        string = ((BufferedReader)object3).readLine();
                        if (string == null || string.length() <= 0 || (n = string.indexOf("=")) == -1) continue;
                        object2 = string.substring(0, n);
                        if (n + 1 > string.length()) continue;
                        object = string.substring(n + 1);
                        if (!((String)object2).equalsIgnoreCase("path")) {
                            vector.add(string);
                        } else {
                            string3 = object;
                        }
                        if (((String)object2).equalsIgnoreCase("was_home")) {
                            string4 = object;
                        }
                        if (!((String)object2).equalsIgnoreCase("java_exe")) continue;
                        string2 = object;
                    }
                }
                catch (IOException iOException) {
                    System.err.println(TAUtils.getNLSValue("ta.errmsg.CannotReadEnv", "Cannot read environment") + ".");
                }
                ThreadAnalyzer.parseArgs(stringArray);
                if (ThreadAnalyzer.getArg("was_home") != null) {
                    string4 = ThreadAnalyzer.getArg("was_home");
                } else {
                    ThreadAnalyzer.putArg("was_home", string4);
                }
                if (string4 == null) {
                    System.err.println("was_home " + TAUtils.getNLSValue("ta.errmsg.NotSet", "not set") + ".");
                    ThreadAnalyzer.syntax();
                }
                object3 = System.getProperty("java.class.path");
                string = (string3 != null ? string3 : "") + System.getProperty("path.separator") + System.getProperty("java.library.path");
                try {
                    ThreadAnalyzer.getProductVersion(string4 + "/properties/com/ibm/websphere/product.xml");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        object2 = new File(string4 + "/properties/version/BASE.product");
                        object = new File(string4 + "/properties/version/embeddedEXPRESS.product");
                        if (!((File)object2).exists() && !((File)object).exists()) {
                            ThreadAnalyzer.logError("WAS 5.0 not detected");
                            throw new FileNotFoundException();
                        }
                        _edition = "BASE";
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                        ThreadAnalyzer.logError("No valid WAS installation detected.");
                        return false;
                    }
                }
                ThreadAnalyzer.logDebug(TAUtils.getNLSValue("ta.logdebug.ProductEdition", "Product edition") + ": " + _edition);
                ThreadAnalyzer.loadWasProps();
                File file = null;
                if (string2 == null) {
                    string2 = ThreadAnalyzer.getWasJavaExe();
                }
                ThreadAnalyzer.logDebug("[ThreadAnalyzer] servername: " + ThreadAnalyzer.getArg("servername"));
                if (ThreadAnalyzer.getArg("servername") != null) {
                    ThreadAnalyzer.logDebug("[ThreadAnalyzer] dumpOut: " + ThreadAnalyzer.getArg("dumpOut"));
                    if (ThreadAnalyzer.getArg("dumpOut") == null) {
                        ThreadAnalyzer.logDebug("[ThreadAnalyzer] dumpOut == null");
                        try {
                            file = ThreadAnalyzer.getArg("tmpDir").equalsIgnoreCase("system") ? File.createTempFile("thread_", ".analyzed") : File.createTempFile("thread_", ".analyzed", new File(ThreadAnalyzer.getArg("tmpDir")));
                            file.deleteOnExit();
                        }
                        catch (IOException iOException) {
                            System.err.println(TAUtils.getNLSValue("ta.errmsg.ErrCreatingTempFile", "Error creating temp file."));
                            iOException.printStackTrace();
                            return false;
                        }
                        _args.put("dumpOut".toUpperCase(), new Arg(file.getPath()));
                    }
                    try {
                        if (!this.getThreadDump(string2, string4, vector, (String)object3, string)) {
                            return false;
                        }
                        break block36;
                    }
                    catch (TaTimedOutException taTimedOutException) {
                        ThreadAnalyzer.logDebug("[ThreadAnalyzer] throwing TaTimedOutException");
                        throw taTimedOutException;
                    }
                }
                _args.put("dumpOut".toUpperCase(), new Arg(ThreadAnalyzer.getArg("dumpIn")));
            }
            if (ThreadAnalyzer.getArg("analyze").equalsIgnoreCase("none")) break block37;
            object2 = new String();
            try {
                if (ThreadAnalyzer.getArg("reportOut").equalsIgnoreCase("default")) {
                    object = ThreadAnalyzer.getArg("dumpOut");
                    object2 = ThreadAnalyzer.getArg("reportType").equalsIgnoreCase("html") ? (String)object + ".html" : (String)object + ".txt";
                } else {
                    object2 = ThreadAnalyzer.getArg("reportOut");
                }
                object = new File((String)object2);
                ThreadAnalyzer.logDebug("[ThreadAnalyzer] deleting: " + (String)object2);
                ((File)object).delete();
                object2 = ((File)object).getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println(TAUtils.getNLSValue("ta.errmsg.ErrorOn", "error on") + " " + (String)object2);
                iOException.getMessage();
            }
            this.parseAndAnalyze(string2, vector, (String)object3, string, (String)object2);
            object = null;
            String string5 = System.getProperty("os.name");
            boolean bl = ThreadAnalyzer.getArg("streamOut") == null && !ThreadAnalyzer.getArg("reportType").equalsIgnoreCase("none");
            File file = new File((String)object2);
            if (bl && file.exists()) {
                ThreadAnalyzer.logInfo(TAUtils.getNLSValue("ta.errmsg.OutputFile", "Output file") + ": " + (String)object2);
            }
            if (ThreadAnalyzer.getArg("StreamOut") == null && ThreadAnalyzer.getArg("reportType").equalsIgnoreCase("html")) {
                if (string5.indexOf("Windows") != -1) {
                    String[] stringArray2 = new String[]{"cmd.exe", "/c", object2};
                    try {
                        ThreadAnalyzer.logInfo("attempting to launch browser...");
                        object = Runtime.getRuntime().exec(stringArray2);
                    }
                    catch (IOException iOException) {
                        System.err.println(TAUtils.getNLSValue("ta.errmsg.CannotStartBrowser", "Cannot start browser") + ".");
                    }
                    new TAReaderThread(((Process)object).getInputStream(), ((Process)object).getErrorStream(), System.out).start();
                } else {
                    String[] stringArray3 = new String[]{"netscape", object2};
                    try {
                        ThreadAnalyzer.logInfo("attempting to launch browser...");
                        object = Runtime.getRuntime().exec(stringArray3);
                        new TAReaderThread(((Process)object).getInputStream(), ((Process)object).getErrorStream(), System.out).start();
                        try {
                            ((Process)object).waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println(TAUtils.getNLSValue("ta.errmsg.CantStartNetscape", "Netscape could not be started"));
                    }
                }
            }
        }
        return true;
    }

    protected void parseAndAnalyze(String string, Vector vector, String string2, String string3, String string4) {
        String[] stringArray = new String[]{"logLevel=" + ThreadAnalyzer.getArg("loglevel"), "dumpIn=" + ThreadAnalyzer.getArg("dumpOut"), "reportType=" + ThreadAnalyzer.getArg("reportType"), "reportOut=" + string4, "analyze=" + (ThreadAnalyzer.getArg("analyze") == null ? "all" : ThreadAnalyzer.getArg("analyze")), ThreadAnalyzer.getArg("StreamOut") == null ? "" : "StreamOut=" + ThreadAnalyzer.getArg("StreamOut")};
        new DumpParser(cmdLine).doIt(stringArray);
    }

    protected boolean getThreadDump(String string, String string2, Vector vector, String string3, String string4) throws TaTimedOutException {
        Runtime runtime = Runtime.getRuntime();
        vector.add("PATH=" + _adminPath + System.getProperty("path.separator") + string4);
        String[] stringArray = new String[]{string, "-classpath", string3, "com.ibm.ws.performance.threadanalyzer.getthreaddump.GetThreadDump", "loglevel=" + ThreadAnalyzer.getArg("loglevel"), "dumpWait=" + ThreadAnalyzer.getArg("dumpWait"), "servername=" + ThreadAnalyzer.getArg("servername"), "was_home=" + string2, "dumpOut=" + ThreadAnalyzer.getArg("dumpOut"), "dumpType=" + ThreadAnalyzer.getArg("dumpType")};
        Object var8_8 = null;
        Object var9_9 = null;
        try {
            String[] stringArray2 = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                stringArray2[n] = (String)vector.elementAt(n);
                ++n;
            }
            String[] stringArray3 = new String[]{"loglevel=" + ThreadAnalyzer.getArg("loglevel"), "dumpWait=" + ThreadAnalyzer.getArg("dumpWait"), "servername=" + ThreadAnalyzer.getArg("servername"), "was_home=" + string2, "dumpOut=" + ThreadAnalyzer.getArg("dumpOut"), "dumpType=" + ThreadAnalyzer.getArg("dumpType")};
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    protected static void loadWasProps() {
        if (_edition == null || _edition.equalsIgnoreCase("BASE")) {
            return;
        }
        if (_edition.equalsIgnoreCase("AEs")) {
            _adminClasspath = "";
            _adminPath = "";
        } else {
            _adminClasspath = ThreadAnalyzer.getAdminProperty("com.ibm.ejs.sm.adminserver.classpath");
            _adminPath = ThreadAnalyzer.getAdminProperty("com.ibm.ejs.sm.util.process.Nanny.path");
        }
    }

    protected static String getWasJavaExe() {
        String string = null;
        if (_edition.equalsIgnoreCase("AEs") || _edition.equalsIgnoreCase("BASE")) {
            string = ThreadAnalyzer.getArg("WAS_HOME") + "/java/jre/bin/java";
        } else {
            string = ThreadAnalyzer.getAdminProperty("com.ibm.ws.jdkexe.path");
            if (string == null && (string = ThreadAnalyzer.getAdminProperty("com.ibm.ws.jdk.path")) != null) {
                string = string + "/bin/java";
            }
        }
        File file = new File(string);
        string = file.getAbsolutePath();
        return string;
    }

    public static void traverse(Node node, Node node2, String string, String string2) {
        if (node2 == node) {
            return;
        }
        if (node == null) {
            node = node2;
        }
        Node node3 = node2.getFirstChild();
        while (node3 != null) {
            Object object;
            int n;
            Object object2;
            String string3 = node3.getNodeName();
            if (string3.equalsIgnoreCase("edition") && string.equals("edition")) {
                ThreadAnalyzer.logDebug("!!!!edition!!!!");
                ThreadAnalyzer.traverse(node, node2, "value", "");
                return;
            }
            if (string3.equalsIgnoreCase("value") && string.equals("value")) {
                ThreadAnalyzer.logDebug("!!!!value!!!!");
                ThreadAnalyzer.logDebug("nodeName = " + string3);
                object2 = node2.getChildNodes();
                ThreadAnalyzer.logDebug("children = " + object2.getLength());
                n = 0;
                while (n < object2.getLength()) {
                    object = object2.item(n).getNodeName();
                    ThreadAnalyzer.logDebug("nodeNm[" + n + "] = " + (String)object);
                    if (((String)object).equals("value")) {
                        _edition = ((CharacterData)object2.item(n).getFirstChild()).getData();
                    }
                    ++n;
                }
                return;
            }
            if (string3.equalsIgnoreCase("servers") && string.equals("servers")) {
                ThreadAnalyzer.logDebug("!!!!servers!!!!");
                object2 = node3.getAttributes();
                ThreadAnalyzer.logDebug(":=> " + object2.getNamedItem("name"));
                if (object2.getNamedItem("name").getNodeValue().equalsIgnoreCase(string2)) {
                    ThreadAnalyzer.traverse(node, node3, "ioRedirect", "");
                }
                return;
            }
            if (string3.equalsIgnoreCase("pathMap") && string.equals("pathMap")) {
                Object object3;
                String string4;
                Object object4;
                ThreadAnalyzer.logDebug("!!!!pathMap!!!!");
                object2 = node3.getChildNodes();
                n = 0;
                while (n < object2.getLength()) {
                    object = object2.item(n).getAttributes();
                    if (object != null && (object4 = object.getNamedItem("symbolicName")) != null) {
                        string4 = object4.getNodeValue();
                        object3 = object.getNamedItem("path").getNodeValue();
                        ThreadAnalyzer.logDebug(string4 + "=" + (String)object3);
                        _pathMap.put(string4, object3);
                    }
                    ++n;
                }
                ThreadAnalyzer.logDebug("---Translated paths---");
                object = _pathMap.keys();
                object4 = null;
                while (object.hasMoreElements()) {
                    object4 = (String)object.nextElement();
                    string4 = _pathMap.getProperty((String)object4);
                    string4 = ThreadAnalyzer.replacePathVar(_pathMap, string4);
                    object3 = new File(string4);
                    String string5 = null;
                    try {
                        string5 = ((File)object3).getCanonicalPath();
                    }
                    catch (Throwable throwable) {
                        string5 = "?????";
                    }
                    ThreadAnalyzer.logDebug((String)object4 + "=" + string5);
                }
                ThreadAnalyzer.logDebug("------");
            }
            ThreadAnalyzer.traverse(node, node3, string, string2);
            node3 = node3.getNextSibling();
        }
    }

    public static String replacePathVar(Properties properties, String string) {
        String string2 = null;
        int n = -1;
        while ((n = string.indexOf("${")) != -1) {
            int n2 = string.indexOf("}");
            if (n2 == -1) continue;
            string2 = string.substring(n + 2, n2);
            String string3 = properties.getProperty(string2);
            ThreadAnalyzer.logDebug(string2 + " is " + string3);
            String string4 = null;
            if (n > 0) {
                string4 = string.substring(0, n);
                string4 = string4 + string3;
            } else {
                string4 = string3;
            }
            string = string4 = string4 + string.substring(n2 + 1);
        }
        return string;
    }

    public static void getProductVersion(String string) throws FileNotFoundException {
        Object object;
        Object object2;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            object2 = new File(string);
            if (!((File)object2).exists()) {
                ThreadAnalyzer.logDebug("[ThreadAnalyzer] " + TAUtils.getNLSValue("ta.errmsg.FileDoesntExist", "File doesn't exist") + ": " + object2);
                throw new FileNotFoundException();
            }
            documentBuilderFactory.setValidating(false);
            object = documentBuilderFactory.newDocumentBuilder();
            URL uRL = ((File)object2).toURL();
            document = ((DocumentBuilder)object).parse(uRL.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            ThreadAnalyzer.logDebug(TAUtils.getNLSValue("ta.errmsg.XmlParseError", "XML parse error or XML input file not found") + ".  --" + exception.getMessage());
            exception.printStackTrace();
        }
        object2 = document.getDocumentElement();
        if (object2 == null) {
            ThreadAnalyzer.logError(TAUtils.getNLSValue("ta.errmsg.CantReadXmlConfig", "Unable to read configuration xml document") + ".");
        }
        object = null;
        object = object2.getElementsByTagName("websphere");
        ThreadAnalyzer.traverse(null, (Node)object2, "edition", "");
        ThreadAnalyzer.traverse(null, (Node)object2, "version", "");
    }

    protected static void logDebug(String string) {
        if (_logLevel >= 4) {
            System.err.println("DEBUG: " + string);
        }
    }

    protected static void logError(String string) {
        System.err.println(TAUtils.getNLSValue("ta.button.Error", "ERROR") + ": " + string);
    }

    protected static void logInfo(String string) {
        if (_logLevel >= 2) {
            System.err.println("INFO: " + string);
        }
    }

    protected static String getAdminProperty(String string) {
        String string2;
        if (_adminProperties == null) {
            string2 = ThreadAnalyzer.getArg("was_home");
            String string3 = string2 + "/bin/admin.config";
            _adminProperties = new Properties();
            try {
                _adminProperties.load(new FileInputStream(string3));
            }
            catch (IOException iOException) {
                System.err.println(TAUtils.getNLSValue("ta.errmsg.CannotLoad", "Cannot load") + " " + string3);
            }
        }
        string2 = _adminProperties.getProperty(string);
        return string2;
    }

    protected static void syntax() {
        System.out.println("ThreadAnalyzer");
        System.out.println("    " + TAUtils.getNLSValue("ta.string.syntax", "syntax") + ":");
        System.out.println("       { was_home=path to WebSphere (default from environment) }");
        System.out.println("       { serverName={servername | admin} }");
        System.out.println("       [ soapPort=portNumber (default is 8880) ]");
        System.out.println("       [ dumpOut=filename ] (default is temporary file)");
        System.out.println("       [ dumpWait=waitSeconds ] (time to wait for threaddump to complete) ");
        System.out.println("       [ reportType={ TEXT | HTML | NONE } ( default is HTML ) ] ");
        System.out.println("       [ logLevel={ERROR | DETAIL | DEBUG} ] (default:DETAIL)");
        System.out.println("       [ dumpIn=filename ]");
        System.out.println("       [ tmpDir={ dirname | SYSTEM } (default: SYSTEM) ]");
        System.out.println("       [ reportOut={ DEFAULT | filename } ] (default is [dumpOut].html) ");
        System.out.println("       [ dbDriver={JDBC driver class name} ]");
        System.out.println("       [ dbURL={JDBC server/database URL} ]");
        System.out.println();
    }

    public static String getArg(String string) {
        String string2 = null;
        Arg arg = (Arg)_args.get(string.toUpperCase());
        if (arg != null) {
            string2 = arg.get();
        } else {
            System.err.println(TAUtils.getNLSValue("ta.errmsg.CantFind", "can't find") + ": " + string.toUpperCase());
        }
        return string2;
    }

    public static void putArg(String string, String string2) {
        _args.put(string.toUpperCase(), new Arg(string2));
    }

    protected static void parseArgs(String[] stringArray) {
        String string;
        String string2;
        int n = 0;
        while (n < _validArgNames.length) {
            string2 = null;
            if (_validArgNames[n].equals("dumpWait")) {
                string2 = "45";
            }
            if (_validArgNames[n].equals("detailXML")) {
                string2 = "./threadanalyzerdetail.xml";
            }
            if (_validArgNames[n].equals("reportOut")) {
                string2 = "default";
            }
            if (_validArgNames[n].equals("reportType")) {
                string2 = "html";
            }
            if (_validArgNames[n].equals("logLevel")) {
                string2 = "detail";
            }
            if (_validArgNames[n].equals("analyze")) {
                string2 = "all";
            }
            if (_validArgNames[n].equals("tmpDir")) {
                string2 = "SYSTEM";
            }
            if (_validArgNames[n].equals("dumpType")) {
                string2 = "old";
            }
            if (_validArgNames[n].equals("soapPort")) {
                string2 = "8880";
            }
            _args.put(_validArgNames[n].toUpperCase(), new Arg(string2));
            ++n;
        }
        string2 = null;
        String string3 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3 = stringArray[n2].indexOf("=");
            if (n3 > -1) {
                string3 = stringArray[n2].substring(0, n3);
                if (_args.get(string3.toUpperCase()) != null) {
                    String string4 = null;
                    n3 = stringArray[n2].toUpperCase().indexOf(string3.toUpperCase() + "=");
                    if (n3 == -1) {
                        ThreadAnalyzer.syntax();
                    }
                    if ((string4 = stringArray[n2].substring((n3 = stringArray[n2].indexOf("=")) + 1)).length() <= 0) {
                        ThreadAnalyzer.syntax();
                    }
                    if (string3.equalsIgnoreCase("logLevel")) {
                        if (string4.equalsIgnoreCase("ERROR")) {
                            _logLevel = 0;
                        } else if (string4.equalsIgnoreCase("WARN")) {
                            _logLevel = 1;
                        } else if (string4.equalsIgnoreCase("INFO")) {
                            _logLevel = 2;
                        } else if (string4.equalsIgnoreCase("DETAIL")) {
                            _logLevel = 3;
                        } else if (string4.equalsIgnoreCase("DEBUG")) {
                            _logLevel = 4;
                        } else {
                            ThreadAnalyzer.syntax();
                        }
                    }
                    _args.put(string3.toUpperCase(), new Arg(string4));
                } else {
                    System.out.println(TAUtils.getNLSValue("ta.errmsg.InvalidArg", "Invalid argument") + ": " + string3);
                }
            }
            ++n2;
        }
        if (ThreadAnalyzer.getArg("servername") == null && ThreadAnalyzer.getArg("dumpIn") == null) {
            System.err.println(TAUtils.getNLSValue("ta.errmsg.MustSpecifyServName", "serverName or dumpIn must be specified"));
            ThreadAnalyzer.syntax();
            System.exit(1);
        }
        if ((string = ThreadAnalyzer.getArg("WAS_HOME")) == null) {
            string = System.getProperty("WAS_HOME");
        }
        if (string != null) {
            _args.put("WAS_HOME", new Arg(string));
        }
    }
}

