/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;

public final class Guid {
    private static final char[] HEXADECIMAL_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final long UTC_OFFSET = 122192928000000000L;
    private static final short GUID_VERSION_1 = 4096;
    private static final byte GUID_RESERVED = -64;
    private static final int MAX_CLOCK_SEQ_ADJUST = 9999;
    private static final long MAX_WAIT_TIME = 1000L;
    private static final Object lockObject = new Object();
    private static boolean _internalsSet = false;
    private static long _lastTimestamp = 0L;
    private static int _clock_seq_adjust = 0;
    private static int _osProcessId = 0;
    private static int _rand_ia = 0;
    private static int _rand_ib = 0;
    private static int _rand_irand = 0;
    private static int _rand_m = 0;
    private static long clockSeq = 0L;
    private int time_low = 0;
    private short time_mid = 0;
    private short time_hi_and_version = 0;
    private byte clock_seq_hi_and_reserved = 0;
    private byte clock_seq_low = 0;
    private static byte[] _ieee802Addr = new byte[6];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Guid() {
        long adjustedTimestamp = 0L;
        Object object = lockObject;
        synchronized (object) {
            if (!_internalsSet) {
                this.getPseudoIEEE802Address(_ieee802Addr);
                _osProcessId = this.getPseudoOSProcessId();
                this.initTrueRandom(this.getAdjustedTimestamp());
                clockSeq = this.getTrueRandom();
                _internalsSet = true;
            }
            boolean timeIsValid = true;
            do {
                if ((adjustedTimestamp = this.getAdjustedTimestamp()) < _lastTimestamp) {
                    clockSeq = this.getTrueRandom();
                    _clock_seq_adjust = 0;
                }
                if (adjustedTimestamp > _lastTimestamp) {
                    _clock_seq_adjust = 0;
                }
                if (adjustedTimestamp != _lastTimestamp) continue;
                if (_clock_seq_adjust < 9999) {
                    ++_clock_seq_adjust;
                    continue;
                }
                timeIsValid = false;
            } while (!timeIsValid);
            _lastTimestamp = adjustedTimestamp;
            if (_clock_seq_adjust != 0) {
                adjustedTimestamp += (long)_clock_seq_adjust;
            }
            long tempValue = adjustedTimestamp & 0xFFFFFFFFFFFFFFFFL;
            this.time_low = (int)tempValue;
            tempValue = adjustedTimestamp >>> 32 & 0xFFFFL;
            this.time_mid = (short)tempValue;
            tempValue = adjustedTimestamp >>> 48 & 0xFFFL;
            this.time_hi_and_version = (short)tempValue;
            this.time_hi_and_version = (short)(this.time_hi_and_version | 0x1000);
            tempValue = clockSeq & 0xFFL;
            this.clock_seq_low = (byte)tempValue;
            tempValue = (clockSeq & 0x3F00L) >>> 8;
            this.clock_seq_hi_and_reserved = (byte)tempValue;
            this.clock_seq_hi_and_reserved = (byte)(this.clock_seq_hi_and_reserved | 0xFFFFFFC0);
        }
    }

    private synchronized void initTrueRandom(long adjustedTimestamp) {
        _rand_m = 971;
        _rand_ia = 11113;
        _rand_ib = 104322;
        _rand_irand = 4181;
        int seed = (int)(adjustedTimestamp >>> 48) ^ (int)(adjustedTimestamp >>> 32) ^ (int)(adjustedTimestamp >>> 16) ^ (int)(adjustedTimestamp & 0xFFFFL);
        _rand_irand = _rand_irand + seed + _osProcessId;
    }

    private synchronized short getTrueRandom() {
        _rand_ia += 1907;
        _rand_ib += 73939;
        if ((_rand_m += 7) >= 9973) {
            _rand_m -= 9871;
        }
        if (_rand_ia >= 99991) {
            _rand_ia -= 89989;
        }
        if (_rand_ib >= 224729) {
            _rand_ib -= 96233;
        }
        _rand_irand = _rand_irand * _rand_m + _rand_ia + _rand_ib;
        _rand_irand = _rand_irand >>> 16 ^ _rand_irand & 0x3FFF;
        return (short)_rand_irand;
    }

    private synchronized int getPseudoOSProcessId() {
        return (int)(this.getUniqueTimeStamp() % 1000000000L);
    }

    private synchronized void getPseudoIEEE802Address(byte[] ieee802Addr) {
        byte[] currentTime = String.valueOf(this.getUniqueTimeStamp()).getBytes();
        byte[] localHostAddress = this.getLocalHostAddress();
        byte[] inMemObj = new Object().toString().getBytes();
        byte[] freeMemory = String.valueOf(Runtime.getRuntime().freeMemory()).getBytes();
        byte[] totalMemory = String.valueOf(Runtime.getRuntime().totalMemory()).getBytes();
        byte[] hashcode = null;
        byte[] bytes = new byte[freeMemory.length + totalMemory.length + currentTime.length + localHostAddress.length + inMemObj.length];
        int bytesPos = 0;
        System.arraycopy(currentTime, 0, bytes, bytesPos, currentTime.length);
        System.arraycopy(localHostAddress, 0, bytes, bytesPos += currentTime.length, localHostAddress.length);
        System.arraycopy(inMemObj, 0, bytes, bytesPos += localHostAddress.length, inMemObj.length);
        System.arraycopy(freeMemory, 0, bytes, bytesPos += inMemObj.length, freeMemory.length);
        System.arraycopy(totalMemory, 0, bytes, bytesPos += freeMemory.length, totalMemory.length);
        bytesPos += totalMemory.length;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            hashcode = md5.digest(bytes);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.arraycopy(hashcode, 0, ieee802Addr, 0, 6);
        ieee802Addr[0] = (byte)(ieee802Addr[0] | 0x80);
    }

    private synchronized byte[] getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException u) {
            return new byte[]{127, 0, 0, 1};
        }
    }

    private synchronized long getAdjustedTimestamp() {
        return System.currentTimeMillis() * 10000L + 122192928000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized long getUniqueTimeStamp() {
        block20: {
            block19: {
                lockFile = new File(System.getProperty("java.io.tmpdir"), "guid.lock");
                timeStamp = System.currentTimeMillis();
                try {
                    try {
                        block18: {
                            lastModified = lockFile.lastModified();
                            maxWaitTimeStamp = System.currentTimeMillis() + 1000L;
                            block13: while (true) {
                                try {
                                    while (!lockFile.createNewFile()) {
                                        if (System.currentTimeMillis() <= maxWaitTimeStamp) continue;
                                        if (lockFile.lastModified() <= lastModified) {
                                            lockFile.delete();
                                            lastModified = -1L;
                                            continue;
                                        }
                                        var8_7 = System.currentTimeMillis();
                                        break block13;
                                    }
                                    break block18;
                                }
                                catch (IOException i) {
                                    continue;
                                }
                                break;
                            }
                            var11_9 = null;
                            break block19;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        timeStamp = System.currentTimeMillis();
                        break block20;
                    }
                    catch (SecurityException s) {
                        var11_11 = null;
                        try {
                            if (lockFile == null) return timeStamp;
                            lockFile.delete();
                            return timeStamp;
                        }
                        catch (SecurityException s) {
                            return timeStamp;
                        }
                    }
                }
                catch (Throwable var10_17) {
                    var11_12 = null;
                    ** try [egrp 4[TRYBLOCK] [9 : 143->155)] { 
lbl45:
                    // 1 sources

                    if (lockFile == null) throw var10_17;
                    lockFile.delete();
                    throw var10_17;
lbl49:
                    // 1 sources

                    catch (SecurityException s) {
                        // empty catch block
                    }
                    throw var10_17;
                }
            }
            try {}
            catch (SecurityException s) {
                // empty catch block
                return var8_7;
            }
            if (lockFile == null) return var8_7;
            lockFile.delete();
            return var8_7;
        }
        var11_10 = null;
        try {}
        catch (SecurityException s) {}
        if (lockFile == null) return timeStamp;
        lockFile.delete();
        return timeStamp;
        return timeStamp;
    }

    public String toString() {
        char[] stringBuffer = new char[32];
        int pos = 0;
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clock_seq_hi_and_reserved >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clock_seq_hi_and_reserved & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clock_seq_low >>> 4 & 0xF];
        stringBuffer[pos++] = HEXADECIMAL_CHARACTERS[this.clock_seq_low & 0xF];
        int i = 0;
        while (pos < 16) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[_ieee802Addr[i] >>> 4 & 0xF];
            stringBuffer[pos + 1] = HEXADECIMAL_CHARACTERS[_ieee802Addr[i] & 0xF];
            ++i;
            pos += 2;
        }
        int shift = 28;
        while (pos < 24) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.time_low >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 12;
        while (pos < 28) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.time_mid >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        shift = 12;
        while (pos < 32) {
            stringBuffer[pos] = HEXADECIMAL_CHARACTERS[this.time_hi_and_version >>> shift & 0xF];
            shift -= 4;
            ++pos;
        }
        return new String(stringBuffer).trim();
    }

    public static String generate() {
        return new Guid().toString();
    }
}

