/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;
import org.eclipse.hyades.internal.execution.local.common.RAString;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;

public class PropertyListCommand
extends CommandElement
implements Constants {
    protected int size = 0;
    protected Vector names = new Vector();
    protected Vector types = new Vector();
    protected Vector values = new Vector();

    public PropertyListCommand() {
        this._tag = 42L;
    }

    public int getPropertyListLength() {
        return this.size;
    }

    public SetNVPairCommand[] getPropertyListValues() {
        SetNVPairCommand[] results = new SetNVPairCommand[this.size];
        int i = 0;
        while (i < this.size) {
            results[i] = new SetNVPairCommand();
            results[i].setName(((RAString)this.names.elementAt(i)).getData());
            results[i].setType(((RAString)this.types.elementAt(i)).getData());
            results[i].setValue(((RAString)this.values.elementAt(i)).getData());
            ++i;
        }
        return results;
    }

    public int readFromBuffer(byte[] buffer, int offset) {
        int current = offset;
        this._context = Message.readRALongFromBuffer(buffer, current);
        this.size = (int)Message.readRALongFromBuffer(buffer, current += 4);
        current += 4;
        int i = 0;
        while (i < this.size) {
            RAString name = new RAString("");
            RAString type = new RAString("");
            RAString value = new RAString("");
            current = Message.readRAStringFromBuffer(buffer, current, name);
            current = Message.readRAStringFromBuffer(buffer, current, type);
            current = Message.readRAStringFromBuffer(buffer, current, value);
            this.names.addElement(name);
            this.types.addElement(type);
            this.values.addElement(value);
            ++i;
        }
        return current;
    }

    public int writeToBuffer(byte[] buffer, int offset) {
        int current = offset;
        current = Message.writeRALongToBuffer(buffer, current, this._tag);
        current = Message.writeRALongToBuffer(buffer, current, this._context);
        current = Message.writeRALongToBuffer(buffer, current, this.size);
        int i = 0;
        while (i < this.size) {
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this.names.elementAt(i));
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this.types.elementAt(i));
            current = Message.writeRAStringToBuffer(buffer, current, (RAString)this.values.elementAt(i));
            ++i;
        }
        return current;
    }

    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        int i = 0;
        while (i < size) {
            size += ((RAString)this.names.elementAt(i)).getSize();
            size += ((RAString)this.types.elementAt(i)).getSize();
            size += ((RAString)this.values.elementAt(i)).getSize();
            ++i;
        }
        return size;
    }
}

