/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.Messages;

public class DPLEquivalenceClassImpl
extends CMNNamedElementImpl
implements DPLEquivalenceClass {
    public static final String copyright = "";
    protected EList records = null;
    static /* synthetic */ Class class$org$eclipse$hyades$models$common$datapool$DPLRecord;

    protected DPLEquivalenceClassImpl() {
    }

    protected EClass eStaticClass() {
        return Common_DatapoolPackage.eINSTANCE.getDPLEquivalenceClass();
    }

    public EList getRecords() {
        if (this.records == null) {
            this.records = new EObjectContainmentEList(class$org$eclipse$hyades$models$common$datapool$DPLRecord == null ? (class$org$eclipse$hyades$models$common$datapool$DPLRecord = DPLEquivalenceClassImpl.class$("org.eclipse.hyades.models.common.datapool.DPLRecord")) : class$org$eclipse$hyades$models$common$datapool$DPLRecord, (InternalEObject)this, 3);
        }
        return this.records;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    return ((InternalEList)this.getRecords()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getRecords();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setId((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.getRecords().clear();
                this.getRecords().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setId(CMNNamedElementImpl.ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(CMNNamedElementImpl.DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setName(CMNNamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.getRecords().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return CMNNamedElementImpl.ID_EDEFAULT == null ? this.id != null : !CMNNamedElementImpl.ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return CMNNamedElementImpl.DESCRIPTION_EDEFAULT == null ? this.description != null : !CMNNamedElementImpl.DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return CMNNamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !CMNNamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return this.records != null && !this.records.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public IDatapoolRecord constructRecord() {
        return this.constructRecord(null);
    }

    public IDatapoolRecord constructRecord(Object[] elements) {
        DPLRecord rec = Common_DatapoolFactory.eINSTANCE.createDPLRecord();
        DPLDatapool datapool = (DPLDatapool)this.eContainer;
        if (datapool == null) {
            return null;
        }
        EList variables = datapool.getDatapoolSpec().getVariables();
        ListIterator it = variables.listIterator();
        int elementIndex = 0;
        while (it.hasNext()) {
            DPLCell newCell = Common_DatapoolFactory.eINSTANCE.createDPLCell();
            newCell.setVariable((DPLVariable)it.next());
            rec.getCells().add((Object)newCell);
            if (elements != null && elementIndex < elements.length) {
                newCell.setCellValue((String)elements[elementIndex++]);
                continue;
            }
            newCell.setValue(null);
        }
        return rec;
    }

    public void insertRecord(IDatapoolRecord data, int beforeRecord) {
        this.insertRecordDoNotNotify(data, beforeRecord);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
        if (l != null) {
            l.recordAdded((IDatapool)dp, dp.getEquivalenceClasses().indexOf((Object)this), beforeRecord);
        }
    }

    public void insertRecordDoNotNotify(IDatapoolRecord data, int beforeRecord) {
        ListIterator recIter = this.getRecords().listIterator();
        while (recIter.hasNext()) {
            if (!((DPLRecord)recIter.next()).equals(data)) continue;
            throw new DatapoolException(Messages.getString("DPLEquivalenceClassImpl.1"));
        }
        this.getRecords().add(beforeRecord, (Object)data);
    }

    public void appendRecord(IDatapoolRecord record) {
        this.insertRecord(record, this.getRecords().size());
    }

    public void replaceRecord(IDatapoolRecord data, int recordIndex) {
        this.removeRecordDoNotNotify(recordIndex);
        this.insertRecordDoNotNotify(data, recordIndex);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
        if (l != null) {
            l.recordChanged((IDatapool)dp, dp.getEquivalenceClasses().indexOf((Object)this), recordIndex);
        }
    }

    public IDatapoolRecord removeRecord(int recordIndex) {
        IDatapoolRecord removedRecord = this.removeRecordDoNotNotify(recordIndex);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
        if (l != null) {
            l.recordRemoved((IDatapool)dp, dp.getEquivalenceClasses().indexOf((Object)this), recordIndex);
        }
        return removedRecord;
    }

    protected IDatapoolRecord removeRecordDoNotNotify(int recordIndex) {
        IDatapoolRecord removedRecord = (IDatapoolRecord)this.getRecords().remove(recordIndex);
        return removedRecord;
    }

    public void moveRecord(int sourceRecordIndex, int targetRecordIndex) {
        IDatapoolRecord rec = this.removeRecordDoNotNotify(sourceRecordIndex);
        this.insertRecordDoNotNotify(rec, targetRecordIndex);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
        if (l != null) {
            l.recordMoved((IDatapool)dp, dp.getEquivalenceClasses().indexOf((Object)this), sourceRecordIndex, targetRecordIndex);
        }
    }

    public void reorder(int[] recordOrder) {
        LinkedList<Object> list = new LinkedList<Object>();
        if (recordOrder.length != this.getRecordCount()) {
            throw new DatapoolException(Messages.getString("DPLEquivalenceClassImpl.2"));
        }
        int i = 0;
        while (i < recordOrder.length) {
            list.add(this.getRecords().get(recordOrder[i]));
            ++i;
        }
        this.getRecords().clear();
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            this.insertRecordDoNotNotify((IDatapoolRecord)it.next(), this.getRecords().size());
        }
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
        int equivalenceClassIndex = dp.getEquivalenceClasses().indexOf((Object)this);
        if (l != null) {
            l.equivalenceClassReordered((IDatapool)dp, equivalenceClassIndex);
        }
    }

    public int getRecordCount() {
        return this.getRecords().size();
    }

    public org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord getRecord(int record) {
        return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord)this.getRecords().get(record);
    }

    public org.eclipse.hyades.execution.runtime.datapool.IDatapool getDatapool() {
        return (org.eclipse.hyades.execution.runtime.datapool.IDatapool)this.eContainer();
    }

    public void setName(String name) {
        super.setName(name);
        DPLDatapool dp = (DPLDatapool)this.eContainer();
        if (dp == null) {
            return;
        }
        IDatapoolListener l = ((DPLDatapoolImpl)dp).getDatapoolListener();
        if (l != null) {
            l.equivalenceClassChanged((IDatapool)dp, dp.getEquivalenceClasses().indexOf((Object)this));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

