/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.core.DeserializationException;
import org.eclipse.hyades.logging.core.SerializationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlUtility
implements Constants {
    private static DocumentBuilder documentBuilder = null;
    private static boolean isJAXPAvailable = true;
    private static final String DEFAULT_ENCODING = "UTF-8";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Writer;
    static /* synthetic */ Class class$org$w3c$dom$Document;

    public static String serialize(Document document) throws SerializationException {
        return XmlUtility.serialize(document, true);
    }

    public static String serialize(Document document, boolean bl) throws SerializationException {
        return XmlUtility.serialize(document, bl, DEFAULT_ENCODING);
    }

    public static String serialize(Document document, boolean bl, String string) throws SerializationException {
        try {
            return new String(XmlUtility.serializeAsByteArray(document, bl, string), string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SerializationException(unsupportedEncodingException.getMessage());
        }
    }

    public static void serialize(Document document, File file) throws SerializationException {
        XmlUtility.serialize(document, file, true);
    }

    public static void serialize(Document document, File file, boolean bl) throws SerializationException {
        XmlUtility.serialize(document, file, bl, DEFAULT_ENCODING);
    }

    public static void serialize(Document document, File file, boolean bl, String string) throws SerializationException {
        try {
            XmlUtility.serialize(document, new FileOutputStream(file), bl, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SerializationException(fileNotFoundException.getMessage());
        }
    }

    public static void serialize(Document document, OutputStream outputStream) throws SerializationException {
        XmlUtility.serialize(document, outputStream, true);
    }

    public static void serialize(Document document, OutputStream outputStream, boolean bl) throws SerializationException {
        XmlUtility.serialize(document, outputStream, bl, DEFAULT_ENCODING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Document document, OutputStream outputStream, boolean bl, String string) throws SerializationException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string);
                XmlUtility.serialize(document, outputStreamWriter, bl, string);
            }
            catch (Exception exception) {
                throw new SerializationException(exception.getMessage());
            }
            Object var7_5 = null;
            if (outputStreamWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                ((Writer)outputStreamWriter).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((Writer)outputStreamWriter).close();
        return;
    }

    public static byte[] serializeAsByteArray(Document document) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, true);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl) throws SerializationException {
        return XmlUtility.serializeAsByteArray(document, bl, DEFAULT_ENCODING);
    }

    public static byte[] serializeAsByteArray(Document document, boolean bl, String string) throws SerializationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtility.serialize(document, byteArrayOutputStream, bl, string);
        return byteArrayOutputStream.toByteArray();
    }

    public static void serialize(Document document, Writer writer) throws SerializationException {
        XmlUtility.serialize(document, writer, true);
    }

    public static void serialize(Document document, Writer writer, boolean bl) throws SerializationException {
        try {
            XmlUtility.serialize(document, writer, bl, ((OutputStreamWriter)writer).getEncoding());
        }
        catch (ClassCastException classCastException) {
            XmlUtility.serialize(document, writer, bl, DEFAULT_ENCODING);
        }
    }

    public static void serialize(Document document, Writer writer, boolean bl, String string) throws SerializationException {
        if (isJAXPAvailable) {
            try {
                JAXPXMLSerializer.serialize(document, writer, bl, Charset.forName(string).name());
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                isJAXPAvailable = false;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                isJAXPAvailable = false;
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                isJAXPAvailable = false;
            }
            catch (Exception exception) {
                throw new SerializationException(exception.toString());
            }
        }
        try {
            XercesXMLSerializer.serialize(document, writer, bl, Charset.forName(string).name());
        }
        catch (Exception exception) {
            throw new SerializationException(exception.toString());
        }
    }

    public static Document deserialize(String string) throws DeserializationException {
        return XmlUtility.deserialize(new InputSource(new StringReader(string)));
    }

    public static Document deserialize(File file) throws DeserializationException {
        try {
            return XmlUtility.deserialize(new InputSource(new FileInputStream(file)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DeserializationException(fileNotFoundException.toString());
        }
    }

    public static Document deserialize(InputStream inputStream) throws DeserializationException {
        return XmlUtility.deserialize(new InputSource(inputStream));
    }

    public static Document deserialize(InputSource inputSource) throws DeserializationException {
        try {
            if (documentBuilder == null) {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            return documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new DeserializationException(exception.toString());
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return "null";
        }
        int n = string.length();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '\t') {
                stringBuffer.append("&#x9;");
            } else if (c == '\n') {
                stringBuffer.append("&#xA;");
            } else if (c == '\r') {
                stringBuffer.append("&#xD;");
            } else if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') {
                stringBuffer.append(c);
            } else if (c >= '\u0001' && c <= '\u0010' && n2 + 1 < n) {
                stringBuffer.append(c);
                stringBuffer.append(string.charAt(++n2));
            } else {
                stringBuffer.append('?');
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String denormalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = '\u0000';
        int n = -1;
        String string2 = null;
        int n2 = 0;
        while (n2 < string.length()) {
            c = string.charAt(n2);
            if (c == '&' && (n = string.indexOf(59, n2 + 1)) != -1) {
                string2 = string.substring(n2 + 1, n).trim();
                if (string2.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string2.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string2.equals("amp")) {
                    stringBuffer.append('&');
                } else if (string2.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string2.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string2.equals("#x9") || string2.equals("#09")) {
                    stringBuffer.append('\t');
                } else if (string2.equals("#xA") || string2.equals("#10")) {
                    stringBuffer.append('\n');
                } else if (string2.equals("#xD") || string2.equals("#13")) {
                    stringBuffer.append('\r');
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string2);
                    stringBuffer.append(';');
                }
                n2 = n;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void removeIgnorableWhitespace(Node node) {
        if (node != null) {
            Object object;
            if (node.getNodeType() == 3 && (object = node.getNodeValue()) != null && ((String)object).trim().length() == 0) {
                node.setNodeValue(((String)object).trim());
            }
            object = node.getFirstChild();
            while (object != null) {
                XmlUtility.removeIgnorableWhitespace((Node)object);
                object = object.getNextSibling();
            }
        }
    }

    static /* synthetic */ void access$200(Node node) {
        XmlUtility.removeIgnorableWhitespace(node);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class XercesXMLSerializer
    implements Constants {
        private static Object outputFormat = null;

        private XercesXMLSerializer() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private static void serialize(Document var0, Writer var1_1, boolean var2_2, String var3_3) throws Exception {
            block9: {
                block11: {
                    block12: {
                        block10: {
                            if (XercesXMLSerializer.outputFormat == null) {
                                var4_4 = Class.forName("org.apache.xml.serialize.OutputFormat");
                                XercesXMLSerializer.outputFormat = var4_4.newInstance();
                                var4_4.getMethod("setMethod", new Class[]{XmlUtility.class$java$lang$String == null ? (XmlUtility.class$java$lang$String = XmlUtility.class$("java.lang.String")) : XmlUtility.class$java$lang$String}).invoke(XercesXMLSerializer.outputFormat, new Object[]{"xml"});
                                var4_4.getMethod("setOmitXMLDeclaration", new Class[]{Boolean.TYPE}).invoke(XercesXMLSerializer.outputFormat, new Object[]{Boolean.TRUE});
                                var4_4.getMethod("setOmitDocumentType", new Class[]{Boolean.TYPE}).invoke(XercesXMLSerializer.outputFormat, new Object[]{Boolean.TRUE});
                                var4_4.getMethod("setLineWidth", new Class[]{Integer.TYPE}).invoke(XercesXMLSerializer.outputFormat, new Object[]{new Integer(0)});
                                var4_4.getMethod("setLineSeparator", new Class[]{XmlUtility.class$java$lang$String == null ? (XmlUtility.class$java$lang$String = XmlUtility.class$("java.lang.String")) : XmlUtility.class$java$lang$String}).invoke(XercesXMLSerializer.outputFormat, new Object[]{Constants.LINE_SEPARATOR});
                            }
                            XercesXMLSerializer.outputFormat.getClass().getMethod("setEncoding", new Class[]{XmlUtility.class$java$lang$String == null ? (XmlUtility.class$java$lang$String = XmlUtility.class$("java.lang.String")) : XmlUtility.class$java$lang$String}).invoke(XercesXMLSerializer.outputFormat, new Object[]{var3_3});
                            var1_1.write("<?xml version=\"1.0\" encoding=\"" + var3_3 + "\"?>");
                            var1_1.flush();
                            if (var2_2) {
                                var1_1.write(Constants.LINE_SEPARATOR);
                                var1_1.flush();
                            }
                            if ((var4_4 = var0.getDoctype()) == null) break block9;
                            var5_5 = var4_4.getSystemId();
                            var6_6 /* !! */  = var4_4.getInternalSubset();
                            if (var5_5 == null && var6_6 /* !! */  == null) break block9;
                            var7_7 = new StringBuffer();
                            var7_7.append("<!DOCTYPE ");
                            var7_7.append(var4_4.getName());
                            if (var5_5 == null) break block10;
                            var8_8 = var4_4.getPublicId();
                            if (var8_8 != null) {
                                var7_7.append(" PUBLIC \"");
                                var7_7.append(var8_8);
                                var7_7.append("\" \"");
                            } else {
                                var7_7.append(" SYSTEM \"");
                            }
                            var7_7.append((String)var5_5);
                            var7_7.append("\">");
                            break block11;
                        }
                        var7_7.append(" [");
                        var8_9 = new StringTokenizer(var6_6 /* !! */ .trim(), "\n\r\f");
                        if (!var2_2) ** GOTO lbl65
                        var7_7.append(Constants.LINE_SEPARATOR);
                        while (var8_9.hasMoreTokens()) {
                            var7_7.append("  ");
                            var7_7.append(var8_9.nextToken().trim());
                            var7_7.append(Constants.LINE_SEPARATOR);
                        }
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            var7_7.append(var8_9.nextToken().trim());
lbl65:
                            // 2 sources

                            ** while (var8_9.hasMoreTokens())
                        }
                    }
                    var7_7.append("]>");
                }
                if (var2_2) {
                    var7_7.append(Constants.LINE_SEPARATOR);
                }
                var1_1.write(var7_7.toString());
                var1_1.flush();
            }
            XercesXMLSerializer.outputFormat.getClass().getMethod("setIndent", new Class[]{Integer.TYPE}).invoke(XercesXMLSerializer.outputFormat, new Object[]{new Integer(var2_2 != false ? 2 : 0)});
            var5_5 = Class.forName("org.apache.xml.serialize.XMLSerializer");
            var6_6 /* !! */  = var5_5.getConstructor(new Class[]{XmlUtility.class$java$io$Writer == null ? (XmlUtility.class$java$io$Writer = XmlUtility.class$("java.io.Writer")) : XmlUtility.class$java$io$Writer, XercesXMLSerializer.outputFormat.getClass()}).newInstance(new Object[]{var1_1, XercesXMLSerializer.outputFormat});
            if (var2_2) {
                var5_5.getMethod("serialize", new Class[]{XmlUtility.class$org$w3c$dom$Document == null ? (XmlUtility.class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : XmlUtility.class$org$w3c$dom$Document}).invoke((Object)var6_6 /* !! */ , new Object[]{var0});
            } else {
                var7_7 = var0.cloneNode(true);
                XmlUtility.access$200((Node)var7_7);
                var5_5.getMethod("serialize", new Class[]{XmlUtility.class$org$w3c$dom$Document == null ? (XmlUtility.class$org$w3c$dom$Document = XmlUtility.class$("org.w3c.dom.Document")) : XmlUtility.class$org$w3c$dom$Document}).invoke((Object)var6_6 /* !! */ , new Object[]{var7_7});
            }
        }
    }

    private static class JAXPXMLSerializer
    implements Constants {
        private static Transformer transformer = null;

        private JAXPXMLSerializer() {
        }

        /*
         * Unable to fully structure code
         */
        private static void serialize(Document var0, Writer var1_1, boolean var2_2, String var3_3) throws Exception {
            block9: {
                block11: {
                    block12: {
                        block10: {
                            if (JAXPXMLSerializer.transformer == null) {
                                JAXPXMLSerializer.transformer = TransformerFactory.newInstance().newTransformer();
                                JAXPXMLSerializer.transformer.setOutputProperty("method", "xml");
                                JAXPXMLSerializer.transformer.setOutputProperty("omit-xml-declaration", "yes");
                            }
                            JAXPXMLSerializer.transformer.setOutputProperty("encoding", var3_3);
                            var1_1.write("<?xml version=\"1.0\" encoding=\"" + var3_3 + "\"?>");
                            var1_1.flush();
                            if (var2_2) {
                                var1_1.write(Constants.LINE_SEPARATOR);
                                var1_1.flush();
                            }
                            if ((var4_4 = var0.getDoctype()) == null) break block9;
                            var5_5 = var4_4.getSystemId();
                            var6_6 = var4_4.getInternalSubset();
                            if (var5_5 == null && var6_6 == null) break block9;
                            var7_7 = new StringBuffer();
                            var7_7.append("<!DOCTYPE ");
                            var7_7.append(var4_4.getName());
                            if (var5_5 == null) break block10;
                            var8_8 = var4_4.getPublicId();
                            if (var8_8 != null) {
                                var7_7.append(" PUBLIC \"");
                                var7_7.append(var8_8);
                                var7_7.append("\" \"");
                            } else {
                                var7_7.append(" SYSTEM \"");
                            }
                            var7_7.append((String)var5_5);
                            var7_7.append("\">");
                            break block11;
                        }
                        var7_7.append(" [");
                        var8_9 = new StringTokenizer(var6_6.trim(), "\n\r\f");
                        if (!var2_2) ** GOTO lbl55
                        var7_7.append(Constants.LINE_SEPARATOR);
                        while (var8_9.hasMoreTokens()) {
                            var7_7.append("  ");
                            var7_7.append(var8_9.nextToken().trim());
                            var7_7.append(Constants.LINE_SEPARATOR);
                        }
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            var7_7.append(var8_9.nextToken().trim());
lbl55:
                            // 2 sources

                            ** while (var8_9.hasMoreTokens())
                        }
                    }
                    var7_7.append("]>");
                }
                if (var2_2) {
                    var7_7.append(Constants.LINE_SEPARATOR);
                }
                var1_1.write(var7_7.toString());
                var1_1.flush();
            }
            if (var2_2) {
                JAXPXMLSerializer.transformer.setOutputProperty("indent", "yes");
                JAXPXMLSerializer.transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf("  ".length()));
                JAXPXMLSerializer.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf("  ".length()));
                JAXPXMLSerializer.transformer.transform(new DOMSource(var0), new StreamResult(var1_1));
            } else {
                JAXPXMLSerializer.transformer.setOutputProperty("indent", "no");
                JAXPXMLSerializer.transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "0");
                JAXPXMLSerializer.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "0");
                var5_5 = var0.cloneNode(true);
                XmlUtility.access$200((Node)var5_5);
                JAXPXMLSerializer.transformer.transform(new DOMSource((Node)var5_5), new StreamResult(var1_1));
            }
        }
    }
}

