/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXEventHandler
extends DefaultHandler {
    private HashMap elementMap = new HashMap();
    private HashMap featureMap = new HashMap();
    private int column = 0;
    private int line = 0;
    private StringBuffer anyElementXMLFragment = null;
    private StringBuffer charactersBuffer = null;
    private StringBuffer nameSpaceAttribute = null;
    private int anyElementNestingDepth = 0;
    private List commonBaseEvents = null;
    private List associationEngines = null;
    private List stack = null;
    private static final String SITUATION_TYPE_CLASS = EventPackage.eINSTANCE.getSituationType().getName();
    private static final String COMMON_BASE_EVENT_CLASS = EventPackage.eINSTANCE.getCommonBaseEvent().getName();
    private static final String OTHER_SITUATION_CLASS = EventPackage.eINSTANCE.getOtherSituation().getName();
    private static final String ASSOCIATION_ENGINE_CLASS = EventPackage.eINSTANCE.getAssociationEngine().getName();

    public SAXEventHandler() {
        this.init();
    }

    public void init() {
        this.reset();
        this.associationEngines = new ArrayList();
        this.commonBaseEvents = new ArrayList();
    }

    private void reset() {
        this.column = 0;
        this.line = 0;
        this.anyElementNestingDepth = 0;
        this.stack = new ArrayList();
        this.anyElementXMLFragment = new StringBuffer();
        this.charactersBuffer = new StringBuffer();
        this.nameSpaceAttribute = null;
        Iterator iterator = EventPackage.eINSTANCE.eContents().iterator();
        while (iterator.hasNext()) {
            EClass eClass = (EClass)iterator.next();
            this.elementMap.put(eClass.getName(), eClass);
            EList eList = eClass.getEAllStructuralFeatures();
            int n = 0;
            while (n < eList.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n);
                if (!eStructuralFeature.getName().equals("any")) {
                    HashMap<String, EStructuralFeature> hashMap = (HashMap<String, EStructuralFeature>)this.featureMap.get(eClass.getName());
                    if (hashMap == null) {
                        hashMap = new HashMap<String, EStructuralFeature>();
                        this.featureMap.put(eClass.getName(), hashMap);
                    }
                    hashMap.put(eStructuralFeature.getName(), eStructuralFeature);
                }
                ++n;
            }
        }
    }

    public CommonBaseEvent[] getCommonBaseEvents() {
        if (this.commonBaseEvents != null && !this.commonBaseEvents.isEmpty()) {
            return this.commonBaseEvents.toArray(new CommonBaseEvent[this.commonBaseEvents.size()]);
        }
        return null;
    }

    public AssociationEngine[] getAssociationEngines() {
        if (this.associationEngines != null && !this.associationEngines.isEmpty()) {
            return this.associationEngines.toArray(new AssociationEngine[this.associationEngines.size()]);
        }
        return null;
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.column = locator.getColumnNumber();
        this.line = locator.getLineNumber();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        super.characters(cArray, n, n2);
        this.charactersBuffer.append(new String(cArray, n, n2));
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        if (!string.equals("xmlns") && !string.equals("xml")) {
            this.nameSpaceAttribute = new StringBuffer("xmlns");
            if (string != null && string.trim().length() > 0) {
                this.nameSpaceAttribute.append(':');
                this.nameSpaceAttribute.append(string);
            }
            this.nameSpaceAttribute.append("=\"");
            this.nameSpaceAttribute.append(string2);
            this.nameSpaceAttribute.append('\"');
        }
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(String var1_1, String var2_2, String var3_3, Attributes var4_4) throws SAXException {
        block24: {
            block26: {
                block25: {
                    super.startElement(var1_1, var2_2, var3_3, var4_4);
                    var5_5 = this.getLocalElementName(var2_2, var3_3);
                    if (this.isRestrictedElementName(var5_5)) break block24;
                    var6_6 = null;
                    var7_7 = null;
                    if (!this.stack.isEmpty()) break block25;
                    if (!var5_5.equals(SAXEventHandler.COMMON_BASE_EVENT_CLASS) && !var5_5.equals(SAXEventHandler.ASSOCIATION_ENGINE_CLASS)) {
                        throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INCORRECT_XML_ELEMENT_EXC_", SAXEventHandler.COMMON_BASE_EVENT_CLASS, var5_5, String.valueOf(this.line), String.valueOf(this.column)));
                    }
                    var7_7 = (EClass)this.elementMap.get(var5_5);
                    var6_6 = EventFactory.eINSTANCE.create(var7_7);
                    this.stack.add(var6_6);
                    break block26;
                }
                var8_8 = (EObject)this.stack.get(this.stack.size() - 1);
                var9_9 = var8_8.eClass().getName();
                var10_10 = (HashMap)this.featureMap.get(var9_9);
                var11_11 = (EStructuralFeature)var10_10.get(var5_5);
                if (var11_11 != null) ** GOTO lbl52
                if (var9_9.equals(SAXEventHandler.COMMON_BASE_EVENT_CLASS) || var9_9.equals(SAXEventHandler.OTHER_SITUATION_CLASS)) {
                    if (this.anyElementNestingDepth > 0 && (var12_13 = this.charactersBuffer.toString()).trim().length() > 0) {
                        this.anyElementXMLFragment.append(XmlUtility.normalize((String)var12_13));
                    }
                    ++this.anyElementNestingDepth;
                    this.anyElementXMLFragment.append('<');
                    this.anyElementXMLFragment.append(this.getQualifiedElementName(var1_1, var2_2, var3_3));
                    if (this.nameSpaceAttribute != null) {
                        this.anyElementXMLFragment.append(' ');
                        this.anyElementXMLFragment.append(this.nameSpaceAttribute.toString());
                    }
                    var12_14 = 0;
                    while (var12_14 < var4_4.getLength()) {
                        this.anyElementXMLFragment.append(' ');
                        this.anyElementXMLFragment.append(this.getQualifiedElementName(var4_4.getURI(var12_14), var4_4.getLocalName(var12_14), var4_4.getQName(var12_14)));
                        this.anyElementXMLFragment.append("=\"");
                        this.anyElementXMLFragment.append(XmlUtility.normalize((String)var4_4.getValue(var12_14)));
                        this.anyElementXMLFragment.append("\"");
                        ++var12_14;
                    }
                    this.anyElementXMLFragment.append('>');
                } else {
                    throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_", var5_5, String.valueOf(this.line), String.valueOf(this.column)));
lbl52:
                    // 1 sources

                    var12_15 = var11_11.getEType().getName();
                    if (var12_15.equals(SAXEventHandler.SITUATION_TYPE_CLASS) && ((var12_15 = ((Situation)var8_8).getCategoryName()) == null || var12_15.trim().length() == 0)) {
                        throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", "categoryName", "<empty>", "0", "0"));
                    }
                    if (var12_15.equals("EString")) {
                        if (var11_11.isMany()) {
                            this.stack.add((List)var8_8.eGet(var11_11));
                        } else {
                            this.stack.add(var11_11);
                        }
                    } else {
                        var7_7 = (EClass)this.elementMap.get(var12_15);
                        var6_6 = EventFactory.eINSTANCE.create(var7_7);
                        if (var11_11.isMany()) {
                            ((List)var8_8.eGet(var11_11)).add(var6_6);
                        } else {
                            var8_8.eSet(var11_11, (Object)var6_6);
                        }
                        this.stack.add(var6_6);
                    }
                }
            }
            if (var6_6 != null) {
                var8_8 = (HashMap)this.featureMap.get(var7_7.getName());
                var9_9 = null;
                var10_10 = null;
                var11_12 = 0;
                while (var11_12 < var4_4.getLength()) {
                    var9_9 = (EAttribute)var8_8.get(this.getLocalElementName(var4_4.getLocalName(var11_12), var4_4.getQName(var11_12)));
                    if (var9_9 != null) {
                        var10_10 = var9_9.getEAttributeType().getName();
                        if (var10_10.equals("ELong")) {
                            try {
                                var6_6.eSet((EStructuralFeature)var9_9, (Object)Long.valueOf(var4_4.getValue(var11_12)));
                            }
                            catch (NumberFormatException var12_16) {
                                if (var4_4.getValue(var11_12).trim().length() <= 0) ** GOTO lbl97
                                throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", this.getQualifiedElementName(var4_4.getURI(var11_12), var4_4.getLocalName(var11_12), var4_4.getQName(var11_12)), var4_4.getValue(var11_12), String.valueOf(this.line), String.valueOf(this.column)));
                            }
                        } else if (var10_10.equals("EShort")) {
                            try {
                                var6_6.eSet((EStructuralFeature)var9_9, (Object)Short.valueOf(var4_4.getValue(var11_12)));
                            }
                            catch (NumberFormatException var12_17) {
                                if (var4_4.getValue(var11_12).trim().length() <= 0) ** GOTO lbl97
                                throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_INVALID_XML_ATTRIBUTE_EXC_", this.getQualifiedElementName(var4_4.getURI(var11_12), var4_4.getLocalName(var11_12), var4_4.getQName(var11_12)), var4_4.getValue(var11_12), String.valueOf(this.line), String.valueOf(this.column)));
                            }
                        } else {
                            var6_6.eSet((EStructuralFeature)var9_9, (Object)var4_4.getValue(var11_12));
                        }
                    }
lbl97:
                    // 7 sources

                    ++var11_12;
                }
            }
            this.charactersBuffer = new StringBuffer();
            this.nameSpaceAttribute = null;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        String string4 = this.getLocalElementName(string2, string3);
        if (!this.isRestrictedElementName(string4)) {
            if (this.stack.isEmpty()) {
                throw new SAXException(EventHelpers.getString("LOG_EVENT_SAX_PARSER_UNEXPECTED_XML_ELEMENT_EXC_", string4, String.valueOf(this.line), String.valueOf(this.column)));
            }
            if (this.anyElementNestingDepth > 0) {
                String string5 = this.charactersBuffer.toString();
                if (string5.trim().length() > 0) {
                    this.anyElementXMLFragment.append(XmlUtility.normalize((String)string5));
                }
                this.anyElementXMLFragment.append("</");
                this.anyElementXMLFragment.append(this.getQualifiedElementName(string, string2, string3));
                this.anyElementXMLFragment.append('>');
                if (--this.anyElementNestingDepth == 0) {
                    Object e = this.stack.get(this.stack.size() - 1);
                    if (e instanceof CommonBaseEvent) {
                        ((CommonBaseEvent)e).addAny(this.anyElementXMLFragment.toString());
                    } else if (e instanceof OtherSituation) {
                        OtherSituation otherSituation = (OtherSituation)e;
                        String string6 = otherSituation.getAny();
                        if (string6 != null && string6.trim().length() > 0) {
                            otherSituation.setAny(string6.concat(this.anyElementXMLFragment.toString()));
                        } else {
                            otherSituation.setAny(this.anyElementXMLFragment.toString());
                        }
                    }
                    this.anyElementXMLFragment = new StringBuffer();
                }
            } else {
                Object e = this.stack.remove(this.stack.size() - 1);
                if (e instanceof CommonBaseEvent) {
                    String string7 = this.charactersBuffer.toString();
                    if (string7.trim().length() > 0) {
                        ((CommonBaseEvent)e).addAny(XmlUtility.normalize((String)string7));
                    }
                    this.commonBaseEvents.add((CommonBaseEvent)e);
                    this.reset();
                } else if (e instanceof OtherSituation) {
                    String string8 = this.charactersBuffer.toString();
                    if (string8.trim().length() > 0) {
                        OtherSituation otherSituation = (OtherSituation)e;
                        String string9 = otherSituation.getAny();
                        if (string9 != null && string9.trim().length() > 0) {
                            otherSituation.setAny(string9.concat(XmlUtility.normalize((String)string8)));
                        } else {
                            otherSituation.setAny(XmlUtility.normalize((String)string8));
                        }
                    }
                } else if (string4.equals(ASSOCIATION_ENGINE_CLASS) && e instanceof AssociationEngine) {
                    this.associationEngines.add((AssociationEngine)e);
                    this.reset();
                } else if (this.stack.size() > 1) {
                    if (e instanceof List) {
                        ((List)e).add(this.charactersBuffer.toString());
                    }
                    if (e instanceof EStructuralFeature) {
                        ((EObject)this.stack.get(this.stack.size() - 1)).eSet((EStructuralFeature)e, (Object)this.charactersBuffer.toString());
                    }
                }
            }
            this.charactersBuffer = new StringBuffer();
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private String getLocalElementName(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            if (string2 != null) {
                int n = string2.lastIndexOf(58);
                if (n != -1) {
                    return string2.substring(n + 1).trim();
                }
                return string2.trim();
            }
            return string2.trim();
        }
        return string.trim();
    }

    private String getQualifiedElementName(String string, String string2, String string3) {
        if (string3 == null || string3.trim().length() == 0) {
            if (string2 != null) {
                if (string != null && string.trim().length() > 0) {
                    return string.concat(":").concat(string2);
                }
                return string2.trim();
            }
            return string2.trim();
        }
        return string3.trim();
    }

    private boolean isRestrictedElementName(String string) {
        if (string != null) {
            String string2 = string.trim();
            return string2.equalsIgnoreCase("CommonBaseEvents") || string2.equalsIgnoreCase("TemplateEvent");
        }
        return false;
    }
}

