/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.common.common.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.util.FileUtil;

public class CMNAnnotationImpl
extends CMNNamedElementImpl
implements CMNAnnotation {
    public static final String copyright = "";
    protected static final String URI_EDEFAULT = null;
    protected String uri = URI_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    public static final String ANNOTATION_QUERY = "annotationID=/";

    protected CMNAnnotationImpl() {
    }

    protected EClass eStaticClass() {
        return CommonPackage.eINSTANCE.getCMNAnnotation();
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String newURI) {
        String oldURI = this.uri;
        this.uri = newURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldURI, (Object)this.uri));
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldType, (Object)this.type));
        }
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getId();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getURI();
            }
            case 4: {
                return this.getType();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setId((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
            case 2: {
                this.setName((String)newValue);
                return;
            }
            case 3: {
                this.setURI((String)newValue);
                return;
            }
            case 4: {
                this.setType((String)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setId(CMNNamedElementImpl.ID_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(CMNNamedElementImpl.DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setName(CMNNamedElementImpl.NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 4: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return CMNNamedElementImpl.ID_EDEFAULT == null ? this.id != null : !CMNNamedElementImpl.ID_EDEFAULT.equals(this.id);
            }
            case 1: {
                return CMNNamedElementImpl.DESCRIPTION_EDEFAULT == null ? this.description != null : !CMNNamedElementImpl.DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return CMNNamedElementImpl.NAME_EDEFAULT == null ? this.name != null : !CMNNamedElementImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 3: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 4: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (URI: ");
        result.append(this.uri);
        result.append(", type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }

    public URI getFileAnnotation() throws UnsupportedOperationException, IOException {
        if (!this.isFileAnnotation()) {
            throw new UnsupportedOperationException("Annotation is not a File Annotation " + this.toString());
        }
        String uriString = this.getURI();
        if (!(this.eResource() instanceof FacadeResourceImpl)) {
            throw new UnsupportedOperationException("Resource is not supported by FacadeResourceImpl");
        }
        FacadeResourceImpl resource = (FacadeResourceImpl)this.eResource();
        File annotationDir = resource.getAnnotationDir();
        URI baseAnnotationDirURI = URI.createFileURI((String)annotationDir.getAbsolutePath());
        URI annotation = URI.createURI((String)uriString);
        annotation = this.queryURItoRelativeURI(annotation);
        URI resolvedURI = annotation.resolve(baseAnnotationDirURI);
        return resolvedURI;
    }

    public boolean isFileAnnotation() {
        if (this.eResource() instanceof FacadeResourceImpl) {
            String uriString = this.getURI();
            if (uriString == null || uriString.length() == 0) {
                return false;
            }
            URI uri = URI.createURI((String)uriString);
            if ((uri = this.queryURItoRelativeURI(uri)).isFile()) {
                return true;
            }
        }
        return false;
    }

    private URI queryURItoRelativeURI(URI uri) {
        if (uri.hasQuery()) {
            String query = uri.query();
            String uriString = query.replaceFirst(ANNOTATION_QUERY, copyright);
            uri = URI.createURI((String)uriString);
        }
        return uri;
    }

    private URI relativeURItoQueryURI(URI uri) {
        if (!uri.hasQuery()) {
            String queryString = ANNOTATION_QUERY + uri.toString();
            uri = URI.createHierarchicalURI(null, null, null, (String)queryString, null);
        }
        return uri;
    }

    public void putFileAnnotation(URI file) throws UnsupportedOperationException, IOException {
        File srcFile;
        if (!(this.eResource() instanceof FacadeResourceImpl)) {
            throw new UnsupportedOperationException("Resource is not supported by FacadeResourceImpl");
        }
        String containerID = this.getContainerID();
        FacadeResourceImpl resource = (FacadeResourceImpl)this.eResource();
        File annotationDir = resource.getAnnotationDir();
        File objectAnnotationDir = new File(annotationDir, containerID);
        if (!objectAnnotationDir.exists()) {
            if (!objectAnnotationDir.mkdir()) {
                throw new IOException("Collision making dirctory " + objectAnnotationDir.getAbsolutePath());
            }
        } else if (!objectAnnotationDir.isDirectory()) {
            throw new IOException("Object annotation dir name exists as file " + objectAnnotationDir.getAbsolutePath());
        }
        if (!(srcFile = new File(file.toFileString())).exists()) {
            throw new IOException("Specified file does not exist " + file.toFileString());
        }
        File destFile = new File(objectAnnotationDir, srcFile.getName());
        if (destFile.exists()) {
            throw new IOException("FileAnnotation of same name (" + srcFile.getName() + ") already exists on object " + this.eContainer().toString());
        }
        FileUtil.copyFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
        URI baseAnnotationDirURI = URI.createFileURI((String)annotationDir.getAbsolutePath());
        URI annotation = URI.createFileURI((String)destFile.getAbsolutePath());
        URI relativeURI = annotation.deresolve(baseAnnotationDirURI);
        this.setURI(this.relativeURItoQueryURI(relativeURI).toString());
    }

    private String getContainerID() throws UnsupportedOperationException {
        String containerID;
        EObject container = this.eContainer();
        if (container == null) {
            throw new UnsupportedOperationException("FileAnnotation must be contained in a model element");
        }
        if (container instanceof CMNNamedElement) {
            CMNNamedElement con = (CMNNamedElement)container;
            containerID = con.getId();
        } else if (container instanceof TPFExecutionEvent) {
            TPFExecutionEvent con = (TPFExecutionEvent)container;
            containerID = con.getId();
        } else {
            throw new UnsupportedOperationException("Annotations not supported for container of type " + container);
        }
        return containerID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileAnnotation() throws UnsupportedOperationException, IOException {
        URI resolvedURI = this.getFileAnnotation();
        File file = new File(resolvedURI.toFileString());
        try {
            if (file.exists()) {
                File[] siblings;
                file.delete();
                File parentDir = file.getParentFile();
                if (parentDir.exists() && (siblings = parentDir.listFiles()).length == 0) {
                    parentDir.delete();
                }
            }
            Object var6_5 = null;
            this.setURI(URI_EDEFAULT);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.setURI(URI_EDEFAULT);
            throw throwable;
        }
    }
}

