/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.remote;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.remote.AgentConfiguration;
import org.eclipse.hyades.internal.execution.remote.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.remote.AgentNotRegisteredException;
import org.eclipse.hyades.internal.execution.remote.CustomCommandHandler;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.RemoteClientListener;

public class RemoteComponentSkeleton {
    private static final boolean nativesAvailable;
    private boolean isLogging = false;
    private boolean isInitialized = false;
    protected final Vector monitorListeners = new Vector();
    protected final Vector serverListeners = new Vector();
    protected final Vector commandListeners = new Vector();
    protected final Vector clientListeners = new Vector();
    private boolean uuidsValid = false;
    private String agentUUID;
    private String nodeUUID;
    private String jvmUUID;
    private String name;
    private String type;
    private boolean isRegistered = false;
    private long mechanism = -1L;
    private static boolean serviceAvailable;
    private static int agentCount;
    private boolean requestForMonitor = false;
    private AgentConfiguration _defaultConfiguration = null;

    public RemoteComponentSkeleton(String name, String type) {
        this.setName(name);
        this.setType(type);
        this._defaultConfiguration = new AgentConfiguration();
        this._defaultConfiguration.setAgentName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentControllerListener(AgentControllerListener listener) {
        Vector vector = this.serverListeners;
        synchronized (vector) {
            this.serverListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorListener(MonitorListener listener) {
        Vector vector = this.monitorListeners;
        synchronized (vector) {
            this.monitorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoteClientListener(RemoteClientListener listener) {
        Vector vector = this.clientListeners;
        synchronized (vector) {
            this.clientListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommandListener(CustomCommandHandler listener) {
        Vector vector = this.commandListeners;
        synchronized (vector) {
            this.commandListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentControllerActive() {
        serviceAvailable = true;
        this.uuidsValid = true;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (agentCount == 0) {
                this.getClass().notify();
            }
        }
        Vector vector = this.serverListeners;
        synchronized (vector) {
            Enumeration e = this.serverListeners.elements();
            while (e.hasMoreElements()) {
                AgentControllerListener listener = (AgentControllerListener)e.nextElement();
                listener.agentControllerActive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentControllerInactive() {
        serviceAvailable = false;
        this.setLogging(false);
        this._defaultConfiguration.clear();
        Vector vector = this.serverListeners;
        synchronized (vector) {
            Enumeration e = this.serverListeners.elements();
            while (e.hasMoreElements()) {
                AgentControllerListener listener = (AgentControllerListener)e.nextElement();
                listener.agentControllerInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteClientExited() {
        this.setLogging(false);
        Vector vector = this.clientListeners;
        synchronized (vector) {
            Enumeration e = this.clientListeners.elements();
            while (e.hasMoreElements()) {
                RemoteClientListener listener = (RemoteClientListener)e.nextElement();
                listener.clientInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deregister() {
        if (this.isInitialized) {
            this.deregister0(this.name);
            this.isInitialized = false;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                --agentCount;
            }
        }
    }

    private native void deregister0(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        try {
            this.deregister0(this.name);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                super.finalize();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            super.finalize();
        }
        catch (Throwable t) {}
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize() throws AgentControllerUnavailableException {
        if (!nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this.isInitialized) {
            this.initializeEngine0(this.name, this.type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (agentCount == 0) {
                    try {
                        this.getClass().wait(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                ++agentCount;
            }
            this.isInitialized = true;
        }
        if (!serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initializeFast() throws AgentControllerUnavailableException {
        if (!nativesAvailable) {
            throw new AgentControllerUnavailableException();
        }
        if (!this.isInitialized) {
            this.initializeEngine0(this.name, this.type);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                ++agentCount;
            }
            this.isInitialized = true;
        }
        if (!serviceAvailable) {
            throw new AgentControllerUnavailableException();
        }
    }

    private native void initializeEngine0(String var1, String var2) throws AgentControllerUnavailableException;

    public boolean isAgentControllerActive() {
        return serviceAvailable;
    }

    public boolean isLogging() {
        return this.isLogging;
    }

    public synchronized void logMessage(byte[] msg, int offset, int len) {
        if (this.isLogging) {
            this.logMessage0(this.name, msg, offset, len);
        }
    }

    public synchronized void logMessage(String msg) {
        if (this.isLogging) {
            this.logMessage0(this.name, msg);
        }
    }

    private native void logMessage0(String var1, byte[] var2, int var3, int var4);

    private native void logMessage0(String var1, String var2);

    public synchronized void logErrMsg(String message, String messageId, int severity) {
        this.logErrorMessage(message, messageId, severity);
    }

    private native void logErrorMessage(String var1, String var2, int var3);

    public synchronized void logMessageUTF8(String msg) {
        block2: {
            if (!this.isLogging) break block2;
            try {
                this.logMessageUTF81(this.name, msg.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                this.logMessageUTF80(this.name, msg);
            }
        }
    }

    private native void logMessageUTF81(String var1, byte[] var2);

    private native void logMessageUTF80(String var1, String var2);

    public void sendMessageToAttachedClient(String message, long contextId) {
        block2: {
            if (!nativesAvailable) break block2;
            try {
                byte[] bytes = message.getBytes("UTF-8");
                this.sendMessageBinary0(bytes, 0, bytes.length, contextId);
            }
            catch (UnsupportedEncodingException ex) {}
        }
    }

    private native void sendMessage0(String var1, long var2);

    public void sendMessageToAttachedClient(byte[] message, int offset, int length, long contextId) {
        if (nativesAvailable) {
            this.sendMessageBinary0(message, offset, length, contextId);
        }
    }

    private native void sendMessage0(byte[] var1, int var2, int var3, long var4);

    private native void sendMessageBinary0(byte[] var1, int var2, int var3, long var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setLogging(boolean log) {
        this.isLogging = log;
        Vector vector = this.monitorListeners;
        synchronized (vector) {
            Enumeration e = this.monitorListeners.elements();
            while (e.hasMoreElements()) {
                MonitorListener listener = (MonitorListener)e.nextElement();
                if (this.isLogging) {
                    listener.monitorActive();
                    continue;
                }
                listener.monitorInactive();
            }
        }
        if (this.isLogging && this.requestForMonitor) {
            RemoteComponentSkeleton remoteComponentSkeleton = this;
            synchronized (remoteComponentSkeleton) {
                this.notify();
            }
        }
    }

    private void setName(String name) {
        this.name = new String(name);
    }

    private void setType(String type) {
        this.type = new String(type);
    }

    private void setAgentUUID(String type) {
        this.agentUUID = type;
    }

    public String getAgentUUID() {
        return this.agentUUID;
    }

    private void setNodeUUID(String type) {
        this.nodeUUID = type;
    }

    public String getNodeUUID() throws AgentNotRegisteredException {
        if (!this.uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this.nodeUUID;
    }

    private void setJVMUUID(String type) {
        this.jvmUUID = type;
    }

    public String getJVMUUID() throws AgentNotRegisteredException {
        if (!this.uuidsValid) {
            throw new AgentNotRegisteredException();
        }
        return this.jvmUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMonitorThroughPeer(InetAddress addr, String agentUUID, long timeout) {
        if (!nativesAvailable) {
            return;
        }
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            this.requestForMonitor = true;
            this.requestMonitorThroughPeer0(addr.getAddress(), agentUUID);
            try {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    Object var8_6 = null;
                    this.requestForMonitor = false;
                }
                Object var8_5 = null;
                this.requestForMonitor = false;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.requestForMonitor = false;
                throw throwable;
            }
        }
    }

    private native void requestMonitorThroughPeer0(byte[] var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestMonitorThroughPeer(InetAddress addr, long pid, String agentName, long timeout) {
        if (!nativesAvailable) {
            return;
        }
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            this.requestForMonitor = true;
            this.requestMonitorThroughPeer0(addr.getAddress(), pid, agentName);
            try {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    Object var10_7 = null;
                    this.requestForMonitor = false;
                }
                Object var10_6 = null;
                this.requestForMonitor = false;
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.requestForMonitor = false;
                throw throwable;
            }
        }
    }

    private native void requestMonitorThroughPeer0(byte[] var1, long var2, String var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void peerUnreachable() {
        RemoteComponentSkeleton remoteComponentSkeleton = this;
        synchronized (remoteComponentSkeleton) {
            if (this.requestForMonitor) {
                this.notifyAll();
            }
        }
    }

    public AgentConfiguration getDefaultConfiguration() {
        return this._defaultConfiguration;
    }

    private void addEntryToDefaultConfiguration(AgentConfigurationEntry entry) {
        this._defaultConfiguration.addEntry(entry);
    }

    public void broadcastMessage(String message, long contextId) {
        this.sendMessageToAttachedClient(message, contextId);
    }

    public void broadcastMessage(byte[] message, int offset, int length, long contextId) {
        this.sendMessageToAttachedClient(message, offset, length, contextId);
    }

    private Object createObjectInContextOfClassLoader(String objectType) {
        Object result = null;
        try {
            Class<?> clazz = Class.forName(objectType);
            result = clazz.newInstance();
        }
        catch (Throwable e) {}
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incomingCommand(CommandElement command) {
        if (command instanceof CustomCommand) {
            Vector vector = this.commandListeners;
            synchronized (vector) {
                Enumeration e = this.commandListeners.elements();
                while (e.hasMoreElements()) {
                    CustomCommandHandler listener = (CustomCommandHandler)e.nextElement();
                    listener.handleCommand((CustomCommand)command);
                }
            }
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    static {
        serviceAvailable = false;
        agentCount = 0;
        boolean nativesLoadable = false;
        try {
            System.loadLibrary("hcjbnd");
            nativesLoadable = true;
        }
        catch (Throwable e) {
            // empty catch block
        }
        nativesAvailable = nativesLoadable;
    }
}

