/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.MonitoringParser;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.logging.parsers.ParserConstants;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public abstract class AbstractErrorLogParser
extends MonitoringParser {
    protected String category = null;
    protected short severity = 0;
    protected String clientIP = null;
    protected String message = null;
    protected String fileName = null;
    protected StringBuffer cgiDebuggingOutput = new StringBuffer();
    protected StringBuffer currentTimeStamp = null;
    protected String productVersion = null;
    protected String sourceID = null;
    private String previousTimeStamp = EventHelpers.longToDate((long)0L);
    private long duplicateTimeStampCounter = 0L;

    public void preParse() throws LogParserException {
        super.preParse();
    }

    public void postParse() throws LogParserException {
        super.postParse();
    }

    public CommonBaseEvent[] parseNext() throws LogParserException {
        CommonBaseEvent[] temp = null;
        this.curLine = this.readLine();
        this.arrayIndex = 0;
        try {
            while (this.curLine != null) {
                this.curLine = this.curLine.trim();
                if (this.curLine.length() > 0 && this.parseLogRecord()) {
                    if (this.cgiDebuggingOutput.length() > 0) {
                        this.createCGIDebuggingOutputCBE();
                        ++this.arrayIndex;
                        if (this.arrayIndex == this.MessageArraySize) {
                            this.increaseMsgArraySize();
                        }
                        ++this.recordCount;
                    }
                    this.reinitializeCBE();
                    if (this.previousTimeStamp.equals(this.currentTimeStamp.toString())) {
                        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
                    } else {
                        this.previousTimeStamp = this.currentTimeStamp.toString();
                        this.duplicateTimeStampCounter = 0L;
                    }
                    this.messages[this.arrayIndex].setCreationTime(this.currentTimeStamp.toString());
                    this.messages[this.arrayIndex].setMsg(this.message);
                    this.messages[this.arrayIndex].setSeverity(this.severity);
                    if (this.category != null) {
                        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("category", this.category));
                    }
                    if (this.clientIP != null) {
                        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("client", this.clientIP));
                    }
                    if (this.fileName != null) {
                        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("file", this.fileName));
                    }
                    ++this.arrayIndex;
                    if (this.arrayIndex == this.MessageArraySize) {
                        this.arrayIndex = 0;
                        ++this.recordCount;
                        this.reset();
                        return this.messages;
                    }
                    ++this.recordCount;
                    this.reset();
                }
                this.curLine = this.readLine();
            }
            if (this.cgiDebuggingOutput.length() > 0) {
                if (this.recordCount == 0) {
                    throw new LogParserException(ParserUtilities.getResourceString("INVALID_ERROR_LOG_ERROR_", this.file_path));
                }
                this.createCGIDebuggingOutputCBE();
                ++this.arrayIndex;
                if (this.arrayIndex == this.MessageArraySize) {
                    this.arrayIndex = 0;
                    ++this.recordCount;
                    this.reset();
                    return this.messages;
                }
                this.cgiDebuggingOutput = new StringBuffer();
                ++this.recordCount;
            }
            if (this.arrayIndex == 0) {
                temp = null;
                this.setEndOfFile();
            } else {
                int i = this.arrayIndex;
                while (i < this.MessageArraySize) {
                    this.messages[i] = null;
                    ++i;
                }
                temp = this.messages;
            }
            if (this.recordCount == 0) {
                throw new LogParserException(ParserUtilities.getResourceString("NO_ERROR_LOG_RECORDS_ERROR_", this.file_path));
            }
        }
        catch (LogParserException l) {
            throw l;
        }
        catch (Throwable t) {
            ParserUtilities.exceptionHandler(t, this.curLineNumber, this.curLine, ParserUtilities.getResourceString("ERROR_LOG_PARSER_ERROR_"));
        }
        return temp;
    }

    private void createCGIDebuggingOutputCBE() {
        this.reinitializeCBE();
        this.messages[this.arrayIndex].setSequenceNumber(++this.duplicateTimeStampCounter);
        this.messages[this.arrayIndex].setCreationTime(this.previousTimeStamp);
        this.messages[this.arrayIndex].setMsg(this.cgiDebuggingOutput.toString().trim());
        this.messages[this.arrayIndex].setSeverity((short)10);
        this.messages[this.arrayIndex].addExtendedDataElement(Parser.createStringEDE("CGI_debugging_output", this.cgiDebuggingOutput.toString().trim()));
    }

    private void reinitializeCBE() {
        this.messages[this.arrayIndex].init();
        this.messages[this.arrayIndex].setGlobalInstanceId(Guid.generate());
        ComponentIdentification sourceComponentID = Parser.eventFactory.createComponentIdentification();
        sourceComponentID.setLocation(this.localHostId);
        sourceComponentID.setLocationType(this.localHostIdFormat);
        sourceComponentID.setComponent(this.sourceID);
        sourceComponentID.setSubComponent("Unknown");
        sourceComponentID.setComponentType("ApacheHTTPServer");
        sourceComponentID.setComponentIdType("ProductName");
        this.messages[this.arrayIndex].setSourceComponentId(sourceComponentID);
        this.messages[this.arrayIndex].setSituation(this.createSituation());
    }

    private Situation createSituation() {
        Situation cbeSituation = Parser.eventFactory.createSituation();
        ReportSituation cbeReportSituation = Parser.eventFactory.createReportSituation();
        cbeReportSituation.setReasoningScope("INTERNAL");
        cbeReportSituation.setReportCategory("LOG");
        cbeSituation.setCategoryName("ReportSituation");
        cbeSituation.setSituationType((SituationType)cbeReportSituation);
        return cbeSituation;
    }

    protected boolean parseDate(int startIndex, int endIndex) {
        SimpleDateFormat formatter;
        Date creationDate;
        if (this.curLine.charAt(startIndex) == '[' && this.curLine.charAt(endIndex) == ']' && (creationDate = (formatter = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US)).parse(this.curLine.substring(startIndex + 1, endIndex).trim(), new ParsePosition(0))) != null) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.currentTimeStamp = new StringBuffer(formatter.format(creationDate).trim());
            this.currentTimeStamp.replace(10, 11, "T");
            this.currentTimeStamp.append(".000000");
            Calendar localCalendar = Calendar.getInstance();
            localCalendar.setTime(creationDate);
            int utcOffset = (localCalendar.get(15) + localCalendar.get(16)) / 60000;
            if (utcOffset < 0) {
                this.currentTimeStamp.append("-");
            } else {
                this.currentTimeStamp.append("+");
            }
            utcOffset = Math.abs(utcOffset);
            String numberHours = String.valueOf(utcOffset / 60);
            if (numberHours.length() == 1) {
                this.currentTimeStamp.append("0");
            }
            this.currentTimeStamp.append(numberHours);
            this.currentTimeStamp.append(":");
            String numberMinutes = String.valueOf(utcOffset % 60);
            if (numberMinutes.length() == 1) {
                this.currentTimeStamp.append("0");
            }
            this.currentTimeStamp.append(numberMinutes);
            return true;
        }
        return false;
    }

    protected boolean parseLogRecord() {
        int previousIndex = 0;
        int currentIndex = this.curLine.indexOf("[", previousIndex);
        if (currentIndex == -1) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1 || !this.parseDate(previousIndex, currentIndex)) {
            this.cgiDebuggingOutput.append(this.curLine);
            this.cgiDebuggingOutput.append(ParserConstants.LINE_SEPARATOR);
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("[", previousIndex)) == -1) {
            return false;
        }
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
            return false;
        }
        this.category = this.curLine.substring(previousIndex + 1, currentIndex).trim();
        this.severity = this.category.equals("emerg") || this.category.equals("alert") || this.category.equals("crit") || this.category.equals("error") ? (short)50 : (this.category.equals("warn") ? (short)30 : (short)10);
        previousIndex = currentIndex;
        if ((currentIndex = this.curLine.indexOf("[client", previousIndex)) != -1) {
            previousIndex = currentIndex;
            if ((currentIndex = this.curLine.indexOf("]", previousIndex)) == -1) {
                return false;
            }
            this.clientIP = this.curLine.substring(previousIndex + 7, currentIndex).trim();
            previousIndex = currentIndex;
        }
        this.message = this.curLine.substring(previousIndex + 1).trim();
        currentIndex = this.curLine.indexOf(": ", previousIndex);
        if (currentIndex != -1) {
            this.fileName = this.curLine.substring(currentIndex + 2).trim();
        }
        return true;
    }

    protected void reset() {
        this.severity = 0;
        this.message = null;
        this.clientIP = null;
        this.fileName = null;
        this.cgiDebuggingOutput = new StringBuffer();
        this.category = null;
        this.currentTimeStamp = null;
    }
}

