/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.eclipse.hyades.internal.execution.local.common.AcknowledgementHandler;
import org.eclipse.hyades.internal.execution.local.common.AcknowledgementMessage;
import org.eclipse.hyades.internal.execution.local.common.CommandHandler;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.Message;

public final class ControlServerDaemon
implements Constants {
    private DatagramServer _server = null;
    private DatagramSocket _sock = null;
    private AcknowledgementHandler _ackHandler = null;
    private CommandHandler _cmdHandler = null;

    public void sendMessage(byte[] buffer, int length, InetAddress addr) throws IOException {
        DatagramPacket message = new DatagramPacket(buffer, length, addr, 10002);
        this._sock.send(message);
    }

    public void setAcknowledgementHandler(AcknowledgementHandler handler) {
        this._ackHandler = handler;
    }

    public void setCommandHandler(CommandHandler handler) {
        this._cmdHandler = handler;
    }

    public void startServer() throws SocketException {
        if (this._server != null) {
            return;
        }
        this._sock = new DatagramSocket();
        this._server = new DatagramServer();
        this._server.setSocket(this._sock);
        this._server.setDaemon(true);
        this._server.start();
    }

    class DatagramServer
    extends Thread
    implements Constants {
        DatagramSocket _socket = null;

        DatagramServer() {
        }

        public void setSocket(DatagramSocket sock) {
            this._socket = sock;
        }

        public void run() {
            while (true) {
                byte[] buffer = new byte[8096];
                DatagramPacket data = new DatagramPacket(buffer, 8096);
                try {
                    this._socket.receive(data);
                    Message incommingMessage = new Message();
                    incommingMessage.readFromBuffer(data.getData(), data.getLength());
                    if (incommingMessage.getType() != 0L) {
                        byte[] responseBuffer = new byte[16];
                        AcknowledgementMessage ack = new AcknowledgementMessage();
                        ack.setTicket(incommingMessage.getTicket());
                        ack.writeToBuffer(responseBuffer, 0);
                        DatagramPacket response = new DatagramPacket(responseBuffer, 12, data.getAddress(), data.getPort());
                        this._socket.send(response);
                    }
                    this.processMessage(data.getData(), data.getLength(), data.getAddress());
                }
                catch (IOException e) {
                }
            }
        }

        protected void processMessage(byte[] buffer, int bufferSize, InetAddress server) {
            long type = Message.readRALongFromBuffer(buffer, 8);
            switch ((int)type) {
                case 0: {
                    this.processAcknowledgementMessage(buffer, bufferSize, server);
                    break;
                }
                case 1: {
                    this.processControlMessage(buffer, bufferSize, server);
                    break;
                }
            }
        }

        protected void processAcknowledgementMessage(byte[] buffer, int bufferSize, InetAddress server) {
            if (ControlServerDaemon.this._ackHandler != null) {
                AcknowledgementMessage msg = new AcknowledgementMessage();
                msg.readFromBuffer(buffer, bufferSize);
                ControlServerDaemon.this._ackHandler.incommingAcknowledgement(server, msg.getTicket());
            }
        }

        protected void processControlMessage(byte[] buffer, int bufferSize, InetAddress server) {
            if (ControlServerDaemon.this._cmdHandler != null) {
                ControlMessage msg = new ControlMessage();
                msg.readFromBuffer(buffer, bufferSize);
                int count = msg.getCommandCount();
                int i = 0;
                while (i < count) {
                    ControlServerDaemon.this._cmdHandler.incommingCommand(server, msg.getCommand(i));
                    ++i;
                }
            }
        }
    }
}

