/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.util.Hashtable;
import java.util.MissingResourceException;
import org.eclipse.hyades.internal.config.generator.ConfigFile;
import org.eclipse.hyades.internal.config.generator.ConfigUtility;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;

public abstract class SetConfigSkeleton {
    public ConfigFile configFile = null;
    public static String sr = PlatformObject.sr;
    public static String pr = PlatformObject.pr;
    public static boolean silent = false;
    public static boolean overwrite = false;
    public static boolean verify = true;
    private String pluginName = null;
    private String fileName = null;
    private ClassLoader loader = null;

    public abstract void init(Hashtable var1);

    public abstract void askUser();

    public abstract void generateConfiguration();

    public abstract void printHelp();

    public abstract void printExamples();

    public void run(Hashtable hashtable) {
        this.run(hashtable, false, false);
    }

    public void run(Hashtable hashtable, boolean bl, boolean bl2) {
        silent = bl;
        overwrite = bl2;
        if (this.fileName != null) {
            this.configFile = new ConfigFile(this.fileName);
            this.configFile.init(hashtable);
            this.askUser();
            this.generateConfiguration();
        }
    }

    public SetConfigSkeleton() {
        this(null);
    }

    public SetConfigSkeleton(String string) {
        if (string != null) {
            this.pluginName = string;
        }
    }

    public void setLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getString(String string) {
        String string2 = null;
        if (this.loader == null) {
            string2 = ConfigUtility.getString(string);
        } else {
            try {
                Logger.out("Looking for resource under: " + this.pluginName + ".SetConfig");
                string2 = ConfigUtility.getString(this.loader, this.pluginName + ".SetConfig", string);
            }
            catch (MissingResourceException missingResourceException) {
                string2 = ConfigUtility.getString(string);
            }
        }
        return string2;
    }

    public String trim(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length() - 1;
        while (n < n2 && (string.charAt(n) == ' ' || string.charAt(n) == '\"' || string.charAt(n) == '\'')) {
            ++n;
        }
        while (n2 > n && (string.charAt(n2) == ' ' || string.charAt(n2) == '\"' || string.charAt(n2) == '\'')) {
            --n2;
        }
        if (n != n2) {
            return string.substring(n, n2 + 1);
        }
        return null;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }
}

