/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.parsers.ISubstitutionExtension;

public class AdapterPlugin
extends Plugin {
    private static AdapterPlugin instance = null;

    public AdapterPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        if (instance == null) {
            instance = this;
        }
    }

    public static AdapterPlugin getPlugin() {
        return instance;
    }

    public static ResourceBundle getResourceBundle() {
        try {
            return AdapterPlugin.getPlugin().getDescriptor().getResourceBundle();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public static List getContextListeners() {
        IConfigurationElement[] elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter", "contextListener");
        ArrayList<IContextListener> results = new ArrayList<IContextListener>();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            try {
                IContextListener listener = (IContextListener)elem.createExecutableExtension("name");
                results.add(listener);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        return results;
    }

    public static IComponent getComponent(String classname) {
        IComponent component = null;
        IConfigurationElement[] elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter", "adapterComponent");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            if (elem.getAttribute("name").equals(classname)) {
                try {
                    component = (IComponent)elem.createExecutableExtension("name");
                    return component;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return component;
    }

    public static ISubstitutionExtension getSubstitutionExtension(String classname) {
        ISubstitutionExtension extension = null;
        IConfigurationElement[] elements = null;
        try {
            elements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.adapter", "substitutionExtension");
        }
        catch (Throwable e) {
            return null;
        }
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            if (elem.getAttribute("name").equals(classname)) {
                try {
                    extension = (ISubstitutionExtension)elem.createExecutableExtension("name");
                    return extension;
                }
                catch (ClassCastException e) {
                    throw e;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return extension;
    }
}

