/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.preferences;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.wizard.ImportSymptomDBWizard;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBUI
implements SelectionListener {
    private Composite result;
    private Table _list;
    private Button _moveUp;
    private Button _moveDown;
    private Button _selAll;
    private Button _unselAll;
    private Button _restoreDefaults;
    private ArrayList _data = new ArrayList();
    private Item _oldSelection;
    private Button _add;
    private static final int _restoreDefaultsButtonId = 1025;
    private static final int SIZING_WIZARD_WIDTH = 500;

    public Composite createControl(Composite parent) {
        this.result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.result.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        data.heightHint = 320;
        data.widthHint = 400;
        this.result.setLayoutData((Object)data);
        Label label = new Label(this.result, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalSpan = 3;
        data.heightHint = 10;
        label.setLayoutData((Object)data);
        Label description = new Label(this.result, 0);
        description.setText(LogUIPlugin.getResourceString((String)"STR_SYMPTOM_DB_DLG_TEXT"));
        Composite dataComp = new Composite(this.result, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        dataComp.setLayout((Layout)layout);
        data = GridUtil.createFill();
        data.heightHint = 250;
        data.horizontalSpan = 3;
        dataComp.setLayoutData((Object)data);
        this._list = new Table(dataComp, 2336);
        data = GridUtil.createFill();
        this._list.setLayoutData((Object)data);
        Composite buttonWidget = new Composite(dataComp, 0);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        buttonWidget.setLayoutData((Object)data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        this._moveUp = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveUp.setLayoutData((Object)data);
        this._moveUp.setText(LogUIPlugin.getResourceString((String)"STR_COL_DLG_UP"));
        this._moveDown = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._moveDown.setLayoutData((Object)data);
        this._moveDown.setText(LogUIPlugin.getResourceString((String)"STR_COL_DLG_DOWN"));
        this._selAll = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._selAll.setLayoutData((Object)data);
        this._selAll.setText(LogUIPlugin.getResourceString((String)"STR_COL_DLG_SEL_ALL"));
        this._unselAll = new Button(buttonWidget, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this._unselAll.setLayoutData((Object)data);
        this._unselAll.setText(LogUIPlugin.getResourceString((String)"STR_COL_DLG_USEL_ALL"));
        label = new Label(buttonWidget, 0);
        this._add = new Button(buttonWidget, 0);
        data = GridUtil.createHorizontalFill();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this._add.setLayoutData((Object)data);
        this._add.setText(LogUIPlugin.getResourceString((String)"STR_ADD_DB"));
        this._list.addSelectionListener((SelectionListener)this);
        this._moveUp.addSelectionListener((SelectionListener)this);
        this._moveDown.addSelectionListener((SelectionListener)this);
        this._selAll.addSelectionListener((SelectionListener)this);
        this._unselAll.addSelectionListener((SelectionListener)this);
        this._add.addSelectionListener((SelectionListener)this);
        this._moveUp.setEnabled(false);
        this._moveDown.setEnabled(false);
        this._selAll.setEnabled(false);
        this._unselAll.setEnabled(false);
        WorkbenchHelp.setHelp((Control)this._list, (String)ContextIds.SYMDB_PREF_DATABASE);
        return this.result;
    }

    public ArrayList getData() {
        return this._data;
    }

    protected void moveDown(int idx) {
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        TableItem newitem = new TableItem(this._list, 32, idx + 2);
        newitem.setImage(LogUIPluginImages.getImage((String)"symptomdb_obj.gif"));
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx);
        this._list.select(idx + 1);
    }

    protected void moveUp(int idx) {
        TableItem item = this._list.getItem(idx);
        ColumnData data = (ColumnData)item.getData();
        if (idx > 0) {
            TableItem previousItem = this._list.getItem(idx - 1);
            ColumnData previousItemData = (ColumnData)previousItem.getData();
        }
        TableItem newitem = new TableItem(this._list, 32, idx - 1);
        newitem.setChecked(item.getChecked());
        newitem.setText(item.getText());
        newitem.setImage(LogUIPluginImages.getImage((String)"symptomdb_obj.gif"));
        newitem.setData((Object)data);
        newitem.setGrayed(item.getGrayed());
        this._list.remove(idx + 1);
        this._list.select(idx - 1);
    }

    private void populateList() {
        int idx = 0;
        while (idx < this._data.size()) {
            ColumnData data = (ColumnData)this._data.get(idx);
            TableItem item = new TableItem(this._list, 0);
            item.setText(data.name());
            item.setImage(LogUIPluginImages.getImage((String)"symptomdb_obj.gif"));
            item.setChecked(data.visible());
            item.setData((Object)data);
            ++idx;
        }
        if (this._list.getItemCount() > 0) {
            this._selAll.setEnabled(true);
            this._unselAll.setEnabled(true);
            this._list.select(0);
            if (this._list.getItemCount() > 1) {
                this._moveDown.setEnabled(true);
            }
        }
        int n = this._list.getSelectionIndex();
    }

    public void addDBPath(String symptomdbPath) {
        IWorkspace workbench = ResourcesPlugin.getWorkspace();
        while (this._list.getItemCount() > 0) {
            this._list.getItem(0).dispose();
        }
        this._data.clear();
        if (symptomdbPath == null || symptomdbPath.equals("")) {
            return;
        }
        int idx = symptomdbPath.indexOf(";");
        while (idx != -1) {
            String data = symptomdbPath.substring(0, idx);
            int i = data.indexOf(",");
            if (i != -1) {
                String filePath = data.substring(0, i);
                Path path = new Path(filePath);
                IResource res = workbench.getRoot().findMember((IPath)path);
                if (res != null && res.exists()) {
                    this.addColumn(filePath, data.substring(i + 1).equals("1"));
                }
            }
            symptomdbPath = symptomdbPath.substring(idx + 1);
            idx = symptomdbPath.indexOf(";");
        }
        int i = symptomdbPath.indexOf(",");
        if (i != -1) {
            String filePath = symptomdbPath.substring(0, i);
            Path path = new Path(filePath);
            IResource res = workbench.getRoot().findMember((IPath)path);
            Object col = null;
            if (res != null && res.exists()) {
                this.addColumn(filePath, symptomdbPath.substring(i + 1).equals("1"));
            }
        }
        this.populateList();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        int idx;
        if (e.widget == this._moveUp) {
            idx = this._list.getSelectionIndex();
            if (idx > 0) {
                this.moveUp(idx);
            }
        } else if (e.widget == this._moveDown) {
            idx = this._list.getSelectionIndex();
            if (idx != -1 && idx < this._list.getItemCount() - 1) {
                this.moveDown(idx);
            }
        } else {
            if (e.widget == this._selAll) {
                int idx2 = 0;
                while (idx2 < this._list.getItemCount()) {
                    TableItem item = this._list.getItem(idx2);
                    item.setChecked(true);
                    ++idx2;
                }
                return;
            }
            if (e.widget == this._unselAll) {
                int idx3 = 0;
                while (idx3 < this._list.getItemCount()) {
                    TableItem item = this._list.getItem(idx3);
                    item.setChecked(false);
                    ++idx3;
                }
                return;
            }
            if (e.widget == this._add) {
                this.launchImportWizard();
            }
        }
        idx = this._list.getSelectionIndex();
        ColumnData data = null;
        ColumnData previousData = null;
        if (idx > 0) {
            previousData = (ColumnData)this._list.getItem(idx - 1).getData();
        }
        if (idx != -1) {
            data = (ColumnData)this._list.getItem(idx).getData();
        }
        this._moveUp.setEnabled(data != null && previousData != null);
        this._moveDown.setEnabled(data != null && idx < this._list.getItemCount() - 1);
        this._selAll.setEnabled(this._list.getItemCount() > 0);
        this._unselAll.setEnabled(this._list.getItemCount() > 0);
    }

    public void storeValues(IPreferenceStore store) {
        String data = "";
        int idx = 0;
        while (idx < this._list.getItemCount()) {
            TableItem item = this._list.getItem(idx);
            String visible = item.getChecked() ? "1" : "0";
            data = data + ";" + item.getText() + "," + visible;
            ++idx;
        }
        if (data.startsWith(";") && data.length() > 1) {
            data = data.substring(1);
        }
        store.setValue("symptom_db_path", data);
    }

    private void launchImportWizard() {
        ImportSymptomDBWizard wizard = new ImportSymptomDBWizard();
        WizardDialog dialog = new WizardDialog(this.result.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(500, dialog.getShell().getSize().y);
        if (dialog.open() == 0) {
            this.addDBPath(SDbPlugin.getDefault().getPreferenceStore().getString("symptom_db_path"));
        }
    }

    private void addColumn(String filePath, boolean add) {
        ColumnData col = null;
        col = this.getColumn(filePath);
        if (col == null) {
            col = new ColumnData(filePath, add);
            this._data.add(col);
        } else {
            col.visible(add);
        }
    }

    private ColumnData getColumn(String col_name) {
        int i = 0;
        while (i < this._data.size()) {
            ColumnData col = (ColumnData)this._data.get(i);
            if (col.name().equals(col_name)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    class ColumnData {
        private String _name;
        private boolean _visible = false;

        public ColumnData(String name, boolean visible) {
            this._name = name;
            this._visible = visible;
        }

        public String name() {
            return this._name;
        }

        public void name(String name) {
            this._name = name;
        }

        public boolean visible() {
            return this._visible;
        }

        public void visible(boolean visible) {
            this._visible = visible;
        }
    }
}

