/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class RASWidgetFactory {
    public static final String DEFAULT_HEADER_COLOR = "__default__header__";
    public static final String COLOR_BACKGROUND = "__bg";
    public static final String COLOR_BORDER = "__border";
    public static final String COLOR_COMPOSITE_SEPARATOR = "__compSep";
    private Hashtable colorRegistry = new Hashtable();
    private Color backgroundColor;
    private Color clientAreaColor;
    private Color foregroundColor;
    private Color disabledColor;
    private Display display;
    public static final int BORDER_STYLE = 0;
    private BorderPainter borderPainter;
    private Color borderColor;

    public RASWidgetFactory() {
        this(Display.getCurrent());
    }

    public RASWidgetFactory(Display display) {
        this.display = display;
        this.initialize();
    }

    public Composite createComposite(Composite parent) {
        return this.createComposite(parent, 0);
    }

    public Composite createComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setBackground(this.backgroundColor);
        return composite;
    }

    public Button createButton(Composite parent, String text, int style) {
        int flatStyle = 0x800000;
        Button button = new Button(parent, style | flatStyle);
        button.setBackground(this.backgroundColor);
        button.setForeground(this.foregroundColor);
        if (text != null) {
            button.setText(text);
        }
        return button;
    }

    public Composite createCompositeSeparator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getColor(COLOR_COMPOSITE_SEPARATOR));
        GridData sepGrid = new GridData(768);
        sepGrid.heightHint = 3;
        composite.setLayoutData((Object)sepGrid);
        return composite;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0);
    }

    public Group createGroup(Composite parent, String text, int style) {
        Group groupWidget = new Group(parent, 0x800000);
        groupWidget.setText(text);
        groupWidget.setBackground(this.backgroundColor);
        return groupWidget;
    }

    public Table createTable(Composite parent, int style) {
        int flatStyle = 0x800000;
        return new Table(parent, style | flatStyle);
    }

    public Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        label.setBackground(this.backgroundColor);
        label.setForeground(this.foregroundColor);
        return label;
    }

    public Label createSeparator(Composite parent, int style) {
        Label label = new Label(parent, 2 | style);
        label.setBackground(this.backgroundColor);
        label.setForeground(this.borderColor);
        return label;
    }

    public Text createText(Composite parent, String value) {
        return this.createText(parent, value, 4);
    }

    public Text createText(Composite parent, String value, int style) {
        Text text = new Text(parent, style);
        if (value != null) {
            text.setText(value);
        }
        text.setBackground(this.clientAreaColor);
        text.setForeground(this.foregroundColor);
        return text;
    }

    public CCombo createCombo(Composite parent, int style) {
        CCombo combo = new CCombo(parent, 0x800000 | style);
        combo.setBackground(this.clientAreaColor);
        combo.setForeground(this.foregroundColor);
        return combo;
    }

    public Tree createTree(Composite parent, int style) {
        Tree tree = new Tree(parent, 0 | style);
        tree.setBackground(this.backgroundColor);
        tree.setForeground(this.foregroundColor);
        return tree;
    }

    public void dispose() {
        Enumeration colors = this.colorRegistry.elements();
        while (colors.hasMoreElements()) {
            Color c = (Color)colors.nextElement();
            c.dispose();
        }
        this.colorRegistry = null;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getClientAreaColor() {
        return this.clientAreaColor;
    }

    public Color getColor(String key) {
        return (Color)this.colorRegistry.get(key);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    private void initialize() {
        this.clientAreaColor = this.display.getSystemColor(25);
        this.registerColor(COLOR_BACKGROUND, 255, 254, 249);
        this.registerColor(COLOR_BORDER, 195, 191, 179);
        this.registerColor(COLOR_COMPOSITE_SEPARATOR, 152, 170, 203);
        this.registerColor(DEFAULT_HEADER_COLOR, 72, 112, 152);
        this.backgroundColor = this.clientAreaColor;
        this.borderColor = this.getColor(COLOR_BORDER);
        this.foregroundColor = this.display.getSystemColor(24);
        this.disabledColor = this.display.getSystemColor(15);
    }

    public void paintBordersFor(Composite parent) {
        if (this.borderPainter == null) {
            this.borderPainter = new BorderPainter();
        }
        parent.addPaintListener((PaintListener)this.borderPainter);
    }

    public void paintChildControlsFor(Composite parent) {
        this.paintBordersFor(parent);
        Control[] children = parent.getChildren();
        if (!parent.getBackground().equals((Object)this.getColor(COLOR_COMPOSITE_SEPARATOR))) {
            parent.setBackground(this.getBackgroundColor());
        }
        int i = 0;
        while (i < children.length) {
            Control c = children[i];
            if (c instanceof Text || c instanceof CCombo || c instanceof Label || c instanceof Button || c instanceof Tree) {
                c.setBackground(this.backgroundColor);
                c.setForeground(this.foregroundColor);
            } else if (c instanceof Composite) {
                this.paintChildControlsFor((Composite)c);
            }
            ++i;
        }
    }

    public Color registerColor(String key, int r, int g, int b) {
        Color c = new Color((Device)this.display, r, g, b);
        this.colorRegistry.put(key, c);
        return c;
    }

    class BorderPainter
    implements PaintListener {
        BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control c = children[i];
                if (c.isVisible()) {
                    GC gc;
                    Rectangle b;
                    if (c instanceof Text || c instanceof Canvas || c instanceof Combo || c instanceof CCombo) {
                        b = c.getBounds();
                        gc = event.gc;
                        if (c.isEnabled()) {
                            c.setBackground(RASWidgetFactory.this.backgroundColor);
                        } else {
                            c.setBackground(RASWidgetFactory.this.disabledColor);
                        }
                        c.setForeground(RASWidgetFactory.this.foregroundColor);
                        gc.drawRectangle(b.x - 2, b.y - 2, b.width + 3, b.height + 3);
                    } else if (c instanceof Tree || c instanceof Table) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(RASWidgetFactory.this.borderColor);
                        if (c.isEnabled()) {
                            c.setBackground(RASWidgetFactory.this.backgroundColor);
                        } else {
                            c.setBackground(RASWidgetFactory.this.disabledColor);
                        }
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                    }
                }
                ++i;
            }
        }
    }
}

