/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.sdb.internal.util.ResourceStateInputProvider;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidator;
import org.eclipse.hyades.sdb.internal.util.ResourceStateValidatorPresenter;

public class ResourceStateValidatorImpl
implements ResourceStateValidator {
    protected ResourceStateInputProvider provider;
    protected Map lastNonRefreshStateMap;

    public ResourceStateValidatorImpl(ResourceStateInputProvider aProvider) {
        this.provider = aProvider;
    }

    public void checkActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.checkConsistency(presenter);
    }

    public void lostActivation(ResourceStateValidatorPresenter presenter) throws CoreException {
        this.checkConsistency(presenter);
    }

    public boolean checkSave(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return false;
        }
        if (!this.provider.isDirty()) {
            return false;
        }
        List inconsistentFiles = this.getNonResourceInconsistentFiles();
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return true;
        }
        return presenter.promptForInconsistentFileOverwrite(inconsistentFiles);
    }

    public boolean checkReadOnly() {
        return this.checkReadOnlyNonResourceFiles();
    }

    private boolean checkReadOnlyNonResourceFiles() {
        List files = this.provider.getNonResourceFiles();
        if (files == null || files.isEmpty()) {
            return false;
        }
        int size = files.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isReadOnly()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void checkConsistency(ResourceStateValidatorPresenter presenter) throws CoreException {
        if (presenter == null) {
            return;
        }
        List inconsistentFiles = this.getNonResourceInconsistentFiles();
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return;
        }
        boolean shouldRefreshFiles = true;
        if (!this.anyFileChangedSinceLastRefreshPrompt(inconsistentFiles)) {
            return;
        }
        this.clearLastNonRefreshStateMap();
        shouldRefreshFiles = presenter.promptForInconsistentFileRefresh(inconsistentFiles);
        if (shouldRefreshFiles) {
            this.refreshFiles(inconsistentFiles);
        } else {
            this.cacheLastNonRefreshFileStamps(inconsistentFiles);
        }
    }

    private void cacheLastNonRefreshFileStamps(List inconsistentFiles) {
        if (inconsistentFiles != null && !inconsistentFiles.isEmpty()) {
            Map map = this.getLastNonRefreshStateMap();
            IFile file = null;
            long stamp = 0L;
            int i = 0;
            while (i < inconsistentFiles.size()) {
                file = (IFile)inconsistentFiles.get(i);
                stamp = this.computeModificationStamp(file);
                map.put(file, new Long(stamp));
                ++i;
            }
        }
    }

    private long computeModificationStamp(IFile file) {
        if (file == null) {
            return 0L;
        }
        long currentStamp = file.getModificationStamp();
        IPath path = file.getLocation();
        if (path != null) {
            return path.toFile().lastModified();
        }
        return currentStamp;
    }

    private void clearLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap != null) {
            this.lastNonRefreshStateMap.clear();
        }
    }

    private boolean anyFileChangedSinceLastRefreshPrompt(List inconsistentFiles) {
        if (inconsistentFiles == null || inconsistentFiles.isEmpty()) {
            return false;
        }
        if (this.lastNonRefreshStateMap == null || this.lastNonRefreshStateMap.isEmpty()) {
            return true;
        }
        int size = inconsistentFiles.size();
        IFile file = null;
        Long stamp = null;
        int i = 0;
        while (i < size) {
            file = (IFile)inconsistentFiles.get(i);
            stamp = (Long)this.getLastNonRefreshStateMap().get(file);
            if (stamp == null) {
                return true;
            }
            if (stamp.longValue() != this.computeModificationStamp(file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private List getNonResourceInconsistentFiles() {
        List files = this.provider.getNonResourceFiles();
        if (files == null || files.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFile> inconsistent = null;
        int size = files.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isAccessible() && !file.isSynchronized(0)) {
                if (inconsistent == null) {
                    inconsistent = new ArrayList<IFile>();
                }
                inconsistent.add(file);
            }
            ++i;
        }
        if (inconsistent == null) {
            inconsistent = Collections.EMPTY_LIST;
        }
        return inconsistent;
    }

    public IStatus validateState(ResourceStateValidatorPresenter presenter) throws CoreException {
        List nonResROFiles = null;
        nonResROFiles = this.selectReadOnlyFiles(this.provider.getNonResourceFiles());
        if (nonResROFiles == null || nonResROFiles.isEmpty()) {
            return ResourceStateValidator.OK_STATUS;
        }
        IFile[] files = new IFile[nonResROFiles.size()];
        nonResROFiles.toArray(files);
        IStatus result = ResourcesPlugin.getWorkspace().validateEdit(files, presenter.getValidateEditContext());
        if (!result.isOK()) {
            this.checkConsistency(presenter);
        }
        return result;
    }

    private List selectReadOnlyFiles(List files) {
        if (files == null || files.isEmpty()) {
            return files;
        }
        int size = files.size();
        ArrayList<IFile> readOnly = null;
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)files.get(i);
            if (file.isReadOnly()) {
                if (readOnly == null) {
                    readOnly = new ArrayList<IFile>(size);
                }
                readOnly.add(file);
            }
            ++i;
        }
        return readOnly;
    }

    private void filterNonReadOnlyFiles(List roFiles) {
        ArrayList<IFile> removedFiles = null;
        IFile file = null;
        int i = 0;
        while (i < roFiles.size()) {
            file = (IFile)roFiles.get(i);
            if (file.isReadOnly()) {
                if (removedFiles == null) {
                    removedFiles = new ArrayList<IFile>(roFiles.size());
                }
                removedFiles.add(file);
            }
            ++i;
        }
        if (removedFiles != null) {
            roFiles.removeAll(removedFiles);
        }
    }

    protected void refreshFiles(List someFiles) throws CoreException {
        RefreshRunnable runnable = new RefreshRunnable(someFiles);
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)runnable, null);
        if (runnable.getThrownException() != null) {
            throw runnable.getThrownException();
        }
    }

    protected void primRefreshFiles(List someFiles) throws CoreException {
        int size = someFiles.size();
        IFile file = null;
        int i = 0;
        while (i < size) {
            file = (IFile)someFiles.get(i);
            file.refreshLocal(1, null);
            ++i;
        }
    }

    protected Map getLastNonRefreshStateMap() {
        if (this.lastNonRefreshStateMap == null) {
            this.lastNonRefreshStateMap = new HashMap();
        }
        return this.lastNonRefreshStateMap;
    }

    class RefreshRunnable
    implements IWorkspaceRunnable {
        CoreException thrownException;
        List files;

        RefreshRunnable(List someFiles) {
            this.files = someFiles;
        }

        public CoreException getThrownException() {
            return this.thrownException;
        }

        public void run(IProgressMonitor aMonitor) {
            try {
                ResourceStateValidatorImpl.this.primRefreshFiles(this.files);
            }
            catch (CoreException e) {
                this.thrownException = e;
            }
        }
    }
}

