/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBMatchPattern;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

public class SymptomDBExportUtil {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.NL + "" + this.NL + "<!DOCTYPE symptomDatabase [" + this.NL + "" + this.NL + "<!ELEMENT symptomDatabase (runtime+)>" + this.NL + "" + this.NL + "<!ELEMENT runtime (symptom+ , solution+ , directive*)>" + this.NL + "<!ATTLIST runtime" + this.NL + "    id ID #REQUIRED" + this.NL + "    name CDATA #IMPLIED" + this.NL + "    symptomUrl CDATA #IMPLIED" + this.NL + "    localExternalFileLocation CDATA #IMPLIED>" + this.NL + "" + this.NL + "<!ELEMENT symptom (matchPattern+)>" + this.NL + "<!ATTLIST symptom" + this.NL + "    id ID #REQUIRED" + this.NL + "    description CDATA #IMPLIED" + this.NL + "    solutions IDREFS #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT matchPattern EMPTY>" + this.NL + "<!ATTLIST matchPattern" + this.NL + "    name CDATA #IMPLIED" + this.NL + "    value CDATA #REQUIRED>" + this.NL + "" + this.NL + "<!ELEMENT solution EMPTY>" + this.NL + "<!ATTLIST solution" + this.NL + "    id ID #REQUIRED" + this.NL + "    description CDATA #IMPLIED" + this.NL + "    directives IDREFS #IMPLIED>" + this.NL + "" + this.NL + "<!ELEMENT directive EMPTY>" + this.NL + "<!ATTLIST directive" + this.NL + "    id ID #REQUIRED" + this.NL + "    description CDATA #IMPLIED" + this.NL + "    directiveString CDATA #REQUIRED>" + this.NL + "]>" + this.NL + "" + this.NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + this.NL + "" + this.NL + "<symptomDatabase>" + this.NL + "    <runtime id=\"Runtime_0\" name=\"";
    protected final String TEXT_2 = "\" symptomUrl=\"";
    protected final String TEXT_3 = "\" localExternalFileLocation=\"";
    protected final String TEXT_4 = "\">" + this.NL + "    " + this.NL + "        <!-- Symptoms: -->" + this.NL;
    protected final String TEXT_5 = "         " + this.NL + "        <symptom id=\"Symptom_";
    protected final String TEXT_6 = "\" description=\"";
    protected final String TEXT_7 = "\" ";
    protected final String TEXT_8 = "solutions=\"";
    protected final String TEXT_9 = "\"";
    protected final String TEXT_10 = ">";
    protected final String TEXT_11 = this.NL + "            <matchPattern name=\"";
    protected final String TEXT_12 = "\" value=\"";
    protected final String TEXT_13 = "\"/>";
    protected final String TEXT_14 = "               " + this.NL + "        </symptom>";
    protected final String TEXT_15 = this.NL + this.NL + "        <!-- Solutions: -->" + this.NL;
    protected final String TEXT_16 = "         " + this.NL + "        <solution id=\"Solution_";
    protected final String TEXT_17 = "\" description=\"";
    protected final String TEXT_18 = "\" ";
    protected final String TEXT_19 = "directives=\"";
    protected final String TEXT_20 = "\"";
    protected final String TEXT_21 = "/>";
    protected final String TEXT_22 = this.NL + "     " + this.NL + "        <!-- Directives: -->" + this.NL;
    protected final String TEXT_23 = this.NL + "        <directive id=\"Directive_";
    protected final String TEXT_24 = "\" description=\"";
    protected final String TEXT_25 = "\" directiveString=\"";
    protected final String TEXT_26 = "\"/>";
    protected final String TEXT_27 = this.NL + "    </runtime>" + this.NL + "</symptomDatabase>";

    public String normalize(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer normalizedString = new StringBuffer();
        int counter = 0;
        while (counter < string.length()) {
            char character = string.charAt(counter);
            if (character == '<') {
                normalizedString.append("&lt;");
            } else if (character == '>') {
                normalizedString.append("&gt;");
            } else if (character == '&') {
                normalizedString.append("&amp;");
            } else if (character == '\"') {
                normalizedString.append("&quot;");
            } else if (character == '\'') {
                normalizedString.append("&apos;");
            } else if (character == '\r') {
                normalizedString.append("&#xD;");
            } else if (character == '\n') {
                normalizedString.append("&#xA;");
            } else if (character == '\t') {
                normalizedString.append("&#x9;");
            } else {
                normalizedString.append(character);
            }
            ++counter;
        }
        return normalizedString.toString();
    }

    public String generate(SDBRuntime root, IProgressMonitor monitor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        stringBuffer.append(this.normalize(root.getName()));
        stringBuffer.append("\" symptomUrl=\"");
        stringBuffer.append(this.normalize(root.getSymptomUrl()));
        stringBuffer.append("\" localExternalFileLocation=\"");
        stringBuffer.append(this.normalize(root.getLocalExternalFileLocation()));
        stringBuffer.append(this.TEXT_4);
        EList symptList = root.getSymptoms();
        EList solutionList = root.getSolutions();
        EList directivesList = root.getDirectives();
        int units = symptList.size() + solutionList.size() + directivesList.size();
        int i = 0;
        int j = 0;
        int k = 0;
        if (!symptList.isEmpty()) {
            i = 0;
            while (i < symptList.size()) {
                SDBSymptom current = (SDBSymptom)symptList.get(i);
                EList solList = current.getSolutions();
                String solutions = "";
                if (!solList.isEmpty()) {
                    j = 0;
                    while (j < solList.size() - 1) {
                        k = solutionList.indexOf((Object)((SDBSolution)solList.get(j)));
                        solutions = solutions + "Solution_" + k + " ";
                        ++j;
                    }
                    k = solutionList.indexOf((Object)((SDBSolution)solList.get(j)));
                    solutions = solutions + "Solution_" + k;
                }
                stringBuffer.append(this.TEXT_5);
                stringBuffer.append(i);
                stringBuffer.append("\" description=\"");
                stringBuffer.append(this.normalize(current.getDescription()));
                stringBuffer.append("\" ");
                if (!solutions.equals("")) {
                    stringBuffer.append("solutions=\"");
                    stringBuffer.append(solutions);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                EList patternList = current.getPatterns();
                if (!patternList.isEmpty()) {
                    j = 0;
                    while (j < patternList.size()) {
                        SDBMatchPattern pattern = (SDBMatchPattern)patternList.get(j);
                        stringBuffer.append(this.TEXT_11);
                        stringBuffer.append(this.normalize(pattern.getName()));
                        stringBuffer.append("\" value=\"");
                        stringBuffer.append(this.normalize(pattern.getValue()));
                        stringBuffer.append("\"/>");
                        ++j;
                    }
                }
                monitor.worked(8000 / units);
                stringBuffer.append(this.TEXT_14);
                ++i;
            }
        }
        stringBuffer.append(this.TEXT_15);
        if (!solutionList.isEmpty()) {
            i = 0;
            while (i < solutionList.size()) {
                SDBSolution sol = (SDBSolution)solutionList.get(i);
                EList dirList = sol.getDirectives();
                String directives = "";
                k = 0;
                if (!dirList.isEmpty()) {
                    j = 0;
                    while (j < dirList.size() - 1) {
                        k = directivesList.indexOf((Object)((SDBDirective)dirList.get(j)));
                        directives = directives + "Directive_" + k + " ";
                        ++j;
                    }
                    k = directivesList.indexOf((Object)((SDBDirective)dirList.get(j)));
                    directives = directives + "Directive_" + k;
                }
                stringBuffer.append(this.TEXT_16);
                stringBuffer.append(i);
                stringBuffer.append("\" description=\"");
                stringBuffer.append(this.normalize(sol.getDescription()));
                stringBuffer.append("\" ");
                if (!directives.equals("")) {
                    stringBuffer.append("directives=\"");
                    stringBuffer.append(directives);
                    stringBuffer.append("\"");
                }
                stringBuffer.append("/>");
                monitor.worked(8000 / units);
                ++i;
            }
        }
        stringBuffer.append(this.TEXT_22);
        if (!directivesList.isEmpty()) {
            i = 0;
            while (i < directivesList.size()) {
                SDBDirective dir = (SDBDirective)directivesList.get(i);
                stringBuffer.append(this.TEXT_23);
                stringBuffer.append(i);
                stringBuffer.append("\" description=\"");
                stringBuffer.append(this.normalize(dir.getDescription()));
                stringBuffer.append("\" directiveString=\"");
                stringBuffer.append(this.normalize(dir.getDirectiveString()));
                stringBuffer.append("\"/>");
                monitor.worked(8000 / units);
                ++i;
            }
        }
        stringBuffer.append(this.TEXT_27);
        return stringBuffer.toString();
    }
}

