/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.cbe;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;

public class CBEUtils {
    public static double computeAdjustedCreationTime(CBECommonBaseEvent event) {
        double creationTime = event.getCreationTime();
        try {
            return creationTime + event.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
        }
        catch (Exception e) {
            return creationTime;
        }
    }

    public static String formatCreationTime(CBECommonBaseEvent event, DateFormat dateFormat) {
        if (event.getCreationTime() != 0.0) {
            try {
                short value = event.getTimeZone();
                double ct = CBEUtils.computeAdjustedCreationTime(event);
                Double l2 = new Double(ct);
                String microseconds = "" + l2.longValue() % 1000000L;
                String ms = "." + "000000".substring(0, 6 - microseconds.length()) + microseconds;
                ms = ms + (value > 0 ? "+00" : "-00").substring(0, 3 - ("" + Math.abs(value / 60)).length()) + Math.abs(value / 60);
                ms = ms + ":00".substring(0, 3 - ("" + Math.abs(value % 60)).length()) + Math.abs(value % 60);
                StringBuffer toAppendTo = new StringBuffer();
                FieldPosition fieldPosition = new FieldPosition(7);
                dateFormat.format(new Date(l2.longValue() / 1000L + (long)(value * 60 * 1000)), toAppendTo, fieldPosition);
                if (fieldPosition.getEndIndex() > 0) {
                    toAppendTo.insert(fieldPosition.getEndIndex(), ms);
                }
                return toAppendTo.toString();
            }
            catch (Exception e) {
            }
        }
        return "0";
    }
}

