/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.models.cbe.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LeftOperand;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByElement;
import org.eclipse.hyades.models.hierarchy.extensions.OrderByOperators;
import org.eclipse.hyades.models.hierarchy.extensions.Query;
import org.eclipse.hyades.models.hierarchy.extensions.QueryResult;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleBinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.TimeBasedCorrelationQuery;
import org.eclipse.hyades.models.hierarchy.util.IFilterElement;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.ILogFilterCriteria;
import org.eclipse.hyades.models.hierarchy.util.ISortElement;

public class LogQueryBuilder {
    public static Query createQuery(List inputList, ILogFilterCriteria element, EAttribute attribute) {
        SimpleSearchQuery query = LogQueryBuilder.addAgents(inputList, element);
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(HierarchyPackage.eINSTANCE.getTRCAgent());
        query.getOutputElements().add((Object)leftOperand);
        leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setFeature((EStructuralFeature)attribute);
        query.getOutputElements().add((Object)leftOperand);
        return query;
    }

    public static Query createQuery(List inputList, ILogFilterCriteria element) {
        Query query = null;
        EObject inputObject = null;
        int s = inputList.size();
        int i = 0;
        while (i < s) {
            inputObject = (EObject)inputList.get(i);
            if (inputObject instanceof TRCAgentProxy) {
                if (query == null) {
                    query = LogQueryBuilder.createQueryFromAgentProxy((TRCAgentProxy)inputObject, element);
                } else if (i == 0) {
                    LogQueryBuilder.addAgentToQuery((SimpleSearchQuery)query, (TRCAgentProxy)inputObject, element);
                } else {
                    LogQueryBuilder.addAgentToQuery((SimpleSearchQuery)query, (TRCAgentProxy)inputObject, null);
                }
            } else if (inputObject instanceof CorrelationContainerProxy) {
                query = LogQueryBuilder.createQueryFromAgents((List)((CorrelationContainerProxy)inputObject).getCorrelatedAgents(), element);
            }
            ++i;
        }
        if (query != null) {
            query.setDistinct(true);
        }
        return query;
    }

    public static QueryResult executeQuery(Query query, ResourceSet resourceSet) {
        if (query == null || query.getSources().size() == 0) {
            return null;
        }
        QueryResult queryResult = null;
        String url = (String)query.getSources().get(0);
        IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension)HyadesResourceExtensions.getInstance().get((Object)LoadersUtils.getPostfix((String)url));
        if (hyadesResourceExtension != null) {
            ArrayList<EClass> notLoadedTypes = new ArrayList<EClass>();
            notLoadedTypes.add(HierarchyPackage.eINSTANCE.getAbstractDefaultEvent());
            notLoadedTypes.add(HierarchyPackage.eINSTANCE.getTRCAgentProxy());
            queryResult = hyadesResourceExtension.executeQuery(query, resourceSet, notLoadedTypes);
            return queryResult;
        }
        return queryResult;
    }

    public static Query createSearchQuery(List inputList, ILogFilterCriteria filterElement, ILogFilterCriteria searchElement) {
        Query query = LogQueryBuilder.createQuery(inputList, filterElement);
        query = query == null ? LogQueryBuilder.createQuery(inputList, searchElement) : LogQueryBuilder.getMergedQuery(query, searchElement);
        return query;
    }

    public static Query createSearchQuery(Query query, ILogFilterCriteria searchElement) {
        if (query instanceof CorrelationQuery) {
            CorrelationQuery searchQuery = (CorrelationQuery)EcoreUtil.copy((EObject)query);
            SimpleSearchQuery searchSubQuery = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
            EList whereCriteria = searchSubQuery.getWhereExpressions();
            IFilterElement[] searchFilters = searchElement.getFilters();
            EList attributes = CBEPackage.eINSTANCE.getCBECommonBaseEvent().getEAllAttributes();
            EAttribute attribute = null;
            int i = 0;
            while (i < searchFilters.length) {
                attribute = LogQueryBuilder.findAttributeInList(searchFilters[i].getAttribute(), (List)attributes);
                if (attribute != null && !LogQueryBuilder.isFilterInWhereClause(searchFilters[i], (List)whereCriteria)) {
                    whereCriteria.add(LogQueryBuilder.createBinaryExpression(searchFilters[i], attribute));
                }
                ++i;
            }
            searchQuery.getSubQuery().add((Object)searchSubQuery);
            return searchQuery;
        }
        return LogQueryBuilder.getMergedQuery(query, searchElement);
    }

    public static Query getMergedQuery(Query query, ILogFilterCriteria mergeElement) {
        SimpleSearchQuery searchQuery = (SimpleSearchQuery)EcoreUtil.copy((EObject)query);
        EList whereCriteria = searchQuery.getWhereExpressions();
        IFilterElement[] searchFilters = mergeElement.getFilters();
        EList attributes = CBEPackage.eINSTANCE.getCBECommonBaseEvent().getEAllAttributes();
        EAttribute attribute = null;
        int i = 0;
        while (i < searchFilters.length) {
            attribute = LogQueryBuilder.findAttributeInList(searchFilters[i].getAttribute(), (List)attributes);
            if (attribute != null && !LogQueryBuilder.isFilterInWhereClause(searchFilters[i], (List)whereCriteria)) {
                whereCriteria.add(LogQueryBuilder.createBinaryExpression(searchFilters[i], attribute));
            }
            ++i;
        }
        return searchQuery;
    }

    public static Query createCorrelation(List agentProxies) {
        TimeBasedCorrelationQuery query = ExtensionsFactory.eINSTANCE.createTimeBasedCorrelationQuery();
        int s = agentProxies.size();
        EObject inputObject = null;
        double delta = 0.0;
        int i = 0;
        while (i < s) {
            inputObject = (EObject)agentProxies.get(i);
            if (inputObject instanceof TRCAgentProxy) {
                LogQueryBuilder.addAgentToQuery((SimpleSearchQuery)query, (TRCAgentProxy)inputObject, null);
                delta = ((TRCAgentProxy)inputObject).getProcessProxy() != null && ((TRCAgentProxy)inputObject).getProcessProxy().getNode() != null ? ((TRCAgentProxy)inputObject).getProcessProxy().getNode().getDeltaTime() : 0.0;
                query.getDeltaTime().add((Object)new Double(delta));
            }
            ++i;
        }
        return query;
    }

    public static Query createCorrelatedEventsQuery(List agentProxies) {
        TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation(agentProxies);
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        query.getOutputElements().add((Object)leftOperand);
        return query;
    }

    public static Query createOutboundCorrelationQuery(List agentProxies, ILogFilterCriteria filter) {
        TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation(agentProxies);
        LeftOperand leftOperand1 = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand1.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Key());
        query.getOutputElements().add((Object)leftOperand1);
        LeftOperand leftOperand2 = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand2.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Value());
        query.getOutputElements().add((Object)leftOperand2);
        return LogQueryBuilder.getMergedQuery((Query)query, filter);
    }

    public static Query createInboundCorrelationQuery(List agentProxies, ILogFilterCriteria filter) {
        TimeBasedCorrelationQuery query = (TimeBasedCorrelationQuery)LogQueryBuilder.createCorrelation(agentProxies);
        LeftOperand leftOperand1 = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand1.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Value());
        query.getOutputElements().add((Object)leftOperand1);
        LeftOperand leftOperand2 = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand2.setFeature((EStructuralFeature)HierarchyPackage.eINSTANCE.getCorrelationEntry_Key());
        query.getOutputElements().add((Object)leftOperand2);
        return LogQueryBuilder.getMergedQuery((Query)query, filter);
    }

    private static void addAgentToQuery(SimpleSearchQuery query, TRCAgentProxy inputObject, ILogFilterCriteria element) {
        TRCAgent agent = (TRCAgent)inputObject.eGet((EStructuralFeature)HierarchyPackage.eINSTANCE.getTRCAgentProxy_Agent(), false);
        if (agent != null) {
            query.getSources().add((Object)EcoreUtil.getURI((EObject)agent).toString());
            if (element != null) {
                query.getWhereExpressions().addAll((Collection)LogQueryBuilder.createWhereClause(CBEPackage.eINSTANCE.getCBECommonBaseEvent(), element.getFilters()));
                LogQueryBuilder.addSeverityFilters(query, element);
                query.getOrderByExpresions().addAll((Collection)LogQueryBuilder.createOrderByClause(CBEPackage.eINSTANCE.getCBECommonBaseEvent(), element.getSortColumns()));
            }
        }
    }

    private static void addSeverityFilters(SimpleSearchQuery query, ILogFilterCriteria element) {
        Map options = element.getFilterOptions();
        if (options != null) {
            if (options.get("sev1").equals("1") && options.get("sev2").equals("1") && options.get("sev3").equals("1")) {
                return;
            }
            if (options.get("sev1").equals("1") && options.get("sev2").equals("0") && options.get("sev3").equals("0")) {
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(49)));
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(71)));
            } else if (options.get("sev1").equals("1") && options.get("sev2").equals("1") && options.get("sev3").equals("0")) {
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(29)));
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(71)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("1") && options.get("sev3").equals("0")) {
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(29)));
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(50)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("1") && options.get("sev3").equals("0")) {
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)1), new Integer(29)));
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(50)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("1") && options.get("sev3").equals("1")) {
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(50)));
            } else if (options.get("sev1").equals("0") && options.get("sev2").equals("0") && options.get("sev3").equals("1")) {
                query.getWhereExpressions().add((Object)LogQueryBuilder.createBinaryExpression(CBEPackage.eINSTANCE.getCBECommonBaseEvent_Severity(), RelationalOperators.get((int)0), new Integer(30)));
            }
        }
    }

    private static Query createQueryFromAgents(List inputList, ILogFilterCriteria element) {
        SimpleSearchQuery query = LogQueryBuilder.addAgents(inputList, element);
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        query.getOutputElements().add((Object)leftOperand);
        return query;
    }

    private static SimpleSearchQuery addAgents(List inputList, ILogFilterCriteria element) {
        int s = inputList.size();
        TRCAgentProxy agentProxy = null;
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        int i = 0;
        while (i < s) {
            agentProxy = (TRCAgentProxy)inputList.get(i);
            LogQueryBuilder.addAgentToQuery(query, agentProxy, element);
            ++i;
        }
        return query;
    }

    private static Query createQueryFromAgentProxy(TRCAgentProxy inputObject, ILogFilterCriteria element) {
        SimpleSearchQuery query = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setType(CBEPackage.eINSTANCE.getCBECommonBaseEvent());
        query.getOutputElements().add((Object)leftOperand);
        LogQueryBuilder.addAgentToQuery(query, inputObject, element);
        return query;
    }

    private static List createWhereClause(EClass eClass, IFilterElement[] elements) {
        ArrayList<SimpleBinaryExpression> whereCriteria = new ArrayList<SimpleBinaryExpression>();
        EList attributes = eClass.getEAllAttributes();
        EAttribute attribute = null;
        int i = 0;
        while (i < elements.length) {
            attribute = LogQueryBuilder.findAttributeInList(elements[i].getAttribute(), (List)attributes);
            if (attribute != null) {
                whereCriteria.add(LogQueryBuilder.createBinaryExpression(elements[i], attribute));
            }
            ++i;
        }
        return whereCriteria;
    }

    private static SimpleBinaryExpression createBinaryExpression(IFilterElement element, EAttribute attribute) {
        SimpleBinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createSimpleBinaryExpression();
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setFeature((EStructuralFeature)attribute);
        binaryExpression.setOperand(leftOperand);
        String value = element.getValue();
        if (element.getOperator().equals("=")) {
            if (value.indexOf(42) > -1) {
                value = value.replace('*', '%');
                binaryExpression.setOperator(RelationalOperators.LIKE_LITERAL);
            } else {
                binaryExpression.setOperator(RelationalOperators.EQ_LITERAL);
            }
        } else if (element.getOperator().equals("<")) {
            binaryExpression.setOperator(RelationalOperators.LT_LITERAL);
        } else if (element.getOperator().equals(">")) {
            binaryExpression.setOperator(RelationalOperators.GT_LITERAL);
        } else if (element.getOperator().equals("LIKE")) {
            binaryExpression.setOperator(RelationalOperators.LIKE_LITERAL);
        }
        binaryExpression.setRightOperand(LogQueryBuilder.convertToType(attribute.getEType(), value));
        return binaryExpression;
    }

    private static Object convertToType(EClassifier attribute, String value) {
        if (attribute instanceof EDataType) {
            return EcoreFactory.eINSTANCE.createFromString((EDataType)attribute, value);
        }
        return value;
    }

    private static void formatFilterValue(String string) {
        StringBuffer sb = new StringBuffer();
        int l = string.length();
        int i = 0;
        while (i < l) {
            char ch = string.charAt(i);
            if (ch == '%') {
                sb.append("\\%");
            } else if (ch == '_') {
                sb.append("\\_");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        string = sb.toString();
    }

    private static SimpleBinaryExpression createBinaryExpression(EAttribute attribute, RelationalOperators operator, Object value) {
        SimpleBinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createSimpleBinaryExpression();
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setFeature((EStructuralFeature)attribute);
        binaryExpression.setOperand(leftOperand);
        binaryExpression.setOperator(operator);
        binaryExpression.setRightOperand(value);
        return binaryExpression;
    }

    private static List createOrderByClause(EClass eClass, ISortElement[] elements) {
        if (elements == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<OrderByElement> orderByCriteria = new ArrayList<OrderByElement>();
        EList attributes = eClass.getEAllAttributes();
        EAttribute attribute = null;
        int i = 0;
        while (i < elements.length) {
            attribute = LogQueryBuilder.findAttributeInList(elements[i].getSortColumn(), (List)attributes);
            if (attribute != null) {
                orderByCriteria.add(LogQueryBuilder.createOrderByElement(elements[i], attribute));
            }
            ++i;
        }
        return orderByCriteria;
    }

    private static OrderByElement createOrderByElement(ISortElement element, EAttribute attribute) {
        OrderByElement orderByElement = ExtensionsFactory.eINSTANCE.createOrderByElement();
        LeftOperand leftOperand = ExtensionsFactory.eINSTANCE.createLeftOperand();
        leftOperand.setFeature((EStructuralFeature)attribute);
        orderByElement.setOperand(leftOperand);
        if (element.isAscending()) {
            orderByElement.setOperator(OrderByOperators.ASC_LITERAL);
        } else {
            orderByElement.setOperator(OrderByOperators.DESC_LITERAL);
        }
        return orderByElement;
    }

    private static EAttribute findAttributeInList(String name, List attributeList) {
        int s = attributeList.size();
        int i = 0;
        while (i < s) {
            EAttribute attr = (EAttribute)attributeList.get(i);
            if (attr.getName().equalsIgnoreCase(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    private static boolean isFilterInWhereClause(IFilterElement element, List whereClause) {
        int s = whereClause.size();
        SimpleBinaryExpression where = null;
        int i = 0;
        while (i < s) {
            where = (SimpleBinaryExpression)whereClause.get(i);
            if (where != null && where.getOperand().getFeature().getName().equalsIgnoreCase(element.getAttribute()) && where.getOperator() == RelationalOperators.get((String)element.getOperator()) && element.getValue().equals(where.getRightOperand())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean compare(Query query1, Query query2) {
        EList outputElements1 = query1.getOutputElements();
        EList outputElements2 = query2.getOutputElements();
        if (outputElements1.size() != outputElements2.size()) {
            return false;
        }
        int s = outputElements1.size();
        int i = 0;
        while (i < s) {
            LeftOperand left1 = (LeftOperand)outputElements1.get(i);
            LeftOperand left2 = (LeftOperand)outputElements2.get(i);
            if (left1 != null && left2 == null || left1 == null && left2 != null) {
                return false;
            }
            if (left1 != null && left2 != null && left1.getType() != left2.getType()) {
                return false;
            }
            if (left1 != null && left2 != null && left1.getFeature() != left2.getFeature()) {
                return false;
            }
            ++i;
        }
        EList sourceElements1 = query1.getSources();
        EList sourceElements2 = query2.getSources();
        if (sourceElements1.size() != sourceElements2.size()) {
            return false;
        }
        s = sourceElements1.size();
        int i2 = 0;
        while (i2 < s) {
            if (sourceElements1.get(i2) != null && !sourceElements1.get(i2).equals(sourceElements2.get(i2))) {
                return false;
            }
            ++i2;
        }
        if (query1 instanceof SimpleSearchQuery && query2 instanceof SimpleSearchQuery) {
            EList whereElements1 = ((SimpleSearchQuery)query1).getWhereExpressions();
            EList whereElements2 = ((SimpleSearchQuery)query2).getWhereExpressions();
            if (whereElements1.size() != whereElements2.size()) {
                return false;
            }
            s = whereElements1.size();
            int i3 = 0;
            while (i3 < s) {
                SimpleBinaryExpression expression1 = (SimpleBinaryExpression)whereElements1.get(i3);
                SimpleBinaryExpression expression2 = (SimpleBinaryExpression)whereElements2.get(i3);
                if (expression1 != null && expression2 == null || expression1 == null && expression2 != null) {
                    return false;
                }
                if (expression1.getOperand().getFeature() != expression2.getOperand().getFeature()) {
                    return false;
                }
                if (expression1.getOperator().getValue() != expression2.getOperator().getValue()) {
                    return false;
                }
                if (!expression1.getRightOperand().equals(expression2.getRightOperand())) {
                    return false;
                }
                ++i3;
            }
        }
        return true;
    }
}

