/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SDViewerPlugin
extends AbstractUIPlugin {
    public static final String LOADER_TAG = "uml2SDLoader";
    public static final String LOADER_PREFIX = "uml2SDLoader.";
    private static SDViewerPlugin plugin;
    private ResourceBundle resourceBundle;
    private static HashMap viewLoadersList;
    private static URL BASIC_URL;

    public SDViewerPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            this.resourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        BackgroundLoader.shutdown();
        super.stop(context);
    }

    public static List getLoaders(String viewId) {
        List list = (List)viewLoadersList.get(viewId);
        if (list != null) {
            return list;
        }
        ArrayList<IConfigurationElement> ret = new ArrayList<IConfigurationElement>();
        IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint(SDViewerPlugin.getId(), LOADER_TAG);
        IExtension[] ie = iep.getExtensions();
        int i = 0;
        while (i < ie.length) {
            IConfigurationElement[] c = ie[i].getConfigurationElements();
            int j = 0;
            while (j < c.length) {
                if (viewId.equals(c[j].getAttribute("view"))) {
                    ret.add(c[j]);
                }
                ++j;
            }
            ++i;
        }
        viewLoadersList.put(viewId, ret);
        return ret;
    }

    public static void createLoaderForView(String viewId, IConfigurationElement ce) {
        try {
            Object obj = ce.createExecutableExtension("class");
            IUml2SDLoader l = (IUml2SDLoader)obj;
            if (viewId != null) {
                LoadersManager.getLoadersManager().setCurrentLoader(l, viewId);
            }
        }
        catch (CoreException e4) {
            System.err.println("Error 'uml2SDLoader' Extension point :" + (Object)((Object)e4));
        }
        catch (Exception e5) {
            e5.printStackTrace();
            System.err.println("Error 'uml2SDLoader' Extension point :" + e5);
        }
    }

    public static String timeToString(double time) {
        String ret;
        if (Math.abs(time) > 86400.0) {
            int days = (int)(time / 86400.0);
            int hours = Math.abs((int)(time % 86400.0) / 3600);
            if (time < 0.0 && days == 0) {
                days = -days;
            }
            ret = days != 1 && days != -1 ? MessageFormat.format(SDViewerPlugin.getResourceString("STR_DAYS_HOURS"), new Integer(days), new Integer(hours)) : MessageFormat.format(SDViewerPlugin.getResourceString("STR_DAY_HOURS"), new Integer(days), new Integer(hours));
        } else if (Math.abs(time) > 3600.0) {
            int hours = (int)(time / 3600.0);
            int mins = Math.abs((int)(time % 3600.0) / 60);
            if (time < 0.0 && hours == 0) {
                hours = -hours;
            }
            ret = MessageFormat.format(SDViewerPlugin.getResourceString("STR_HOURS_MINUTES"), new Integer(hours), new Integer(mins));
        } else if (Math.abs(time) > 60.0) {
            int mins = (int)(time / 60.0);
            int s = (int)(time % 60.0);
            if (time < 0.0 && mins == 0) {
                mins = -mins;
            }
            ret = MessageFormat.format(SDViewerPlugin.getResourceString("STR_MINUTES_SECONDS"), new Integer(mins), new Integer(s));
        } else {
            double s = (int)time;
            double us = Math.abs((time - s) * 1000000.0);
            if (time < 0.0 && s == 0.0) {
                s = -s;
            }
            ret = MessageFormat.format(SDViewerPlugin.getResourceString("STR_SECONDS_MICROSECONDS"), new Double(s), new Double(us));
        }
        return ret;
    }

    public String getSavedLoader(String viewId) {
        Preferences p = this.getPluginPreferences();
        return p.getString(LOADER_PREFIX + viewId);
    }

    public void setLastLoader(String id, String id2) {
        Preferences p = this.getPluginPreferences();
        p.setValue(LOADER_PREFIX + id2, id);
    }

    public static SDViewerPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SDViewerPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static ImageDescriptor getResourceImage(String _name) {
        try {
            URL url = new URL(BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/" + _name);
            ImageDescriptor img = ImageDescriptor.createFromURL((URL)url);
            return img;
        }
        catch (Exception E) {
            System.err.println(E);
            return null;
        }
    }

    public static String getId() {
        return SDViewerPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static boolean debugIndex() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/updateindex").equalsIgnoreCase("true");
    }

    public static boolean debugDisplay() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/display").equalsIgnoreCase("true");
    }

    public static boolean debugDoubleBuffer() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/doublebuffer").equalsIgnoreCase("true");
    }

    public static boolean debugSorting() {
        return SDViewerPlugin.debug() && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/sorting").equalsIgnoreCase("true");
    }

    public static boolean debug() {
        return Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/debug") != null && Platform.getDebugOption((String)"org.eclipse.hyades.uml2sd.ui/debug").equalsIgnoreCase("true");
    }

    static {
        viewLoadersList = new HashMap();
        BASIC_URL = null;
        try {
            BASIC_URL = new URL("platform", "localhost", "plugin");
        }
        catch (Exception E) {
            System.err.println(E);
        }
    }
}

