/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.ui.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.ITimeRange;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.Metrics;
import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;
import org.eclipse.hyades.uml2sd.ui.preferences.SDViewPref;

public class BasicFrame
extends GraphNode {
    protected double maxTime = -50.0;
    protected double minTime = -50.0;
    protected boolean computeMinMax = true;
    protected boolean lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
    protected int verticalIndex = 0;
    protected int horizontalIndex = 0;
    protected boolean timeInfo = false;
    private int visibleAreaX;
    private int visibleAreaY;
    private int visibleAreaWidth;
    private int visibleAreaHeight;
    protected static ISDPreferences userPref = null;
    protected String unitName = null;
    protected int forceEventOccurrenceSpacing = -1;
    public HashMap nodes = new HashMap();
    public HashMap fnodes = new HashMap();
    public HashMap bnodes = new HashMap();
    public HashMap indexes = new HashMap();
    public HashMap fSort;
    public HashMap bSort = new HashMap();

    public BasicFrame() {
        this.fSort = new HashMap();
        Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
    }

    public void resetIndex() {
        Iterator it = this.indexes.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            this.indexes.put(nodeType, new Integer(0));
        }
    }

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int eventOccurrence) {
        this.verticalIndex = eventOccurrence;
    }

    protected int getNewHorizontalIndex() {
        return ++this.horizontalIndex;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public void addNode(GraphNode nodeToAdd) {
        this.computeMinMax = true;
        if (nodeToAdd == null) {
            return;
        }
        if (this.nodes.get(nodeToAdd.getArrayId()) == null) {
            this.nodes.put(nodeToAdd.getArrayId(), new ArrayList());
            this.indexes.put(nodeToAdd.getArrayId(), new Integer(0));
            this.fnodes.put(nodeToAdd.getArrayId(), new ArrayList());
            this.fSort.put(nodeToAdd.getArrayId(), new Boolean(false));
            if (nodeToAdd.getBackComparator() != null) {
                this.bnodes.put(nodeToAdd.getArrayId(), new ArrayList());
                this.bSort.put(nodeToAdd.getArrayId(), new Boolean(false));
            }
        }
        List fNodeList = (List)this.fnodes.get(nodeToAdd.getArrayId());
        List bNodeList = (List)this.bnodes.get(nodeToAdd.getArrayId());
        if (fNodeList != null && fNodeList.size() > 0) {
            GraphNode node = (GraphNode)fNodeList.get(fNodeList.size() - 1);
            Comparator fcomp = nodeToAdd.getComparator();
            Comparator bcomp = nodeToAdd.getBackComparator();
            if (fcomp != null && fcomp.compare(node, nodeToAdd) == 1) {
                this.fSort.put(nodeToAdd.getArrayId(), new Boolean(true));
            }
            if (bcomp != null && bcomp.compare(node, nodeToAdd) == 1) {
                this.bSort.put(nodeToAdd.getArrayId(), new Boolean(true));
            }
        }
        fNodeList.add(nodeToAdd);
        this.nodes.put(nodeToAdd.getArrayId(), fNodeList);
        this.fnodes.put(nodeToAdd.getArrayId(), fNodeList);
        if (nodeToAdd.getBackComparator() != null) {
            bNodeList.add(nodeToAdd);
            this.bnodes.put(nodeToAdd.getArrayId(), bNodeList);
        }
    }

    public void updateIndex(int x, int y, int width, int height) {
        this.visibleAreaX = x;
        this.visibleAreaY = y;
        this.visibleAreaWidth = width;
        this.visibleAreaHeight = height;
        if (SDViewerPlugin.debugIndex()) {
            System.out.print("*****************************\n");
            System.out.print("Visible area position in virtual screen (x,y)= " + x + " " + y + "\n\n");
        }
        Iterator it = this.nodes.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            int direction = 1;
            int drawIndex = (Integer)this.indexes.get(nodeType);
            if (this.nodes.get(nodeType) != null && ((List)this.nodes.get(nodeType)).size() > 1) {
                if (((GraphNode)((List)this.nodes.get(nodeType)).get(drawIndex)).positiveDistanceToPoint(x, y)) {
                    direction = -1;
                }
                if (drawIndex == 0) {
                    direction = 1;
                }
                if (direction == -1 && this.bnodes.get(nodeType) != null) {
                    GraphNode currentNode = (GraphNode)((List)this.nodes.get(nodeType)).get(drawIndex);
                    drawIndex = Arrays.binarySearch(((List)this.bnodes.get(nodeType)).toArray(), ((List)this.nodes.get(nodeType)).get(drawIndex), currentNode.getBackComparator());
                    this.nodes.put(nodeType, this.bnodes.get(nodeType));
                    if (drawIndex < 0) {
                        drawIndex = 0;
                        direction = 1;
                    } else {
                        this.nodes.put(nodeType, this.bnodes.get(nodeType));
                    }
                }
                GraphNode prev = null;
                int i = drawIndex;
                while (i < ((List)this.nodes.get(nodeType)).size() && i >= 0) {
                    drawIndex = i;
                    this.indexes.put(nodeType, new Integer(i));
                    GraphNode currentNode = (GraphNode)((List)this.nodes.get(nodeType)).get(i);
                    if (prev == null) {
                        prev = currentNode;
                    }
                    Comparator comp = currentNode.getComparator();
                    HashMap sort = this.fSort;
                    if (direction == -1 && currentNode.getBackComparator() != null) {
                        comp = currentNode.getBackComparator();
                        sort = this.bSort;
                    }
                    if (i < ((List)this.nodes.get(nodeType)).size() - 1) {
                        GraphNode next = (GraphNode)((List)this.nodes.get(nodeType)).get(i + 1);
                        if (comp != null && comp.compare(currentNode, next) == 1) {
                            sort.put(nodeType, new Boolean(true));
                        }
                    }
                    if (direction == 1) {
                        if (((GraphNode)((List)this.nodes.get(nodeType)).get(i)).positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.getBackComparator() == null) {
                        if (currentNode.isVisible(x, y, width, height) && !currentNode.positiveDistanceToPoint(x, y)) {
                            break;
                        }
                    } else if (currentNode.isVisible(x, y, width, height) && !currentNode.positiveDistanceToPoint(x, y)) {
                        if (comp != null && comp.compare(currentNode, prev) <= 0) {
                            break;
                        }
                    } else if (comp != null && comp.compare(currentNode, prev) <= 0) {
                        prev = currentNode;
                    }
                    i += direction;
                }
                this.nodes.put(nodeType, this.fnodes.get(nodeType));
                if (this.bnodes.get(nodeType) != null && direction == -1) {
                    int index = (Integer)this.indexes.get(nodeType);
                    List list = (List)this.nodes.get(nodeType);
                    List backList = (List)this.bnodes.get(nodeType);
                    GraphNode currentNode = (GraphNode)backList.get(index);
                    if (index > 0) {
                        index = Arrays.binarySearch(list.toArray(), backList.get(index), currentNode.getComparator());
                        if (index < 0) {
                            index = 0;
                        }
                        this.indexes.put(nodeType, new Integer(index));
                    }
                }
                int i2 = drawIndex;
                while (i2 < ((List)this.nodes.get(nodeType)).size() && i2 >= 0) {
                    GraphNode toDraw = (GraphNode)((List)this.nodes.get(nodeType)).get(i2);
                    toDraw.updateInternalIndex(x, y, width, height);
                    if (!toDraw.isVisible(x, y, width, height)) break;
                    ++i2;
                }
            }
            if (!SDViewerPlugin.debugIndex()) continue;
            System.out.print("First drawn " + nodeType + " index = " + drawIndex + "\n");
            System.out.print(nodeType + " found in " + 0 + " iterations\n");
        }
        if (SDViewerPlugin.debugIndex()) {
            System.out.print("*****************************\n");
        }
    }

    public int getX() {
        return 10;
    }

    public int getY() {
        return 10;
    }

    public int getWidth() {
        if (this.horizontalIndex == 0) {
            return Metrics.swimmingLaneWidth() + 46 - 10 - 22;
        }
        return this.horizontalIndex * Metrics.swimmingLaneWidth() + 46 - 45;
    }

    public int getHeight() {
        if (this.forceEventOccurrenceSpacing >= 0) {
            Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing;
        }
        return this.verticalIndex * (Metrics.getMessagesSpacing() + Metrics.getMessageFontHeigth()) + 14 + 4 + Metrics.getFrameFontHeigth() + 30 + 20 + 14 + 4 + Metrics.getLifelineFontHeigth() * 2;
    }

    protected GraphNode getNodeFromListAt(int x, int y, List list, int fromIndex) {
        if (list == null) {
            return null;
        }
        int i = fromIndex;
        while (i < list.size()) {
            GraphNode node = (GraphNode)list.get(i);
            if (node instanceof Lifeline && node.getX() > this.visibleAreaX + this.visibleAreaWidth || (node.getHeight() >= 0 ? node.getY() > this.visibleAreaY + this.visibleAreaHeight : node.getY() + node.getHeight() > this.visibleAreaY + this.visibleAreaHeight)) break;
            if (node.contains(x, y)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public GraphNode getNodeAt(int x, int y) {
        Iterator it = this.nodes.keySet().iterator();
        GraphNode node = null;
        while (it.hasNext()) {
            int index;
            Object nodeType = it.next();
            List list = (List)this.nodes.get(nodeType);
            node = this.getNodeFromListAt(x, y, list, index = ((Integer)this.indexes.get(nodeType)).intValue());
            if (node == null) continue;
            GraphNode internalNode = node.getInternalNodeAt(x, y, this.visibleAreaX, this.visibleAreaY, this.visibleAreaWidth, this.visibleAreaHeight);
            if (internalNode != null) {
                return internalNode;
            }
            return node;
        }
        return null;
    }

    protected void drawFrame(IGC context) {
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        context.fillRectangle(x, y, w, h);
        context.drawRectangle(x, y, w, h);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME_NAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME_NAME"));
        context.setFont(Frame.getUserPref().getFont("PREF_FRAME_NAME"));
        int nameWidth = context.textExtent(this.getName()) + 16;
        int nameHeight = Metrics.getFrameFontHeigth() + 8;
        if (nameWidth > w) {
            nameWidth = w;
        }
        int[] points = new int[]{x, y, x + nameWidth, y, x + nameWidth, y - 11 + nameHeight, x - 11 + nameWidth, y + nameHeight, x, y + nameHeight, x, y + nameHeight};
        context.fillPolygon(points);
        context.drawPolygon(points);
        context.drawLine(x, y, x, y + nameHeight);
        context.setForeground(Frame.getUserPref().getFontColor("PREF_FRAME_NAME"));
        context.drawTextTruncatedCentred(this.getName(), x, y, nameWidth - 11, nameHeight, false);
        context.setBackground(Frame.getUserPref().getBackGroundColor("PREF_FRAME"));
        context.setForeground(Frame.getUserPref().getForeGroundColor("PREF_FRAME"));
    }

    public void draw(IGC context) {
        this.draw(context, true);
    }

    protected void draw(IGC context, boolean drawFrame) {
        this.visibleAreaHeight = context.getVisibleHeight();
        this.visibleAreaWidth = context.getVisibleWidth();
        this.visibleAreaX = context.getContentsX();
        this.visibleAreaY = context.getContentsY();
        Metrics.forcedEventSpacing = this.forceEventOccurrenceSpacing >= 0 ? this.forceEventOccurrenceSpacing : -1;
        if (userPref == null) {
            return;
        }
        Iterator it = this.fSort.keySet().iterator();
        while (it.hasNext()) {
            Object nodeType = it.next();
            boolean sort = (Boolean)this.fSort.get(nodeType);
            if (!sort) continue;
            Object[] temp = ((List)this.fnodes.get(nodeType)).toArray();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            Arrays.sort(temp, node.getComparator());
            this.fSort.put(nodeType, new Boolean(false));
            this.nodes.put(nodeType, Arrays.asList(temp));
            this.fnodes.put(nodeType, Arrays.asList(temp));
            if (!SDViewerPlugin.debugSorting()) continue;
            System.out.print(nodeType + " array sorted\n");
        }
        Iterator it2 = this.bSort.keySet().iterator();
        while (it2.hasNext()) {
            Object nodeType = it2.next();
            boolean sort = (Boolean)this.bSort.get(nodeType);
            if (!sort) continue;
            Object[] temp = ((List)this.bnodes.get(nodeType)).toArray();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            Arrays.sort(temp, node.getBackComparator());
            this.bSort.put(nodeType, new Boolean(false));
            this.bnodes.put(nodeType, Arrays.asList(temp));
            if (!SDViewerPlugin.debugSorting()) continue;
            System.out.print(nodeType + " back array sorted\n");
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print("*****************************\n");
        }
        if (drawFrame) {
            this.drawFrame(context);
        }
        int arrayStep = 1;
        if ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom() < 1.0f) {
            arrayStep = Math.round(1.0f / ((float)(Metrics.getMessageFontHeigth() + 20) * context.getZoom()));
        }
        int count = 0;
        Iterator it3 = this.fSort.keySet().iterator();
        while (it3.hasNext()) {
            count = 0;
            Object nodeType = it3.next();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            context.setFont(Frame.getUserPref().getFont(node.prefId));
            int index = (Integer)this.indexes.get(nodeType);
            count = this.drawNodes(context, (List)this.nodes.get(nodeType), index, arrayStep);
            if (!SDViewerPlugin.debugDisplay()) continue;
            System.out.print(count + " " + nodeType + " drawn, starting from index " + index + "\r\n");
        }
        if (SDViewerPlugin.debugDisplay()) {
            System.out.print("*****************************\n");
        }
    }

    private int drawNodes(IGC context, List list, int startIndex, int step) {
        GraphNode last = null;
        int nodesCount = 0;
        if (list.size() < 0) {
            return 0;
        }
        GraphNode node = (GraphNode)list.get(0);
        context.setFont(Frame.getUserPref().getFont(node.prefId));
        Comparator comparator = node.getComparator();
        int i = startIndex;
        while (i < list.size()) {
            int ch;
            int cw;
            int cy;
            int cx;
            GraphNode toDraw = (GraphNode)list.get(i);
            if (i < list.size() - 1) {
                GraphNode next = (GraphNode)list.get(i + 1);
                if (comparator != null && comparator.compare(toDraw, next) == 1) {
                    this.fSort.put(next.getArrayId(), new Boolean(true));
                }
            }
            if (!toDraw.isVisible(cx = context.getContentsX(), cy = context.getContentsY(), cw = context.getVisibleWidth(), ch = context.getVisibleHeight()) && toDraw.positiveDistanceToPoint(cx + cw, cy + ch)) break;
            if ((!toDraw.isSameAs(last) || toDraw.isSelected()) && toDraw.isVisible(context.getContentsX(), context.getContentsY(), context.getVisibleWidth(), context.getVisibleHeight())) {
                ++nodesCount;
                toDraw.draw(context);
            }
            last = toDraw;
            i += step;
        }
        return nodesCount;
    }

    public static boolean contains(int x, int y, int width, int height, int px, int py) {
        int locX = x;
        int locY = y;
        int locWidth = width;
        int locHeight = height;
        if (width < 0) {
            locX += width;
            locWidth = -locWidth;
        }
        if (height < 0) {
            locY += height;
            locHeight = -locHeight;
        }
        return px >= locX && py >= locY && px - locX < locWidth && py - locY < locHeight;
    }

    public static void setUserPref(ISDPreferences pref) {
        userPref = pref;
    }

    public static ISDPreferences getUserPref() {
        return userPref;
    }

    public void setTimeUnitName(String name) {
        this.unitName = name;
    }

    public String getTimeUnitName() {
        return this.unitName;
    }

    public void forceEventOccurrenceSpacing(int space) {
        this.forceEventOccurrenceSpacing = space;
    }

    public int getVisibleAreaX() {
        return this.visibleAreaX;
    }

    public int getVisibleAreaY() {
        return this.visibleAreaY;
    }

    public double getMinTime() {
        if (this.lastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.computeMinMax = true;
        }
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.minTime;
    }

    public double getMaxTime() {
        if (this.lastExternalTimePref != SDViewPref.getInstance().excludeExternalTime()) {
            this.lastExternalTimePref = SDViewPref.getInstance().excludeExternalTime();
            this.computeMinMax = true;
        }
        if (this.computeMinMax) {
            this.computeMinMax();
            this.computeMinMax = false;
        }
        return this.maxTime;
    }

    protected void computeMinMax() {
        List timeArray = this.buildTimeArray();
        int i = 0;
        while (i < timeArray.size() - 1) {
            TimeEvent m1 = (TimeEvent)timeArray.get(i);
            TimeEvent m2 = (TimeEvent)timeArray.get(i + 1);
            if (this.computeMinMax) {
                this.maxTime = this.minTime = m2.getTime() - m1.getTime();
                this.computeMinMax = false;
            }
            if (m2.getTime() - m1.getTime() < this.minTime) {
                this.minTime = m2.getTime() - m1.getTime();
            }
            if (m2.getTime() - m1.getTime() > this.maxTime) {
                this.maxTime = m2.getTime() - m1.getTime();
            }
            ++i;
        }
    }

    protected List buildTimeArray() {
        Iterator it = this.fSort.keySet().iterator();
        ArrayList<TimeEvent> timeArray = new ArrayList<TimeEvent>();
        while (it.hasNext()) {
            Object nodeType = it.next();
            GraphNode node = (GraphNode)((List)this.nodes.get(nodeType)).get(0);
            List list = (List)this.nodes.get(nodeType);
            int i = 0;
            while (i < list.size()) {
                Object timedNode = list.get(i);
                if (timedNode instanceof ITimeRange && ((ITimeRange)timedNode).hasTimeInfo()) {
                    int event = ((GraphNode)list.get(i)).getStartOccurrence();
                    double time = ((ITimeRange)list.get(i)).getFirstTime();
                    TimeEvent f = new TimeEvent(time, event, (ITimeRange)list.get(i));
                    timeArray.add(f);
                    if (event != ((GraphNode)list.get(i)).getEndOccurrence()) {
                        event = ((AsyncMessage)list.get(i)).getEndOccurrence();
                        time = ((ITimeRange)list.get(i)).getLastTime();
                        f = new TimeEvent(time, event, (ITimeRange)list.get(i));
                        timeArray.add(f);
                    }
                }
                ++i;
            }
        }
        return timeArray;
    }
}

