/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.resources.database.internal.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.eclipse.emf.ecore.EObject;

public class WeakObjectCache {
    protected static final int INITIAL_CAPACITY = 11;
    protected static final float LOAD_FACTOR = 0.75f;
    protected transient Entry[] objectToIdTable;
    protected transient Entry[] idToObjectTable;
    protected transient int threshold = 8;
    protected transient int count;
    protected ReferenceQueue queue = new ReferenceQueue();

    public Integer getId(EObject object) {
        if (this.idToObjectTable == null) {
            return null;
        }
        Entry entry = this.find(null, object, null);
        return entry == null ? null : entry.value;
    }

    public EObject getObject(Integer id) {
        if (this.objectToIdTable == null) {
            return null;
        }
        Entry entry = this.find(id, null, null);
        return entry == null ? null : (EObject)entry.key.get();
    }

    public boolean add(EObject object, Integer id) {
        if (this.idToObjectTable == null) {
            this.idToObjectTable = new Entry[11];
            this.objectToIdTable = new Entry[11];
        }
        if (object == null || id == null) {
            return false;
        }
        return this.put(object, id);
    }

    protected Entry find(Integer id, EObject object, WeakEObject weakObject) {
        try {
            int hash = id != null ? id.hashCode() : (object != null ? object.hashCode() : weakObject.hash);
            int index = (hash & Integer.MAX_VALUE) % this.idToObjectTable.length;
            Entry entry = id != null ? this.idToObjectTable[index] : this.objectToIdTable[index];
            while (entry != null) {
                if (this.equals(entry, id, object, weakObject)) {
                    return entry;
                }
                entry = id != null ? entry.nextIdToObject : entry.nextObjectToId;
            }
        }
        catch (NullPointerException e) {}
        return null;
    }

    protected boolean equals(Entry entry, Integer id, EObject object, WeakEObject weakObject) {
        if (id != null && entry.value.equals(id)) {
            return true;
        }
        if (object != null && entry.key.get() == object) {
            return true;
        }
        return weakObject != null && entry.key == weakObject;
    }

    protected boolean put(EObject object, Integer id) {
        Entry entry;
        if (this.find(null, object, null) != null) {
            return false;
        }
        int hash1 = object.hashCode();
        int hash2 = id.hashCode();
        int index1 = (hash1 & Integer.MAX_VALUE) % this.objectToIdTable.length;
        int index2 = (hash2 & Integer.MAX_VALUE) % this.idToObjectTable.length;
        if (this.count >= this.threshold) {
            this.rehash();
            index1 = (hash1 & Integer.MAX_VALUE) % this.objectToIdTable.length;
            index2 = (hash2 & Integer.MAX_VALUE) % this.idToObjectTable.length;
        }
        WeakEObject weakObject = new WeakEObject(object, this.queue);
        this.idToObjectTable[index2] = entry = new Entry(weakObject, id, this.idToObjectTable[index2], this.objectToIdTable[index1]);
        this.objectToIdTable[index1] = entry;
        ++this.count;
        return true;
    }

    public boolean remove(EObject object) {
        if (this.idToObjectTable == null) {
            return false;
        }
        Entry entry = this.find(null, object, null);
        if (entry == null) {
            return false;
        }
        this.remove(entry, this.idToObjectTable);
        this.remove(entry, this.objectToIdTable);
        --this.count;
        return true;
    }

    protected void remove(Entry entry, Entry[] table) {
        int hash = table == this.idToObjectTable ? entry.value.hashCode() : entry.key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % table.length;
        Entry current = table[index];
        Entry previous = null;
        while (current != null) {
            if (current == entry) {
                if (previous != null) {
                    if (table == this.idToObjectTable) {
                        previous.nextIdToObject = current.nextIdToObject;
                    } else {
                        previous.nextObjectToId = current.nextObjectToId;
                    }
                } else {
                    table[index] = table == this.idToObjectTable ? current.nextIdToObject : current.nextObjectToId;
                }
                return;
            }
            previous = current;
            current = table == this.idToObjectTable ? current.nextIdToObject : current.nextObjectToId;
        }
    }

    protected void rehash() {
        this.rehash(this.idToObjectTable);
        this.rehash(this.objectToIdTable);
    }

    protected void rehash(Entry[] table) {
        int newCapacity = table.length * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        int i = 0;
        while (i < table.length) {
            Entry entry = table[i];
            while (entry != null) {
                int hash;
                Entry next;
                if (table == this.idToObjectTable) {
                    next = entry.nextIdToObject;
                    hash = entry.value.hashCode();
                } else {
                    next = entry.nextObjectToId;
                    hash = entry.key.hashCode();
                }
                int index = (hash & Integer.MAX_VALUE) % newCapacity;
                if (table == this.idToObjectTable) {
                    entry.nextIdToObject = newTable[index];
                } else {
                    entry.nextObjectToId = newTable[index];
                }
                newTable[index] = entry;
                entry = next;
            }
            ++i;
        }
        if (table == this.idToObjectTable) {
            this.idToObjectTable = newTable;
        } else {
            this.objectToIdTable = newTable;
        }
    }

    public void refresh() {
        WeakEObject weakObject = (WeakEObject)this.queue.poll();
        while (weakObject != null) {
            Entry entry = this.find(null, null, weakObject);
            if (entry != null) {
                this.remove(entry, this.idToObjectTable);
                this.remove(entry, this.objectToIdTable);
                --this.count;
            }
            weakObject = (WeakEObject)this.queue.poll();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("objectToIdTable:\n");
        this.printTable(buffer, this.objectToIdTable);
        buffer.append("idToObjectTable:\n");
        this.printTable(buffer, this.idToObjectTable);
        return buffer.toString();
    }

    public int getObjectCount() {
        return this.count;
    }

    protected void printTable(StringBuffer buffer, Entry[] table) {
        if (table == null) {
            return;
        }
        int i = 0;
        while (i < table.length) {
            Entry entry = table[i];
            if (entry != null) {
                buffer.append("  " + i + ": [");
                buffer.append(entry.toString());
                entry = table == this.objectToIdTable ? entry.nextObjectToId : entry.nextIdToObject;
                while (entry != null) {
                    buffer.append(", ");
                    buffer.append(entry.toString());
                    entry = table == this.objectToIdTable ? entry.nextObjectToId : entry.nextIdToObject;
                }
                buffer.append("]\n");
            }
            ++i;
        }
    }

    protected class WeakEObject
    extends WeakReference {
        int hash;

        protected WeakEObject(EObject object, ReferenceQueue queue) {
            super(object, queue);
            this.hash = object.hashCode();
        }

        public boolean equals(Object weakObject) {
            if (this == weakObject) {
                return true;
            }
            if (!(weakObject instanceof WeakEObject)) {
                return false;
            }
            Object thisEObject = this.get();
            Object otherEObject = ((WeakEObject)weakObject).get();
            if (thisEObject == null || otherEObject == null) {
                return false;
            }
            return thisEObject == otherEObject;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            if (this.get() == null) {
                return "null";
            }
            return this.get().toString();
        }
    }

    protected static class Entry {
        WeakEObject key;
        Integer value;
        Entry nextIdToObject;
        Entry nextObjectToId;

        protected Entry(WeakEObject key, Integer value, Entry nextIdToObject, Entry nextObjectToId) {
            this.key = key;
            this.value = value;
            this.nextIdToObject = nextIdToObject;
            this.nextObjectToId = nextObjectToId;
        }

        public String toString() {
            return "<" + this.key.toString() + ", " + this.value + ">";
        }
    }
}

