/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import org.eclipse.hyades.execution.trace.util.RecordArray;
import org.eclipse.hyades.execution.trace.util.Utilities;
import org.eclipse.hyades.logging.core.XmlUtility;

public class RecordVariable {
    public static final String PARAMETER = "parameter";
    public static final String RETURN_VALUE = "returnValue";
    public static final String ARRAY_ELEMENT = "arrayElement";
    private final String _event;
    private final int _id;
    private final Class _clazz;
    private final Object _value;

    public RecordVariable(String event, int index, Class clazz, Object value) {
        this._event = event;
        this._id = index;
        this._clazz = clazz;
        this._value = value;
    }

    public String toString() {
        if (this._value == null) {
            return null;
        }
        String valueString = null;
        if (this._clazz.isArray()) {
            valueString = new RecordArray(ARRAY_ELEMENT, this._clazz.getComponentType(), (Object[])this._value).toString();
        } else {
            String stringified = Utilities.stringifyPrimitivesStrings(this._clazz, this._value);
            if (stringified != null) {
                valueString = XmlUtility.normalize((String)stringified);
            }
        }
        if (valueString == null) {
            try {
                ByteArrayOutputStream byteObjectStream = new ByteArrayOutputStream();
                ObjectOutputStream extrnObjectStream = new ObjectOutputStream(byteObjectStream);
                extrnObjectStream.writeObject(this._value);
                extrnObjectStream.close();
                byte[] byteObject = byteObjectStream.toByteArray();
                StringBuffer valueBuffer = new StringBuffer(byteObject.length << 1);
                int i = 0;
                while (i < byteObject.length) {
                    String hexByte = Integer.toHexString(byteObject[i] & 0xFF);
                    valueBuffer.append(hexByte.length() < 2 ? "0" + hexByte : hexByte);
                    ++i;
                }
                valueString = valueBuffer.toString();
            }
            catch (NotSerializableException e) {
                valueString = XmlUtility.normalize((String)this._value.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return "<" + this._event + (this._event == ARRAY_ELEMENT ? " index=\"" + this._id + "\"" : "") + (this._event == PARAMETER ? " parameterIdRef=\"" + this._id + "\"" : "") + (!this._clazz.isArray() ? " value=\"" + valueString + "\"/>" : ">\n" + valueString + "</" + this._event + ">");
    }
}

