/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.correlation;

import java.util.Comparator;
import org.eclipse.hyades.collection.correlation.BaseApplicationImpl;
import org.eclipse.hyades.collection.correlation.CorrelatorAssociation;
import org.eclipse.hyades.collection.correlation.IApplication;
import org.eclipse.hyades.collection.correlation.ICorrelatorData;
import org.eclipse.hyades.collection.correlation.ITransport;
import org.eclipse.hyades.collection.correlation.ServiceRegistry;
import org.eclipse.hyades.collection.correlation.exceptions.InsufficientBufferLengthException;
import org.eclipse.hyades.collection.correlation.exceptions.InvalidDataException;
import org.eclipse.hyades.collection.correlation.exceptions.MoreDataRequiredException;

public class TransportMediator {
    public static byte[] writeMessage(ICorrelatorData correlator, int applicationId) {
        byte[] buffer = new byte[1024];
        int offset = 0;
        try {
            offset = correlator.writeBinary(buffer, 7, buffer.length);
        }
        catch (InsufficientBufferLengthException e) {
            byte[] newBuffer = new byte[e.getRequiredLength()];
            buffer = newBuffer;
            try {
                offset = correlator.writeBinary(buffer, 7, buffer.length);
            }
            catch (InsufficientBufferLengthException ePrime) {
                // empty catch block
            }
        }
        buffer[0] = (byte)(offset >> 8);
        buffer[1] = (byte)offset;
        buffer[2] = 0;
        buffer[3] = 0;
        buffer[4] = 0;
        buffer[5] = (byte)(applicationId >> 8);
        buffer[6] = (byte)applicationId;
        byte[] newArray = new byte[buffer.length];
        System.arraycopy(buffer, 0, newArray, 0, buffer.length);
        return newArray;
    }

    public static void getDataStream(int applicationId, Comparator key, ITransport transport, ICorrelatorData local) {
        IApplication application = ServiceRegistry.getRegistry().getApplicationById(applicationId);
        CorrelatorAssociation association = ((BaseApplicationImpl)application).handleCall(key, local);
        byte[] buffer = TransportMediator.writeMessage(association.getParent(), applicationId);
        ((BaseApplicationImpl)application).releaseAssociation(association);
        transport.sendRequest(buffer, 0, buffer.length);
    }

    public static void getDataStream(int applicationId, Comparator key, ITransport transport) {
        TransportMediator.getDataStream(applicationId, key, transport, null);
    }

    public static int setRemoteDataStream(Comparator key, byte[] buffer, int offset, int length, ICorrelatorData local) throws MoreDataRequiredException, InvalidDataException {
        int applicationId = (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 6] & 0xFF;
        BaseApplicationImpl application = (BaseApplicationImpl)ServiceRegistry.getRegistry().getApplicationById(applicationId);
        if (application == null) {
            throw new InvalidDataException();
        }
        try {
            ICorrelatorData remote = application.createCorrelatorData();
            offset = remote.readBinary(buffer, offset + 7, length);
            CorrelatorAssociation association = application.pushParent(key, remote, local);
            application.releaseAssociation(association);
            return offset;
        }
        catch (InsufficientBufferLengthException e) {
            throw new MoreDataRequiredException();
        }
    }

    public static int setRemoteDataStream(Comparator key, byte[] buffer, int offset, int length) throws MoreDataRequiredException, InvalidDataException {
        return TransportMediator.setRemoteDataStream(key, buffer, offset, length, null);
    }

    public static void getRemoteDataStream(int applicationId, Comparator key, ITransport transport, ICorrelatorData local) {
        IApplication application = ServiceRegistry.getRegistry().getApplicationById(applicationId);
        CorrelatorAssociation association = application.popParent(key, local);
        byte[] buffer = TransportMediator.writeMessage(association.getParent(), applicationId);
        ((BaseApplicationImpl)application).returnCorrelatorData(association.getParent());
        ((BaseApplicationImpl)application).releaseAssociation(association);
        transport.sendReply(buffer, 0, buffer.length);
    }

    public static void getRemoteDataStream(int applicationId, Comparator key, ITransport transport) {
        TransportMediator.getRemoteDataStream(applicationId, key, transport, null);
    }

    public static int setDataStream(Comparator key, byte[] buffer, int offset, int length, ICorrelatorData local) throws MoreDataRequiredException, InvalidDataException {
        int applicationId = (buffer[offset + 5] & 0xFF) << 8 | buffer[offset + 6] & 0xFF;
        BaseApplicationImpl application = (BaseApplicationImpl)ServiceRegistry.getRegistry().getApplicationById(applicationId);
        if (application == null) {
            throw new InvalidDataException();
        }
        try {
            ICorrelatorData remote = application.createCorrelatorData();
            offset = remote.readBinary(buffer, offset + 7, length);
            CorrelatorAssociation association = application.handleReturn(key, remote, local);
            application.returnCorrelatorData(remote);
            application.releaseAssociation(association);
            return offset;
        }
        catch (InsufficientBufferLengthException e) {
            throw new MoreDataRequiredException();
        }
    }

    public static int setDataStream(Comparator key, byte[] buffer, int offset, int length) throws MoreDataRequiredException, InvalidDataException {
        return TransportMediator.setDataStream(key, buffer, offset, length, null);
    }
}

