/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCMethodImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticPage;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class MemoryStatisticView
extends MultiLevelStatisticView {
    private static int _level = 1;
    public static final int INSTANCE_LEVEL = 3;
    private final TRCPackageImpl.TRCPackageSnapshot pdelta1 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCPackageImpl.TRCPackageSnapshot pdelta2 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta1 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta2 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta1 = new TRCMethodImpl.TRCMethodSnapshot();
    private final TRCMethodImpl.TRCMethodSnapshot mdelta2 = new TRCMethodImpl.TRCMethodSnapshot();

    public MemoryStatisticView(Composite parent, TraceViewerPage page) {
        super(parent, page);
    }

    protected int getClassPosForLevel(int pos) {
        if (this.getLevel() == 1) {
            switch (pos) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
                case 5: {
                    return 6;
                }
                case 6: {
                    return 7;
                }
            }
        } else if (this.getLevel() == 3) {
            switch (pos) {
                case 3: {
                    return 5;
                }
                case 4: {
                    return 6;
                }
                case 5: {
                    return 7;
                }
                case 6: {
                    return -1;
                }
                case 7: {
                    return -1;
                }
            }
        }
        return pos;
    }

    public String getDefaultColumnsTemplate() {
        String columns = super.getDefaultColumnsTemplate();
        if (columns == null) {
            columns = this.getLevel() == 3 ? this.getDefaultColumnsTemplateInstanceLevel() : "";
        }
        return columns;
    }

    protected String getDefaultColumnsTemplatePackageLevel() {
        return TraceUIPlugin.getString("STR_ST_PACKAGE") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":6:" + String.valueOf(17) + ":right:100";
    }

    protected String getDefaultColumnsTemplateClassLevel() {
        return TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":2:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":7:" + String.valueOf(17) + ":right:100";
    }

    protected String getDefaultColumnsTemplateInstanceLevel() {
        return TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("") + ":1:" + String.valueOf(47) + ":14," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":2:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":3:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":4:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":5:" + String.valueOf(1) + ":right:100";
    }

    public boolean isEmptyUpdate() {
        return PerftraceUtil.getTotalSize(this._page.getMOFObject()) <= 0L;
    }

    public IContentProvider getContentProvider() {
        return new MemoryStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new MemoryStatisticLabelProvider((StatisticView)this);
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new MemoryStatisticSorter();
    }

    protected StatisticView.StatisticFilter getFilterInstance() {
        return new MemoryStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        this.setLevel(this.getLevel());
        if (this.getLevel() == 1) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "MemStatsPack60";
        }
        if (this.getLevel() == 2) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "MemStatsClass60";
        }
        if (this.getLevel() == 2) {
            return MultiLevelStatisticView.PREFERENCE_KEY_PREFIX + "MemStatsInstance60";
        }
        return "";
    }

    protected String getViewTypeStr() {
        return "viewoption.memory";
    }

    public void setLevel(int i) {
        _level = i;
    }

    public int getLevel() {
        return _level;
    }

    public void updateButtons() {
        super.updateButtons();
        ((MemoryStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
        if (this.getLevel() == 3) {
            ((MemoryStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(false);
        } else {
            ((MemoryStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        }
    }

    protected void showPercentUpdate() {
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            if (this._totalCalls == 0) {
                this._totalCalls = 1;
            }
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            if (this._totalInst == 0) {
                this._totalInst = 1;
            }
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            if (this._activeInst == 0) {
                this._activeInst = 1;
            }
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            if (this._totalSize == 0L) {
                this._totalSize = 1L;
            }
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            if (this._activeSize == 0L) {
                this._activeSize = 1L;
            }
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
            if (this._maxTime == 0.0) {
                this._maxTime = 1.0;
            }
        }
    }

    protected void searchInLevel(TableTree table, TableTreeItem item, TRCPackage pack, TRCClass cls, TRCMethod meth, TRCObject trcObj) {
        super.searchInLevel(table, item, pack, cls, meth, trcObj);
        switch (this.getLevel()) {
            case 3: {
                if (cls == null) break;
                this.searchInClassLevel(table, item, cls, null, trcObj);
            }
        }
    }

    public class MemoryStatisticFilter
    extends StatisticView.StatisticFilter {
        public MemoryStatisticFilter() {
            super(MemoryStatisticView.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            String compareText = "";
            switch (MemoryStatisticView.this.getLevel()) {
                case 1: {
                    if (!(element instanceof TRCPackage)) {
                        return true;
                    }
                    if (((TRCPackage)element).getName().equals("")) {
                        compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
                        break;
                    }
                    compareText = ((TRCPackage)element).getName();
                    break;
                }
                case 2: {
                    if (!(element instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)element).getName();
                    break;
                }
                case 3: {
                    if (!(element instanceof TRCClass)) {
                        return true;
                    }
                    compareText = ((TRCClass)element).getName();
                }
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }

    public class MemoryStatisticSorter
    extends MultiLevelStatisticView.MultiLevelStatisticSorter {
        public MemoryStatisticSorter() {
            super(MemoryStatisticView.this);
        }

        protected int comparePackageLevel(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCPackage && e2 instanceof TRCPackage) {
                TRCPackage p1 = (TRCPackage)e1;
                TRCPackage p2 = (TRCPackage)e2;
                TRCPackageImpl.TRCPackageSnapshot ps1 = (TRCPackageImpl.TRCPackageSnapshot)p1.retrieveSnapshot();
                TRCPackageImpl.TRCPackageSnapshot ps2 = (TRCPackageImpl.TRCPackageSnapshot)p2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * p1.getName().compareToIgnoreCase(p2.getName());
                    }
                    case 1: {
                        if (p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8) < 0 && p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 8) >= 0) {
                            return this._sortSequence;
                        }
                        if (p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8) >= 0 && p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 8) < 0) {
                            return this._sortSequence * -1;
                        }
                        return 0;
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalInstances() - ps2.getTotalInstances());
                        }
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 8);
                        return this._sortSequence * (MemoryStatisticView.this.pdelta1.getTotalInstances() - MemoryStatisticView.this.pdelta2.getTotalInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalInstances() - ps1.getCollectedInstances() - p2.getTotalInstances() + p2.getCollectedInstances());
                        }
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 8);
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 10);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 10);
                        return this._sortSequence * (MemoryStatisticView.this.pdelta1.getTotalInstances() - MemoryStatisticView.this.pdelta1.getCollectedInstances() - MemoryStatisticView.this.pdelta2.getTotalInstances() + MemoryStatisticView.this.pdelta2.getCollectedInstances());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                int inst = ps1.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                double size = (double)ps1.getCollectedInstances() / (double)inst;
                                inst = ps2.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return this._sortSequence * (int)((size -= (double)ps2.getCollectedInstances() / (double)inst) * 10000.0);
                            }
                            return this._sortSequence * (ps1.getCollectedInstances() - ps2.getCollectedInstances());
                        }
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 10);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 10);
                        return this._sortSequence * (MemoryStatisticView.this.pdelta1.getCollectedInstances() - MemoryStatisticView.this.pdelta2.getCollectedInstances());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalSize() - ps2.getTotalSize());
                        }
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 7);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 7);
                        return this._sortSequence * (MemoryStatisticView.this.pdelta1.getTotalSize() - MemoryStatisticView.this.pdelta2.getTotalSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalSize() - ps1.getCollectedSize() - p2.getTotalSize() + p2.getCollectedSize());
                        }
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 7);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 7);
                        p1.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 9);
                        p2.computeDelta((IDelta)MemoryStatisticView.this.pdelta2, 9);
                        return this._sortSequence * (MemoryStatisticView.this.pdelta1.getTotalSize() - MemoryStatisticView.this.pdelta1.getCollectedSize() - MemoryStatisticView.this.pdelta2.getTotalSize() + MemoryStatisticView.this.pdelta2.getCollectedSize());
                    }
                }
            } else {
                return this.compareClassLevel(viewer, e1, e2);
            }
            return 0;
        }

        protected int compareClassLevel(Viewer viewer, Object e1, Object e2) {
            int pos = MemoryStatisticView.this.getClassPosForLevel(this._pos);
            double d = 0.0;
            if (e1 instanceof TRCClass && e2 instanceof TRCClass) {
                TRCClass c1 = (TRCClass)e1;
                TRCClass c2 = (TRCClass)e2;
                TRCClassImpl.TRCClassSnapshot cs1 = (TRCClassImpl.TRCClassSnapshot)c1.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot cs2 = (TRCClassImpl.TRCClassSnapshot)c2.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return this._sortSequence * c1.getName().compareToIgnoreCase(c2.getName());
                    }
                    case 1: {
                        if (c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14) < 0 && c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 14) >= 0) {
                            return this._sortSequence;
                        }
                        if (c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14) >= 0 && c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 14) < 0) {
                            return this._sortSequence * -1;
                        }
                        return 0;
                    }
                    case 2: {
                        return this._sortSequence * c1.getPackage().getName().compareToIgnoreCase(c2.getPackage().getName());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs2.getTotalInstances());
                        }
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 14);
                        return this._sortSequence * (MemoryStatisticView.this.cdelta1.getTotalInstances() - MemoryStatisticView.this.cdelta2.getTotalInstances());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs1.getCollectedInstances() - cs2.getTotalInstances() + cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 14);
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 16);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 16);
                        return this._sortSequence * (MemoryStatisticView.this.cdelta1.getTotalInstances() - MemoryStatisticView.this.cdelta1.getCollectedInstances() - (MemoryStatisticView.this.cdelta2.getTotalInstances() - MemoryStatisticView.this.cdelta2.getCollectedInstances()));
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                int inst = cs1.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                double size = (double)cs1.getCollectedInstances() / (double)inst;
                                inst = cs2.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return this._sortSequence * (int)((size -= (double)cs2.getCollectedInstances() / (double)inst) * 10000.0);
                            }
                            return this._sortSequence * (cs1.getCollectedInstances() - cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 16);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 16);
                        return this._sortSequence * (MemoryStatisticView.this.cdelta1.getCollectedInstances() - MemoryStatisticView.this.cdelta2.getCollectedInstances());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs2.getTotalSize());
                        }
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 13);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 13);
                        return this._sortSequence * (MemoryStatisticView.this.cdelta1.getTotalSize() - MemoryStatisticView.this.cdelta2.getTotalSize());
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs1.getCollectedSize() - cs2.getTotalSize() + cs2.getCollectedSize());
                        }
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 13);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 13);
                        c1.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 15);
                        c2.computeDelta((IDelta)MemoryStatisticView.this.cdelta2, 15);
                        return this._sortSequence * (MemoryStatisticView.this.cdelta1.getTotalSize() - MemoryStatisticView.this.cdelta1.getCollectedSize() - (MemoryStatisticView.this.cdelta2.getTotalSize() - MemoryStatisticView.this.cdelta2.getCollectedSize()));
                    }
                }
            }
            return 0;
        }

        protected int compareInstanceLevel(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCClass) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            TRCObject obj1 = (TRCObject)e1;
            TRCObject obj2 = (TRCObject)e2;
            switch (this._pos) {
                case 0: {
                    return this._sortSequence * (int)(obj1.getId() - obj2.getId());
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 0;
                }
                case 3: {
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                        TRCHeapObject object2 = (TRCHeapObject)e2;
                        TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                        int collected1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? 0 : 1;
                        int collected2 = class2.getCollectedSize() == 0 ? 0 : 1;
                        return this._sortSequence * (collected1 - collected2);
                    }
                    if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                        TRCHeapObject object1 = (TRCHeapObject)e1;
                        TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                        int collected2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? 0 : 1;
                        int collected1 = class1.getCollectedSize() == 0 ? 0 : 1;
                        return this._sortSequence * (collected1 - collected2);
                    }
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                        int collected1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? 0 : 1;
                        int collected2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? 0 : 1;
                        return this._sortSequence * (collected1 - collected2);
                    }
                    return 0;
                }
                case 4: {
                    return this._sortSequence * (obj1.getSize() - obj2.getSize());
                }
                case 5: {
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                        TRCHeapObject object2 = (TRCHeapObject)e2;
                        TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                        int activeSize1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? obj1.getSize() : 0;
                        int activeSize2 = class2.getCollectedSize() == 0 ? class2.getSize() : 0;
                        return this._sortSequence * (activeSize1 - activeSize2);
                    }
                    if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                        TRCHeapObject object1 = (TRCHeapObject)e1;
                        TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                        int activeSize2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? obj1.getSize() : 0;
                        int activeSize1 = class1.getCollectedSize() == 0 ? class1.getSize() : 0;
                        return this._sortSequence * (activeSize1 - activeSize2);
                    }
                    if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                        int activeSize1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? obj1.getSize() : 0;
                        int activeSize2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? obj2.getSize() : 0;
                        return this._sortSequence * (activeSize1 - activeSize2);
                    }
                    return 0;
                }
            }
            return 0;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                return this.comparePackageLevel(viewer, e1, e2);
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return this.compareClassLevel(viewer, e1, e2);
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return this.compareInstanceLevel(viewer, e1, e2);
            }
            return 0;
        }
    }

    public class MemoryStatisticLabelProvider
    extends MultiLevelStatisticView.MultiLevelStatisticLabelProvider {
        public MemoryStatisticLabelProvider(StatisticView viewer) {
            super(MemoryStatisticView.this, viewer);
        }

        protected String getColumnTextPackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCPackage) {
                TRCPackage p = (TRCPackage)obj;
                TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)p.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return PerftraceUtil.getPackageName(p, MemoryStatisticView.this._page.getMOFObject()).toString();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getTotalInstances() / (double)MemoryStatisticView.this._totalInst));
                            }
                            return String.valueOf(ps.getTotalInstances());
                        }
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8);
                        return String.valueOf(MemoryStatisticView.this.pdelta1.getTotalInstances());
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(ps.getTotalInstances() - ps.getCollectedInstances()) / (double)MemoryStatisticView.this._activeInst));
                            }
                            return String.valueOf(ps.getTotalInstances() - ps.getCollectedInstances());
                        }
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8);
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 10);
                        return String.valueOf(MemoryStatisticView.this.pdelta1.getTotalInstances() - MemoryStatisticView.this.pdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                int inst = ps.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return TString.formatAsPercentage((double)((double)ps.getCollectedInstances() / (double)inst));
                            }
                            return String.valueOf(ps.getCollectedInstances());
                        }
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 10);
                        return String.valueOf(MemoryStatisticView.this.pdelta1.getCollectedInstances());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getTotalSize() / (double)MemoryStatisticView.this._totalSize));
                            }
                            return String.valueOf(ps.getTotalSize());
                        }
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 7);
                        return String.valueOf(MemoryStatisticView.this.pdelta1.getTotalSize());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(ps.getTotalSize() - ps.getCollectedSize()) / (double)MemoryStatisticView.this._activeSize));
                            }
                            return String.valueOf(ps.getTotalSize() - ps.getCollectedSize());
                        }
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 7);
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 9);
                        return String.valueOf(MemoryStatisticView.this.pdelta1.getTotalSize() - MemoryStatisticView.this.pdelta1.getCollectedSize());
                    }
                }
            } else {
                return this.getColumnTextClassLevel(obj, col);
            }
            return "";
        }

        protected String getColumnTextClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = MemoryStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)clas.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return ((TRCClass)obj).getName();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return PerftraceUtil.getPackageName(clas.getPackage(), MemoryStatisticView.this._page.getMOFObject()).toString();
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return PerftraceUtil.formatAsPercentage((double)cs.getTotalInstances() / (double)MemoryStatisticView.this._totalInst);
                            }
                            return String.valueOf(cs.getTotalInstances());
                        }
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14);
                        return String.valueOf(MemoryStatisticView.this.cdelta1.getTotalInstances());
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(cs.getTotalInstances() - cs.getCollectedInstances()) / (double)MemoryStatisticView.this._totalInst));
                            }
                            return String.valueOf(cs.getTotalInstances() - cs.getCollectedInstances());
                        }
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14);
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 16);
                        return String.valueOf(MemoryStatisticView.this.cdelta1.getTotalInstances() - MemoryStatisticView.this.cdelta1.getCollectedInstances());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                int size = cs.getTotalInstances();
                                if (size == 0) {
                                    size = 1;
                                }
                                return TString.formatAsPercentage((double)((double)cs.getCollectedInstances() / (double)size));
                            }
                            return String.valueOf(cs.getCollectedInstances());
                        }
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 16);
                        return String.valueOf(MemoryStatisticView.this.cdelta1.getCollectedInstances());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getTotalSize() / (double)MemoryStatisticView.this._totalSize));
                            }
                            return String.valueOf(cs.getTotalSize());
                        }
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 13);
                        return String.valueOf(MemoryStatisticView.this.cdelta1.getTotalSize());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            long size = cs.getTotalSize() - cs.getCollectedSize();
                            if (MemoryStatisticView.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)size / (double)MemoryStatisticView.this._activeSize));
                            }
                            return String.valueOf(size);
                        }
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 13);
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 15);
                        return String.valueOf(MemoryStatisticView.this.cdelta1.getTotalSize() - MemoryStatisticView.this.cdelta1.getCollectedSize());
                    }
                }
            }
            return "";
        }

        protected String getColumnTextInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                return this.getColumnTextClassLevel(obj, col);
            }
            TRCObject object = (TRCObject)obj;
            switch (pos) {
                case 0: {
                    TRCClass clas = PerftraceUtil.getClass(object);
                    if (clas == object.getProcess().getClassClass()) {
                        return clas.getName();
                    }
                    return clas.getName() + "." + object.getId();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    TRCClass clas = PerftraceUtil.getClass(object);
                    return PerftraceUtil.getPackageName(clas.getPackage(), MemoryStatisticView.this._page.getMOFObject()).toString();
                }
                case 3: {
                    if (object instanceof TRCFullTraceObject) {
                        if (((TRCFullTraceObject)object).getCollectTime() == 0.0) {
                            return "0";
                        }
                        return "1";
                    }
                    return "";
                }
                case 4: {
                    if (MemoryStatisticView.this.isShowPercent()) {
                        return TString.formatAsPercentage((double)((double)((TRCObject)obj).getSize() / (double)MemoryStatisticView.this._totalSize));
                    }
                    return String.valueOf(((TRCObject)obj).getSize());
                }
                case 5: {
                    int size = 0;
                    if (object instanceof TRCFullTraceObject) {
                        size = ((TRCFullTraceObject)object).getCollectTime() != 0.0 ? 0 : object.getSize();
                    }
                    if (MemoryStatisticView.this.isShowPercent()) {
                        return TString.formatAsPercentage((double)((double)size / (double)MemoryStatisticView.this._activeSize));
                    }
                    return String.valueOf(size);
                }
            }
            return "";
        }

        public String getColumnText(Object obj, int col) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                return this.getColumnTextPackageLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return this.getColumnTextClassLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return this.getColumnTextInstanceLevel(obj, col);
            }
            return "";
        }

        protected Image getColumnImagePackageLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCPackage) {
                TRCPackage p = (TRCPackage)obj;
                switch (pos) {
                    case 1: {
                        if (p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8) < 0) {
                            return TracePluginImages.getImage("newentry_obj.gif");
                        }
                        return null;
                    }
                    case 2: {
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8);
                        state = MemoryStatisticView.this.pdelta1.getTotalInstances();
                        break;
                    }
                    case 3: {
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 8);
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 10);
                        state = MemoryStatisticView.this.pdelta1.getTotalInstances() - MemoryStatisticView.this.pdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 10);
                        state = MemoryStatisticView.this.pdelta1.getCollectedInstances();
                        break;
                    }
                    case 5: {
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 7);
                        state = MemoryStatisticView.this.pdelta1.getTotalSize();
                        break;
                    }
                    case 6: {
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 7);
                        p.computeDelta((IDelta)MemoryStatisticView.this.pdelta1, 9);
                        state = MemoryStatisticView.this.pdelta1.getTotalSize() - MemoryStatisticView.this.pdelta1.getCollectedSize();
                    }
                }
            } else {
                return this.getColumnImageClassLevel(obj, col);
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        protected Image getColumnImageClassLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = MemoryStatisticView.this.getClassPosForLevel(info.getColumnData().getInitalPos());
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                switch (pos) {
                    case 1: {
                        if (clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14) < 0) {
                            return TracePluginImages.getImage("newentry_obj.gif");
                        }
                        return null;
                    }
                    case 2: {
                        return TracePluginImages.getImage("package_obj_col.gif");
                    }
                    case 3: {
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14);
                        state = MemoryStatisticView.this.cdelta1.getTotalInstances();
                        break;
                    }
                    case 4: {
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 14);
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 16);
                        state = MemoryStatisticView.this.cdelta1.getTotalInstances() - MemoryStatisticView.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 5: {
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 16);
                        state = MemoryStatisticView.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 6: {
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 13);
                        state = MemoryStatisticView.this.cdelta1.getTotalSize();
                        break;
                    }
                    case 7: {
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 13);
                        clas.computeDelta((IDelta)MemoryStatisticView.this.cdelta1, 15);
                        state = MemoryStatisticView.this.cdelta1.getTotalSize() - MemoryStatisticView.this.cdelta1.getCollectedSize();
                    }
                }
            } else {
                return null;
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        protected Image getColumnImageInstanceLevel(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            boolean state = false;
            double d = 0.0;
            if (obj instanceof TRCClass) {
                return this.getColumnImageClassLevel(obj, col);
            }
            switch (pos) {
                case 1: {
                    return null;
                }
                case 2: {
                    return TracePluginImages.getImage("package_obj_col.gif");
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int col) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                return this.getColumnImagePackageLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return this.getColumnImageClassLevel(obj, col);
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return this.getColumnImageInstanceLevel(obj, col);
            }
            return null;
        }
    }

    public class MemoryStatisticContentProvider
    extends MultiLevelStatisticView.MultiLevelStatisticContentProvider {
        public MemoryStatisticContentProvider() {
            super(MemoryStatisticView.this);
        }

        public Object[] getChildren(Object element) {
            MemoryStatisticView.this.tmpList.clear();
            if (element instanceof TRCPackage) {
                return ((TRCPackage)element).getClasses().toArray();
            }
            if (element instanceof TRCClass && MemoryStatisticView.this.getLevel() == 3) {
                TRCClass cls = (TRCClass)element;
                EList list = cls.getObjects();
                Iterator iter = cls.getObjects().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof TRCFullTraceObject)) continue;
                    MemoryStatisticView.this.tmpList.add(obj);
                }
                if (MemoryStatisticView.this.tmpList.isEmpty()) {
                    MemoryStatisticView.this.tmpList.addAll(list);
                }
                return MemoryStatisticView.this.tmpList.toArray();
            }
            return MemoryStatisticView.this.tmpList.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TRCPackage) {
                return true;
            }
            if (element instanceof TRCClass && MemoryStatisticView.this.getLevel() == 3) {
                TRCClass cls = (TRCClass)element;
                return cls.getObjects().size() > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (MemoryStatisticView.this.getLevel() == 1) {
                Object[] packages = PerftraceUtil.getAllPackages(MemoryStatisticView.this._page.getMOFObject());
                ArrayList<TRCPackage> list = new ArrayList<TRCPackage>();
                int idx = 0;
                while (idx < packages.length) {
                    TRCPackage pack = (TRCPackage)packages[idx];
                    if (pack.getClasses().size() > 0) {
                        list.add(pack);
                    }
                    ++idx;
                }
                return list.toArray();
            }
            if (MemoryStatisticView.this.getLevel() == 2) {
                return PerftraceUtil.getAllClasses(MemoryStatisticView.this._page.getMOFObject());
            }
            if (MemoryStatisticView.this.getLevel() == 3) {
                return PerftraceUtil.getAllClasses(MemoryStatisticView.this._page.getMOFObject());
            }
            return new ArrayList().toArray();
        }
    }
}

