/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.loaders.trace.ISnapshot;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.views.adapter.internal.ReferenceTablePage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.IFTRCClass;
import org.eclipse.hyades.trace.views.util.internal.IFTRCObject;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ReferenceTable
extends StatisticView
implements IRefChangedListener {
    protected int _drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public ReferenceTable(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new ClassStatisticFilter();
        TraceUIPlugin.getDefault().addRefChangedEventListener(this);
    }

    public String getColumnsPreferencesKey() {
        return "Ref63";
    }

    public String getDefaultColumnsTemplate() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        String name = TraceUIPlugin.getString("STR_REFEREE");
        if (this.showReferTo()) {
            name = TraceUIPlugin.getString("STR_REFERANDS");
        }
        String executionColumn = name + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:150," + TraceUIPlugin.getString("STR_REF_SIZE") + ":2:" + String.valueOf(1) + ":right:100," + TraceUIPlugin.getString("STR_NB_REF") + ":3:" + String.valueOf(1) + ":left:170," + TraceUIPlugin.getString("STR_OBJ_REF_DETAIL") + ":4:" + String.valueOf(1) + ":left:350";
        return executionColumn;
    }

    protected IContentProvider getContentProvider() {
        return new ObjReferenceContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ObjReferenceLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected TableTreeViewer getTableTreeViewer(TableTree table) {
        return new ReferenceTreeViewer(table);
    }

    protected void handleSelectionEvent() {
        ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(true);
            Object sel = model.getFirstElement();
            if (!(sel instanceof TRCPackage)) {
                ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(true);
            }
            this.select(sel);
            if (sel instanceof TRCObject) {
                sel = ((TRCObject)sel).getIsA();
            } else if (sel instanceof TRCClass) {
                this.select((TRCClass)sel);
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(Object sel) {
        TRCClass cls = null;
        TRCObject obj = null;
        if (sel instanceof TRCClass) {
            cls = (TRCClass)sel;
        } else if (sel instanceof TRCObject) {
            obj = (TRCObject)sel;
            cls = obj.getIsA();
        }
        if (cls == null) {
            return;
        }
        TableTree table = (TableTree)this.getTableViewer().getControl();
        TableTreeItem[] items = table.getItems();
        TRCClass clsItem = null;
        int idx = 0;
        while (idx < items.length) {
            TableTreeItem item = items[idx];
            if (item.getData() instanceof TRCClass) {
                clsItem = (TRCClass)item.getData();
            }
            if (item.getData() instanceof TRCObject) {
                clsItem = ((TRCObject)item.getData()).getIsA();
            }
            if (clsItem != null && clsItem.getId() == cls.getId()) {
                ((ReferenceTreeViewer)this.getTableViewer()).expandItem(item);
                if (obj == null) {
                    table.setSelection(new TableTreeItem[]{item});
                    this.setNewSelection();
                    return;
                }
                TableTreeItem[] childItems = item.getItems();
                int i = 0;
                while (i < childItems.length) {
                    TableTreeItem childItem = childItems[i];
                    if (childItem.getData().equals(obj)) {
                        table.setSelection(new TableTreeItem[]{childItem});
                        this.setNewSelection();
                        return;
                    }
                    ++i;
                }
            }
            ++idx;
        }
    }

    public void updateButtons() {
        ((ReferenceTablePage)this.getTraceViewerPage()).openSource().setEnabled(this.canOpenSourceOnThisObject());
    }

    private boolean canOpenSourceOnThisObject() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() == 0 || model.getFirstElement() == null) {
            return false;
        }
        Object sel = model.getFirstElement();
        return sel instanceof TRCClass;
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            Object object = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object itemData = ((IStructuredSelection)selection).getFirstElement();
            if (itemData instanceof TRCObjectReference) {
                itemData = this.showReferTo() ? ((TRCObjectReference)itemData).getOwner() : ((TRCObjectReference)itemData).getTarget();
            }
            this.notifyViewSelectionChanged(this, itemData);
        }
    }

    protected StatisticView.StatisticSorter getViewerSorterInstance() {
        return new ObjReferenceSorter();
    }

    protected void setLinesVisible(Table table) {
        table.setLinesVisible(false);
    }

    public void update() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        super.update();
    }

    public void dispose() {
        TraceUIPlugin.getDefault().removeRefChangedEventListener(this);
        super.dispose();
    }

    public void handleRefChangedEvent() {
        this._drawmode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        Table table = this.getTable();
        TableColumn firstColumn = table.getColumn(0);
        String text = firstColumn.getText();
        String name = TraceUIPlugin.getString("STR_REFEREE");
        if (this.showReferTo()) {
            name = TraceUIPlugin.getString("STR_REFERANDS");
        }
        if (text.startsWith(">") || text.startsWith("<")) {
            firstColumn.setText(text.substring(0, 1) + name);
        } else {
            firstColumn.setText(name);
        }
        Action referands = ((ReferenceTablePage)this.getTraceViewerPage()).referands();
        Action referee = ((ReferenceTablePage)this.getTraceViewerPage()).referee();
        int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt("obj_ref_display");
        if (referands != null) {
            referands.setChecked(ref == 0);
        }
        if (referee != null) {
            referee.setChecked(ref == 1);
        }
        this.update();
    }

    private boolean showReferTo() {
        return this._drawmode == 0;
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    protected String getViewTypeStr() {
        return "viewoption.reference";
    }

    class MyTRCObjectData
    implements IFTRCObject {
        private TRCObject obj;

        public MyTRCObjectData(TRCObject o) {
            this.obj = o;
        }

        public long getId() {
            return this.obj.getId();
        }

        public void setId(long value) {
            this.obj.setId(value);
        }

        public int getSize() {
            return this.obj.getSize();
        }

        public void setSize(int value) {
            this.obj.setSize(value);
        }

        public TRCClass getIsA() {
            return this.obj.getIsA();
        }

        public void setIsA(TRCClass value) {
            this.obj.setIsA(value);
        }

        public TRCProcess getProcess() {
            return this.obj.getProcess();
        }

        public void setProcess(TRCProcess value) {
            this.obj.setProcess(value);
        }

        public EClass eClass() {
            return this.obj.eClass();
        }

        public Resource eResource() {
            return this.obj.eResource();
        }

        public EObject eContainer() {
            return this.obj.eContainer();
        }

        public EStructuralFeature eContainingFeature() {
            return this.obj.eContainingFeature();
        }

        public EReference eContainmentFeature() {
            return this.obj.eContainmentFeature();
        }

        public EList eContents() {
            return this.obj.eContents();
        }

        public TreeIterator eAllContents() {
            return this.obj.eAllContents();
        }

        public boolean eIsProxy() {
            return this.obj.eIsProxy();
        }

        public EList eCrossReferences() {
            return this.obj.eCrossReferences();
        }

        public Object eGet(EStructuralFeature feature) {
            return this.obj.eGet(feature);
        }

        public Object eGet(EStructuralFeature feature, boolean resolve) {
            return this.obj.eGet(feature, resolve);
        }

        public void eSet(EStructuralFeature feature, Object newValue) {
            this.obj.eSet(feature, newValue);
        }

        public boolean eIsSet(EStructuralFeature feature) {
            return this.obj.eIsSet(feature);
        }

        public void eUnset(EStructuralFeature feature) {
            this.obj.eUnset(feature);
        }

        public EList eAdapters() {
            return this.obj.eAdapters();
        }

        public boolean eDeliver() {
            return this.obj.eDeliver();
        }

        public void eSetDeliver(boolean deliver) {
            this.obj.eSetDeliver(deliver);
        }

        public void eNotify(Notification notification) {
            this.obj.eNotify(notification);
        }

        public boolean testAttribute(Object target, String name, String value) {
            return false;
        }

        public EList getRefOwner() {
            return this.obj instanceof TRCHeapObject ? ((TRCHeapObject)this.obj).getRefOwner() : null;
        }

        public EList getRefTarget() {
            return this.obj instanceof TRCHeapObject ? ((TRCHeapObject)this.obj).getRefTarget() : null;
        }

        public EList getInvocations() {
            return this.obj instanceof TRCTraceObject ? ((TRCTraceObject)this.obj).getInvocations() : null;
        }

        public TRCThread getThread() {
            return this.obj instanceof TRCTraceObject ? ((TRCTraceObject)this.obj).getThread() : null;
        }

        public void setThread(TRCThread value) {
            if (this.obj instanceof TRCTraceObject) {
                ((TRCTraceObject)this.obj).setThread(value);
            }
        }
    }

    class MyTRCClassData
    implements IFTRCClass {
        private TRCClass cls = null;

        public MyTRCClassData(TRCClass o) {
            this.cls = o;
        }

        public long getId() {
            return this.cls.getId();
        }

        public void setId(long value) {
            this.cls.setId(value);
        }

        public String getName() {
            return this.cls.getName();
        }

        public void setName(String value) {
            this.cls.setName(value);
        }

        public int getSize() {
            return this.cls.getSize();
        }

        public void setSize(int value) {
            this.cls.setSize(value);
        }

        public double getLoadTime() {
            return this.cls.getLoadTime();
        }

        public void setLoadTime(double value) {
            this.cls.setLoadTime(value);
        }

        public double getUnloadTime() {
            return this.cls.getUnloadTime();
        }

        public void setUnloadTime(double value) {
            this.cls.setUnloadTime(value);
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }

        public void setInterface(boolean value) {
            this.cls.setInterface(value);
        }

        public int getLineNo() {
            return this.cls.getLineNo();
        }

        public void setLineNo(int value) {
            this.cls.setLineNo(value);
        }

        public double getBaseTime() {
            return this.cls.getBaseTime();
        }

        public void setBaseTime(double value) {
            this.cls.setBaseTime(value);
        }

        public double getCumulativeTime() {
            return this.cls.getCumulativeTime();
        }

        public void setCumulativeTime(double value) {
            this.cls.setCumulativeTime(value);
        }

        public int getCalls() {
            return this.cls.getCalls();
        }

        public void setCalls(int value) {
            this.cls.setCalls(value);
        }

        public int getInheritedCalls() {
            return this.cls.getInheritedCalls();
        }

        public void setInheritedCalls(int value) {
            this.cls.setInheritedCalls(value);
        }

        public double getInheritedBaseTime() {
            return this.cls.getInheritedBaseTime();
        }

        public void setInheritedBaseTime(double value) {
            this.cls.setInheritedBaseTime(value);
        }

        public double getInheritedCumulativeTime() {
            return this.cls.getInheritedCumulativeTime();
        }

        public void setInheritedCumulativeTime(double value) {
            this.cls.setInheritedCumulativeTime(value);
        }

        public int getTotalSize() {
            return this.cls.getTotalSize();
        }

        public void setTotalSize(int value) {
            this.cls.setTotalSize(value);
        }

        public int getTotalInstances() {
            return this.cls.getTotalInstances();
        }

        public void setTotalInstances(int value) {
            this.cls.setTotalInstances(value);
        }

        public int getCollectedSize() {
            return this.cls.getCollectedSize();
        }

        public void setCollectedSize(int value) {
            this.cls.setCollectedSize(value);
        }

        public int getCollectedInstances() {
            return this.cls.getCollectedInstances();
        }

        public void setCollectedInstances(int value) {
            this.cls.setCollectedInstances(value);
        }

        public double getTotalCpuTime() {
            return this.cls.getTotalCpuTime();
        }

        public void setTotalCpuTime(double value) {
            this.cls.setTotalCpuTime(value);
        }

        public EList getObjects() {
            return this.cls.getObjects();
        }

        public TRCThread getLoadedBy() {
            return this.cls.getLoadedBy();
        }

        public void setLoadedBy(TRCThread value) {
            this.cls.setLoadedBy(value);
        }

        public EList getMethods() {
            return this.cls.getMethods();
        }

        public EList getClassObjects() {
            return this.cls.getClassObjects();
        }

        public TRCPackage getPackage() {
            return this.cls.getPackage();
        }

        public void setPackage(TRCPackage value) {
            this.cls.setPackage(value);
        }

        public TRCClassLoader getClassLoader() {
            return this.cls.getClassLoader();
        }

        public void setClassLoader(TRCClassLoader value) {
            this.cls.setClassLoader(value);
        }

        public TRCSourceInfo getSourceInfo() {
            return this.cls.getSourceInfo();
        }

        public void setSourceInfo(TRCSourceInfo value) {
            this.cls.setSourceInfo(value);
        }

        public TRCClass getEnclosedBy() {
            return this.cls.getEnclosedBy();
        }

        public void setEnclosedBy(TRCClass value) {
            this.cls.setEnclosedBy(value);
        }

        public EList getExtends() {
            return this.getExtends();
        }

        public EList getImplements() {
            return this.getImplements();
        }

        public EList getLocks() {
            return this.getLocks();
        }

        public EClass eClass() {
            return this.cls.eClass();
        }

        public Resource eResource() {
            return this.cls.eResource();
        }

        public EObject eContainer() {
            return this.cls.eContainer();
        }

        public EStructuralFeature eContainingFeature() {
            return this.cls.eContainingFeature();
        }

        public EReference eContainmentFeature() {
            return this.cls.eContainmentFeature();
        }

        public EList eContents() {
            return this.cls.eContents();
        }

        public TreeIterator eAllContents() {
            return this.cls.eAllContents();
        }

        public boolean eIsProxy() {
            return this.cls.eIsProxy();
        }

        public EList eCrossReferences() {
            return this.cls.eCrossReferences();
        }

        public Object eGet(EStructuralFeature feature) {
            return this.cls.eGet(feature);
        }

        public Object eGet(EStructuralFeature feature, boolean resolve) {
            return this.cls.eGet(feature, resolve);
        }

        public void eSet(EStructuralFeature feature, Object newValue) {
            this.cls.eSet(feature, newValue);
        }

        public boolean eIsSet(EStructuralFeature feature) {
            return this.cls.eIsSet(feature);
        }

        public void eUnset(EStructuralFeature feature) {
            this.cls.eUnset(feature);
        }

        public EList eAdapters() {
            return this.cls.eAdapters();
        }

        public boolean eDeliver() {
            return this.cls.eDeliver();
        }

        public void eSetDeliver(boolean deliver) {
            this.cls.eSetDeliver(deliver);
        }

        public void eNotify(Notification notification) {
            this.cls.eNotify(notification);
        }

        public void takeSnapshot() {
            this.cls.takeSnapshot();
        }

        public ISnapshot retrieveSnapshot() {
            return this.cls.retrieveSnapshot();
        }

        public void removeSnapshot() {
            this.cls.removeSnapshot();
        }

        public int computeDelta(IDelta delta) {
            return this.cls.computeDelta(delta);
        }

        public int computeDelta(IDelta delta, int featureID) {
            return this.cls.computeDelta(delta, featureID);
        }

        public boolean testAttribute(Object target, String name, String value) {
            return true;
        }

        public TRCPrimitiveType getArrayType() {
            return this.cls instanceof TRCArrayClass ? ((TRCArrayClass)this.cls).getArrayType() : null;
        }

        public void setArrayType(TRCPrimitiveType value) {
            if (this.cls instanceof TRCArrayClass) {
                ((TRCArrayClass)this.cls).setArrayType(value);
            }
        }

        public TRCClass getElementType() {
            return this.cls instanceof TRCArrayClass ? ((TRCArrayClass)this.cls).getElementType() : null;
        }

        public void setElementType(TRCClass value) {
            if (this.cls instanceof TRCArrayClass) {
                ((TRCArrayClass)this.cls).setElementType(value);
            }
        }
    }

    class ReferenceTreeViewer
    extends TableTreeViewer {
        public ReferenceTreeViewer(Composite parent) {
            super(parent);
        }

        public ReferenceTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class ObjReferenceLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ObjReferenceLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            return null;
        }

        public String getColumnText(Object obj, int col) {
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col)).getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                switch (pos) {
                    case 0: {
                        return ((TRCClass)obj).getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(((TRCClass)obj).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        return String.valueOf(((TRCClass)obj).getTotalSize() - ((TRCClass)obj).getCollectedSize());
                    }
                    case 3: {
                        return "";
                    }
                }
            } else if (obj instanceof TRCHeapObject) {
                TRCHeapObject object = (TRCHeapObject)obj;
                switch (pos) {
                    case 0: {
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        if (clas == object.getIsA()) {
                            return clas.getName() + "." + object.getId();
                        }
                        return clas.getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(PerftraceUtil.getClass((TRCObject)object).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        int size = object.getSize();
                        if (size != 0) {
                            return String.valueOf(size);
                        }
                        if (ReferenceTable.this.showReferTo()) {
                            if (object.getRefTarget().size() > 0 && object.getRefTarget().get(0) instanceof TRCAggregatedObjectReference) {
                                return String.valueOf(((TRCAggregatedObjectReference)object.getRefTarget().get(0)).getTargetSize());
                            }
                            TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                            int instSize = clas.getTotalInstances();
                            if (instSize == 0) {
                                instSize = 1;
                            }
                            return String.valueOf(clas.getTotalSize() / instSize);
                        }
                        if (object.getRefOwner().size() > 0 && object.getRefOwner().get(0) instanceof TRCAggregatedObjectReference) {
                            return String.valueOf(((TRCAggregatedObjectReference)object.getRefOwner().get(0)).getOwnerSize());
                        }
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        int instSize = clas.getTotalInstances();
                        if (instSize == 0) {
                            instSize = 1;
                        }
                        return String.valueOf(clas.getTotalSize() / instSize);
                    }
                    case 3: {
                        if (ReferenceTable.this.showReferTo()) {
                            int nb = 0;
                            int size = ((TRCHeapObject)obj).getRefTarget().size();
                            int idx = 0;
                            while (idx < size) {
                                nb = object.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)object.getRefTarget().get(idx)).getCount()) : ++nb;
                                ++idx;
                            }
                            if (nb > 0) {
                                return TString.change((String)TraceUIPlugin.getString("REF_BY_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                            }
                            return "";
                        }
                        int nb = 0;
                        int size = ((TRCHeapObject)obj).getRefOwner().size();
                        int idx = 0;
                        while (idx < size) {
                            nb = object.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)object.getRefOwner().get(idx)).getCount()) : ++nb;
                            ++idx;
                        }
                        if (nb > 0) {
                            return TString.change((String)TraceUIPlugin.getString("REF_TO_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                        }
                        return "";
                    }
                }
            } else {
                TRCObjectReference ref = (TRCObjectReference)obj;
                switch (pos) {
                    case 0: {
                        TRCHeapObject object = null;
                        object = ReferenceTable.this.showReferTo() ? ref.getOwner() : ref.getTarget();
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        if (clas == object.getIsA()) {
                            return clas.getName() + "." + object.getId();
                        }
                        return clas.getName();
                    }
                    case 1: {
                        TRCHeapObject object = null;
                        object = ReferenceTable.this.showReferTo() ? ref.getOwner() : ref.getTarget();
                        return PerftraceUtil.getPackageName(PerftraceUtil.getClass((TRCObject)object).getPackage(), ReferenceTable.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        int size = 0;
                        size = ref instanceof TRCAggregatedObjectReference ? (ReferenceTable.this.showReferTo() ? ((TRCAggregatedObjectReference)ref).getOwnerSize() : ((TRCAggregatedObjectReference)ref).getTargetSize()) : (ReferenceTable.this.showReferTo() ? ref.getOwner().getSize() : ref.getTarget().getSize());
                        return String.valueOf(size);
                    }
                    case 3: {
                        if (ReferenceTable.this.showReferTo()) {
                            int nb = 0;
                            Object[] list = ref.getOwner().getRefTarget().toArray();
                            int size = list.length;
                            int idx = 0;
                            while (idx < size) {
                                nb = list[idx] instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)list[idx]).getCount()) : ++nb;
                                ++idx;
                            }
                            if (nb > 0) {
                                return TString.change((String)TraceUIPlugin.getString("REF_BY_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                            }
                            return "";
                        }
                        int nb = 0;
                        Object[] list = ref.getTarget().getRefOwner().toArray();
                        int size = list.length;
                        int idx = 0;
                        while (idx < size) {
                            nb = list[idx] instanceof TRCAggregatedObjectReference ? (nb += ((TRCAggregatedObjectReference)list[idx]).getCount()) : ++nb;
                            ++idx;
                        }
                        if (nb > 0) {
                            return TString.change((String)TraceUIPlugin.getString("REF_TO_DETAIL"), (String)"%1", (String)String.valueOf(nb));
                        }
                        return "";
                    }
                    case 4: {
                        int size;
                        if (ReferenceTable.this.showReferTo()) {
                            int size2;
                            if (ref instanceof TRCAggregatedObjectReference && (size2 = ((TRCAggregatedObjectReference)ref).getCount()) > 1) {
                                return TString.change((String)TString.change((String)TraceUIPlugin.getString("REF_BY_DET1"), (String)"%1", (String)String.valueOf(size2)), (String)"%2", (String)PerftraceUtil.getClass((TRCObject)ref.getTarget()).getName());
                            }
                            return "";
                        }
                        if (ref instanceof TRCAggregatedObjectReference && (size = ((TRCAggregatedObjectReference)ref).getCount()) > 1) {
                            return TString.change((String)TString.change((String)TraceUIPlugin.getString("REF_TO_DET1"), (String)"%1", (String)PerftraceUtil.getClass((TRCObject)((TRCAggregatedObjectReference)obj).getOwner()).getName()), (String)"%2", (String)String.valueOf(size));
                        }
                        return "";
                    }
                }
            }
            return "";
        }
    }

    public class ObjReferenceContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCClass) {
                return null;
            }
            if (element instanceof TRCHeapObject) {
                return ((TRCHeapObject)element).getIsA();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = PerftraceUtil.getAllClasses(ReferenceTable.this._page.getMOFObject());
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof TRCClass) {
                    elements[i] = new MyTRCClassData((TRCClass)elements[i]);
                } else if (elements[i] instanceof TRCObject) {
                    elements[i] = new MyTRCObjectData((TRCObject)elements[i]);
                }
                ++i;
            }
            return elements;
        }

        private EList getRef(TRCHeapObject obj) {
            if (ReferenceTable.this.showReferTo()) {
                return obj.getRefTarget();
            }
            return obj.getRefOwner();
        }

        private TRCHeapObject getHeapObject(TRCObjectReference obj) {
            if (ReferenceTable.this.showReferTo()) {
                return obj.getOwner();
            }
            return obj.getTarget();
        }

        public Object[] getChildren(Object element) {
            ReferenceTable.this.tmpList.clear();
            if (element instanceof TRCClass) {
                TRCHeapObject obj = null;
                Object[] classObjects = ((TRCClass)element).getClassObjects().toArray();
                int idx = 0;
                while (idx < classObjects.length) {
                    TRCObject tmpObject = (TRCObject)classObjects[idx];
                    if (tmpObject instanceof TRCHeapObject) {
                        obj = (TRCHeapObject)tmpObject;
                        break;
                    }
                    ++idx;
                }
                if (obj != null && this.getRef(obj).size() > 0) {
                    ReferenceTable.this.tmpList.add(obj);
                }
                Object[] objects = ((TRCClass)element).getObjects().toArray();
                int idx2 = 0;
                while (idx2 < objects.length) {
                    TRCObject tmpObject = (TRCObject)objects[idx2];
                    if (tmpObject instanceof TRCHeapObject && this.getRef((TRCHeapObject)tmpObject).size() > 0) {
                        ReferenceTable.this.tmpList.add(tmpObject);
                    }
                    ++idx2;
                }
            } else if (element instanceof TRCHeapObject) {
                ReferenceTable.this.tmpList.addAll(this.getRef((TRCHeapObject)element));
            } else {
                ReferenceTable.this.tmpList.addAll(this.getRef(this.getHeapObject((TRCObjectReference)element)));
            }
            return ReferenceTable.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    public class ObjReferenceSorter
    extends StatisticView.StatisticSorter {
        public ObjReferenceSorter() {
            super(ReferenceTable.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof TRCClass) {
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * ((TRCClass)e1).getName().compareToIgnoreCase(((TRCClass)e2).getName());
                    }
                    case 1: {
                        return this._sortSequence * ((TRCClass)e1).getPackage().getName().compareToIgnoreCase(((TRCClass)e2).getPackage().getName());
                    }
                    case 2: {
                        TRCClass c1 = (TRCClass)e1;
                        TRCClass c2 = (TRCClass)e2;
                        return this._sortSequence * (c1.getTotalSize() - c1.getCollectedSize() - (c2.getTotalSize() - c2.getCollectedSize()));
                    }
                    case 3: {
                        return 0;
                    }
                }
            } else if (e1 instanceof TRCHeapObject) {
                TRCHeapObject object1 = (TRCHeapObject)e1;
                TRCHeapObject object2 = (TRCHeapObject)e2;
                switch (this._pos) {
                    case 0: {
                        TRCClass clas = object1.getIsA();
                        String name1 = PerftraceUtil.getClass((TRCObject)object1).getName();
                        String name2 = PerftraceUtil.getClass((TRCObject)object2).getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 1: {
                        String name1 = PerftraceUtil.getClass((TRCObject)object1).getPackage().getName();
                        String name2 = PerftraceUtil.getClass((TRCObject)object2).getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 2: {
                        int size1 = 0;
                        int size2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            Object[] refs = object1.getRefTarget().toArray();
                            int idx = 0;
                            while (idx < refs.length) {
                                TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];
                                size1 = tmpRef instanceof TRCAggregatedObjectReference ? (size1 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize()) : (size1 += tmpRef.getTarget().getSize());
                                ++idx;
                            }
                            refs = object2.getRefTarget().toArray();
                            int idx2 = 0;
                            while (idx2 < refs.length) {
                                TRCObjectReference tmpRef = (TRCObjectReference)refs[idx2];
                                size2 = tmpRef instanceof TRCAggregatedObjectReference ? (size2 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize()) : (size2 += tmpRef.getTarget().getSize());
                                ++idx2;
                            }
                        } else {
                            Object[] refs = object1.getRefOwner().toArray();
                            int idx = 0;
                            while (idx < refs.length) {
                                if (refs[idx] instanceof TRCAggregatedObjectReference) {
                                    size1 += ((TRCAggregatedObjectReference)refs[idx]).getOwnerSize();
                                }
                                ++idx;
                            }
                            refs = object2.getRefOwner().toArray();
                            int idx3 = 0;
                            while (idx3 < refs.length) {
                                if (refs[idx3] instanceof TRCAggregatedObjectReference) {
                                    size2 += ((TRCAggregatedObjectReference)refs[idx3]).getOwnerSize();
                                }
                                ++idx3;
                            }
                        }
                        return this._sortSequence * (size1 - size2);
                    }
                    case 3: {
                        int size;
                        int idx;
                        int size2;
                        int nb1 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size2 = object1.getRefTarget().size();
                            idx = 0;
                            while (idx < size2) {
                                nb1 = object1.getRefTarget().get(idx) instanceof TRCAggregatedObjectReference ? (nb1 += ((TRCAggregatedObjectReference)object1.getRefTarget().get(idx)).getCount()) : ++nb1;
                                ++idx;
                            }
                        } else {
                            size2 = object1.getRefOwner().size();
                            idx = 0;
                            while (idx < size2) {
                                nb1 = object1.getRefOwner().get(idx) instanceof TRCAggregatedObjectReference ? (nb1 += ((TRCAggregatedObjectReference)object1.getRefOwner().get(idx)).getCount()) : ++nb1;
                                ++idx;
                            }
                        }
                        int nb2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size = object2.getRefTarget().size();
                            int idx4 = 0;
                            while (idx4 < size) {
                                nb2 = object2.getRefTarget().get(idx4) instanceof TRCAggregatedObjectReference ? (nb2 += ((TRCAggregatedObjectReference)object2.getRefTarget().get(idx4)).getCount()) : ++nb2;
                                ++idx4;
                            }
                        } else {
                            size = object2.getRefOwner().size();
                            int idx5 = 0;
                            while (idx5 < size) {
                                nb2 = object2.getRefOwner().get(idx5) instanceof TRCAggregatedObjectReference ? (nb2 += ((TRCAggregatedObjectReference)object2.getRefOwner().get(idx5)).getCount()) : ++nb2;
                                ++idx5;
                            }
                        }
                        return this._sortSequence * (nb1 - nb2);
                    }
                }
            } else {
                TRCObjectReference ref1 = (TRCObjectReference)e1;
                TRCObjectReference ref2 = (TRCObjectReference)e2;
                switch (this._pos) {
                    case 0: {
                        TRCHeapObject object = ref1.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref1.getOwner() : ref1.getTarget();
                        TRCClass clas = PerftraceUtil.getClass((TRCObject)object);
                        String name1 = clas.getName();
                        name1 = clas == object.getProcess().getClassClass() ? clas.getName() : clas.getName() + "." + object.getId();
                        object = ref2.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref2.getOwner() : ref2.getTarget();
                        clas = PerftraceUtil.getClass((TRCObject)object);
                        String name2 = clas.getName();
                        name2 = clas == object.getProcess().getClassClass() ? clas.getName() : clas.getName() + "." + object.getId();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 1: {
                        TRCHeapObject object = ref1.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref1.getOwner() : ref1.getTarget();
                        String name1 = PerftraceUtil.getClass((TRCObject)object).getPackage().getName();
                        object = ref2.getTarget();
                        object = ReferenceTable.this.showReferTo() ? ref2.getOwner() : ref2.getTarget();
                        String name2 = PerftraceUtil.getClass((TRCObject)object).getPackage().getName();
                        return this._sortSequence * name1.compareToIgnoreCase(name2);
                    }
                    case 2: {
                        int size1 = 0;
                        int size2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            Object[] refs = ref1.getOwner().getRefTarget().toArray();
                            int idx = 0;
                            while (idx < refs.length) {
                                TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];
                                size1 = tmpRef instanceof TRCAggregatedObjectReference ? (size1 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize()) : (size1 += tmpRef.getTarget().getSize());
                                ++idx;
                            }
                            refs = ref2.getOwner().getRefTarget().toArray();
                            int idx6 = 0;
                            while (idx6 < refs.length) {
                                TRCObjectReference tmpRef = (TRCObjectReference)refs[idx6];
                                size2 = tmpRef instanceof TRCAggregatedObjectReference ? (size2 += ((TRCAggregatedObjectReference)tmpRef).getTargetSize()) : (size2 += tmpRef.getTarget().getSize());
                                ++idx6;
                            }
                        } else {
                            Object[] refs = ref1.getTarget().getRefOwner().toArray();
                            int idx = 0;
                            while (idx < refs.length) {
                                TRCObjectReference tmpRef = (TRCObjectReference)refs[idx];
                                size1 = tmpRef instanceof TRCAggregatedObjectReference ? (size1 += ((TRCAggregatedObjectReference)tmpRef).getOwnerSize()) : (size1 += tmpRef.getOwner().getSize());
                                ++idx;
                            }
                            refs = ref2.getTarget().getRefOwner().toArray();
                            int idx7 = 0;
                            while (idx7 < refs.length) {
                                TRCObjectReference tmpRef = (TRCObjectReference)refs[idx7];
                                size2 = tmpRef instanceof TRCAggregatedObjectReference ? (size2 += ((TRCAggregatedObjectReference)tmpRef).getOwnerSize()) : (size2 += tmpRef.getOwner().getSize());
                                ++idx7;
                            }
                        }
                        return this._sortSequence * (size1 - size2);
                    }
                    case 3: {
                        int size;
                        int idx;
                        int size3;
                        int nb1 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size3 = ref1.getOwner().getRefTarget().size();
                            idx = 0;
                            while (idx < size3) {
                                nb1 = ref1.getOwner().getRefTarget().get(idx) instanceof TRCAggregatedObjectReference ? (nb1 += ((TRCAggregatedObjectReference)ref1.getOwner().getRefTarget().get(idx)).getCount()) : ++nb1;
                                ++idx;
                            }
                        } else {
                            size3 = ref1.getTarget().getRefOwner().size();
                            idx = 0;
                            while (idx < size3) {
                                nb1 = ref1.getTarget().getRefOwner().get(idx) instanceof TRCAggregatedObjectReference ? (nb1 += ((TRCAggregatedObjectReference)ref1.getTarget().getRefOwner().get(idx)).getCount()) : ++nb1;
                                ++idx;
                            }
                        }
                        int nb2 = 0;
                        if (ReferenceTable.this.showReferTo()) {
                            size = ref2.getOwner().getRefTarget().size();
                            int idx8 = 0;
                            while (idx8 < size) {
                                nb2 = ref2.getOwner().getRefTarget().get(idx8) instanceof TRCAggregatedObjectReference ? (nb2 += ((TRCAggregatedObjectReference)ref2.getOwner().getRefTarget().get(idx8)).getCount()) : ++nb2;
                                ++idx8;
                            }
                        } else {
                            size = ref2.getTarget().getRefOwner().size();
                            int idx9 = 0;
                            while (idx9 < size) {
                                nb2 = ref2.getTarget().getRefOwner().get(idx9) instanceof TRCAggregatedObjectReference ? (nb2 += ((TRCAggregatedObjectReference)ref2.getTarget().getRefOwner().get(idx9)).getCount()) : ++nb2;
                                ++idx9;
                            }
                        }
                        return this._sortSequence * (nb1 - nb2);
                    }
                    case 4: {
                        if (!(ref1 instanceof TRCAggregatedObjectReference) || !(ref2 instanceof TRCAggregatedObjectReference)) break;
                        return this._sortSequence * (((TRCAggregatedObjectReference)ref1).getCount() - ((TRCAggregatedObjectReference)ref2).getCount());
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ReferenceTable.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCClass)) {
                return true;
            }
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                int k = 0;
                while (k < this._textList.size()) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                    ++k;
                }
            }
            return flag;
        }
    }
}

