/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.loaders.trace.TraceUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;

public class UpdateModel
implements IProfileEventListener {
    private Object selObject;

    public void handleProfileEvent(ProfileEvent event) {
        if ((event.getType() == 32 || event.getType() == 6144) && event.getSource() instanceof EObject) {
            this.selObject = event.getSource();
            if (this.selObject == null) {
                return;
            }
            this.updateDelta();
            this.selObject = null;
        }
    }

    private void updateDelta() {
        if (this.selObject != null) {
            if (this.selObject instanceof TRCAgentProxy) {
                this.updateDelta((TRCAgentProxy)this.selObject);
                return;
            }
            if (this.selObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy)this.selObject).getAgentProxies().toArray();
                int idx = 0;
                while (idx < agents.length) {
                    this.updateDelta((TRCAgentProxy)agents[idx]);
                    ++idx;
                }
                return;
            }
            if (this.selObject instanceof TRCNode) {
                Object[] processes = ((TRCNode)this.selObject).getProcessProxies().toArray();
                int idx = 0;
                while (idx < processes.length) {
                    Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                    int i = 0;
                    while (i < agents.length) {
                        this.updateDelta((TRCAgentProxy)agents[i]);
                        ++i;
                    }
                    ++idx;
                }
                return;
            }
            if (this.selObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor)this.selObject).getNodes().toArray();
                int k = 0;
                while (k < nodes.length) {
                    Object[] processes = ((TRCNode)nodes[k]).getProcessProxies().toArray();
                    int idx = 0;
                    while (idx < processes.length) {
                        Object[] agents = ((TRCProcessProxy)processes[idx]).getAgentProxies().toArray();
                        int i = 0;
                        while (i < agents.length) {
                            this.updateDelta((TRCAgentProxy)agents[i]);
                            ++i;
                        }
                        ++idx;
                    }
                    ++k;
                }
                return;
            }
        }
    }

    private void updateDelta(TRCAgentProxy agent) {
        if (!agent.getType().equals("Profiler") || agent.getAgent() == null || this.getProcess(agent.getAgent()) == null) {
            return;
        }
        TraceUtils.takeSnapshot((TRCProcess)this.getProcess(agent.getAgent()));
    }

    private TRCProcess getProcess(TRCAgent agent) {
        if (agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess)agent.getProcess();
        }
        return null;
    }
}

