/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class BufferedPeriodicReader {
    private String filename = null;
    private String converter = null;
    private String[] converterArray = null;
    private String shell = null;
    private RandomAccessFile currentFile = null;
    private File currentFileStat = null;
    private long lastBookmark = 0L;
    private long lastModified = 0L;
    private long lastSize = 0L;
    private int confidenceBufferSize = 1024;
    private int fileFooterSize = 90;
    private Object currentThreadLock = new Object();
    private int childThreadsDone = 0;
    private static String EOL_CHARS = System.getProperty("line.separator");
    private static char EOL_LAST_CHAR = (char)(System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? 21 : (int)EOL_CHARS.charAt(EOL_CHARS.length() - 1));
    private int initialBufferSize = 2048;
    private String charset = "UTF-8";
    private boolean multiFile = false;
    private byte[] historicInfo = null;

    public BufferedPeriodicReader(String newFilename) {
        this(newFilename, null, null);
    }

    public BufferedPeriodicReader(String newFilename, String converter) {
        this(newFilename, converter, null);
    }

    public BufferedPeriodicReader(String newFilename, String converter, String shell) {
        this.filename = newFilename;
        this.converter = converter;
        this.converterArray = null;
        this.shell = shell;
    }

    public BufferedPeriodicReader(String newFilename, String[] convArray) {
        this.filename = newFilename;
        this.converter = null;
        this.shell = null;
        this.converterArray = convArray;
    }

    public void setCharset(String cs) {
        this.charset = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        int i;
        if (this.converter != null && this.converter.length() > 0 || this.converterArray != null && this.converterArray.length > 0) {
            String platform = System.getProperty("os.name", "");
            if ((this.converterArray == null || this.converterArray.length == 0) && -1 != this.converter.indexOf("\"")) {
                StringTokenizer tokenizer;
                int quoteIndex = this.converter.indexOf("\"");
                int matchingQuoteIndex = 0;
                String currentString = this.converter;
                ArrayList<String> converterList = new ArrayList<String>();
                if (this.shell != null || this.shell == null && !platform.startsWith("Windows") && !platform.startsWith("Linux")) {
                    if (this.shell == null) {
                        this.shell = "sh";
                    }
                    converterList.add(this.shell);
                }
                while (quoteIndex != -1) {
                    if (quoteIndex > 0) {
                        String beforeQuote = currentString.substring(0, quoteIndex);
                        tokenizer = new StringTokenizer(beforeQuote);
                        while (tokenizer.hasMoreTokens()) {
                            converterList.add(tokenizer.nextToken());
                        }
                        currentString = currentString.substring(quoteIndex);
                        quoteIndex = 0;
                    }
                    if ((matchingQuoteIndex = currentString.substring(quoteIndex + 1).indexOf("\"")) == -1) break;
                    converterList.add(currentString.substring(quoteIndex + 1, ++matchingQuoteIndex));
                    if (currentString.length() > matchingQuoteIndex + 1) {
                        currentString = currentString.substring(matchingQuoteIndex + 1).trim();
                        quoteIndex = currentString.indexOf("\"");
                        continue;
                    }
                    quoteIndex = -1;
                    currentString = null;
                }
                if (matchingQuoteIndex != -1) {
                    if (currentString != null && currentString.length() > 0) {
                        tokenizer = new StringTokenizer(currentString);
                        while (tokenizer.hasMoreTokens()) {
                            converterList.add(tokenizer.nextToken());
                        }
                    }
                    this.converterArray = new String[converterList.size()];
                    Iterator it = converterList.iterator();
                    i = 0;
                    while (i < converterList.size()) {
                        this.converterArray[i] = (String)it.next();
                        ++i;
                    }
                    this.converter = null;
                }
            }
            try {
                Process converterProcess;
                Object matchingQuoteIndex = this.currentThreadLock;
                synchronized (matchingQuoteIndex) {
                    String converterCmd;
                    this.childThreadsDone = 0;
                    if (this.converterArray != null) {
                        converterProcess = Runtime.getRuntime().exec(this.converterArray);
                    } else if (platform.startsWith("Windows")) {
                        converterProcess = Runtime.getRuntime().exec(this.converter);
                    } else if (platform.startsWith("Linux")) {
                        converterCmd = this.shell == null ? this.converter : this.shell + " " + this.converter;
                        converterProcess = Runtime.getRuntime().exec(converterCmd);
                    } else if (platform.startsWith("AIX")) {
                        if (this.shell == null) {
                            this.shell = "sh";
                        }
                        String[] cmdarr = new String[]{this.shell, this.converter};
                        converterProcess = Runtime.getRuntime().exec(cmdarr);
                    } else {
                        if (this.shell == null) {
                            this.shell = "sh";
                        }
                        converterCmd = this.shell + " " + this.converter;
                        converterProcess = Runtime.getRuntime().exec(converterCmd);
                    }
                    new ConverterOutputReader(converterProcess.getErrorStream()).start();
                    new ConverterOutputReader(converterProcess.getInputStream()).start();
                    try {
                        this.currentThreadLock.wait(300000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                int exitValue = -1;
                try {
                    exitValue = converterProcess.waitFor();
                }
                catch (InterruptedException i2) {
                    converterProcess.destroy();
                }
                if (exitValue != 0) {
                    throw new Exception(Messages.getString("HyadesGABufferedPeriodicReader_Converter_Process_Exit_Value_ERROR_", Integer.toString(exitValue)));
                }
            }
            catch (Exception e) {
                throw new Exception(Messages.getString("HyadesGABufferedPeriodicReader_Converter_Command_Failed_ERROR_", e.getMessage()));
            }
        }
        try {
            this.currentFileStat = new File(this.filename);
            if (this.currentFileStat.lastModified() > this.lastModified || this.currentFileStat.length() != this.lastSize) {
                this.currentFile = new RandomAccessFile(this.filename, "r");
                this.lastModified = this.currentFileStat.lastModified();
                this.lastSize = this.currentFile.length();
            }
        }
        catch (Exception e) {
            this.currentFile = null;
        }
        if (this.lastBookmark != 0L && this.currentFile != null) {
            try {
                long previousOffset = this.lastBookmark;
                long currentOffset = this.currentFile.length();
                long charactersToCompare = Math.min(Math.min((long)this.confidenceBufferSize, previousOffset), currentOffset);
                if (currentOffset >= previousOffset) {
                    boolean append = true;
                    i = this.fileFooterSize;
                    while ((long)i < charactersToCompare) {
                        this.currentFile.seek(previousOffset - 1L - (long)i);
                        char value = (char)this.currentFile.read();
                        if (this.historicInfo[i] != (byte)value) {
                            append = false;
                            break;
                        }
                        ++i;
                    }
                    if (append) {
                        this.currentFile.seek(previousOffset - (long)this.fileFooterSize);
                        int i3 = this.fileFooterSize - 1;
                        while (i3 >= 0) {
                            int value = this.currentFile.read();
                            if (this.historicInfo[i3] != (byte)value) break;
                            --i3;
                        }
                        this.historicInfo = null;
                        this.lastBookmark = this.currentFile.getFilePointer();
                        return;
                    }
                }
                long matchedChars = 0L;
                int historicInfoOffset = this.fileFooterSize;
                long currentCurrentFileOffset = currentOffset -= (long)this.fileFooterSize;
                do {
                    this.currentFile.seek(--currentCurrentFileOffset);
                    if (this.historicInfo[historicInfoOffset++] == this.currentFile.read()) {
                        ++matchedChars;
                        continue;
                    }
                    currentCurrentFileOffset = --currentOffset;
                    historicInfoOffset = this.fileFooterSize;
                    matchedChars = 0L;
                } while (matchedChars < charactersToCompare - (long)this.fileFooterSize && currentOffset > 0L);
                if (matchedChars == charactersToCompare - (long)this.fileFooterSize) {
                    this.currentFile.seek(currentOffset);
                    int i4 = this.fileFooterSize - 1;
                    while (i4 >= 0) {
                        int value = this.currentFile.read();
                        if (this.historicInfo[i4] != (byte)value) {
                            this.historicInfo = null;
                            this.lastBookmark = this.currentFile.getFilePointer();
                            return;
                        }
                        --i4;
                    }
                    this.historicInfo = null;
                    this.lastBookmark = currentOffset + (long)this.fileFooterSize;
                    return;
                }
                this.historicInfo = null;
                this.lastBookmark = 0L;
                return;
            }
            catch (IOException e) {
                throw new Exception(Messages.getString("HyadesGABufferedPeriodicReader_Determine_File_Modification_ERROR_", this.filename, e.getMessage()));
            }
        }
    }

    public void close() {
        try {
            if (this.currentFile != null) {
                this.currentFile.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.currentFile = null;
    }

    public String readLine() throws IOException {
        boolean endOfFile = false;
        if (this.currentFile != null) {
            String last = null;
            this.currentFile.seek(this.lastBookmark);
            if (this.currentFile != null) {
                try {
                    byte[] buffer = new byte[this.initialBufferSize];
                    int bufferSize = 0;
                    int singleByte = 0;
                    block3: while ((singleByte = this.currentFile.read()) != -1) {
                        if (singleByte == EOL_LAST_CHAR) {
                            if (EOL_CHARS.length() > 1 && bufferSize > 0) {
                                int k = EOL_CHARS.length() - 2;
                                while (k >= 0) {
                                    if ((byte)EOL_CHARS.charAt(k) != buffer[bufferSize - 1]) break block3;
                                    buffer[--bufferSize] = 0;
                                    --k;
                                }
                                break;
                            }
                            if (bufferSize <= 0 || EOL_LAST_CHAR != '\n' || buffer[bufferSize - 1] != 13) break;
                            buffer[--bufferSize] = 0;
                            break;
                        }
                        if (bufferSize == buffer.length) {
                            byte[] tempBuffer = new byte[buffer.length + this.initialBufferSize];
                            System.arraycopy(buffer, 0, tempBuffer, 0, bufferSize);
                            buffer = tempBuffer;
                        }
                        buffer[bufferSize++] = (byte)singleByte;
                    }
                    if (singleByte == -1) {
                        endOfFile = true;
                    }
                    last = bufferSize == 0 && endOfFile ? null : new String(buffer, 0, bufferSize, this.charset);
                }
                catch (EOFException e) {
                    last = null;
                }
                catch (NullPointerException e) {
                    last = null;
                }
                if (endOfFile) {
                    int bytesToSave = (int)Math.min(this.currentFile.length(), (long)this.confidenceBufferSize);
                    this.currentFile.seek(this.currentFile.length() - (long)bytesToSave);
                    this.historicInfo = new byte[bytesToSave];
                    int i = bytesToSave - 1;
                    while (i >= 0) {
                        this.historicInfo[i] = (byte)this.currentFile.read();
                        --i;
                    }
                    if (!this.multiFile) {
                        this.close();
                    } else {
                        this.lastBookmark = this.currentFile.getFilePointer();
                    }
                } else {
                    this.lastBookmark = this.currentFile.getFilePointer();
                }
                return last;
            }
        }
        return null;
    }

    public long getFilePointer() {
        return this.lastBookmark;
    }

    public int getConfidenceBufferSize() {
        return this.confidenceBufferSize;
    }

    public void setConfidenceBufferSize(int confidenceBufferSize) {
        this.confidenceBufferSize = confidenceBufferSize;
    }

    public int getFileFooterSize() {
        return this.fileFooterSize;
    }

    public void setFileFooterSize(int fileFooterSize) {
        this.fileFooterSize = fileFooterSize;
    }

    public boolean isMultiFile() {
        return this.multiFile;
    }

    public void setMultiFile(boolean multiFile) {
        this.multiFile = multiFile;
    }

    public String[] getConverterArray() {
        return this.converterArray;
    }

    public void setConverter(String[] converterArray) {
        this.converterArray = converterArray;
        this.converter = null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setConverter(String converter) {
        this.converter = converter;
        this.converterArray = null;
    }

    private class ConverterOutputReader
    extends Thread {
        private BufferedReader reader;

        public ConverterOutputReader(InputStream inputStream) {
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.reader.read() != -1) {
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            Object object = BufferedPeriodicReader.this.currentThreadLock;
            synchronized (object) {
                if (++BufferedPeriodicReader.this.childThreadsDone == 2) {
                    BufferedPeriodicReader.this.currentThreadLock.notify();
                }
            }
        }
    }
}

