/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.SubstitutionRuleTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RuleSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected Text matchText;
    protected Text positionsText;
    protected Text substituteText;
    protected Button useBuiltInFunction;
    protected boolean isDisplaying;
    protected SubstitutionRuleType currentSelection;
    protected SubstitutionRuleTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory = new ParserItemProviderAdapterFactory();
    private Text substitutionExtensionClassText;
    private Text timeFormatText;

    public RuleSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_POS"), 0);
        this.positionsText = factory.createText(this, "", 0);
        this.positionsText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_MATCH"), 0);
        this.matchText = factory.createText(this, "", 0);
        this.matchText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SUBST_SUBST"), 0);
        this.substituteText = factory.createText(this, "", 0);
        this.substituteText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_SubstitutionExtensionClass"), 0);
        this.substitutionExtensionClassText = factory.createText(this, "", 0);
        this.substitutionExtensionClassText.setLayoutData((Object)new GridData(768));
        this.substitutionExtensionClassText.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_TimeFormat"), 0);
        this.timeFormatText = factory.createText(this, "", 0);
        this.timeFormatText.setLayoutData((Object)new GridData(768));
        this.timeFormatText.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.useBuiltInFunction = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("_SUBST_USE_BUILT_FCT"), 32);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.useBuiltInFunction.setLayoutData((Object)data);
        this.positionsText.addModifyListener((ModifyListener)this);
        this.matchText.addModifyListener((ModifyListener)this);
        this.substituteText.addModifyListener((ModifyListener)this);
        this.substitutionExtensionClassText.addModifyListener((ModifyListener)this);
        this.timeFormatText.addModifyListener((ModifyListener)this);
        this.useBuiltInFunction.addSelectionListener((SelectionListener)this);
        this.itemProvider = (SubstitutionRuleTypeItemProvider)this.itemFactory.createSubstitutionRuleTypeAdapter();
        this.itemProvider.addListener(this);
    }

    public void display(EObject object) {
        if (this.currentSelection == object) {
            return;
        }
        if (this.positionsText.isFocusControl() || this.matchText.isFocusControl() || this.substituteText.isFocusControl() || this.useBuiltInFunction.isFocusControl()) {
            return;
        }
        this.currentSelection = (SubstitutionRuleType)object;
        this.isDisplaying = true;
        this.matchText.setText(this.currentSelection.getMatch() == null ? "" : this.currentSelection.getMatch());
        this.positionsText.setText(this.currentSelection.getPositions() == null ? "" : this.currentSelection.getPositions());
        this.substituteText.setText(this.currentSelection.getSubstitute() == null ? "" : this.currentSelection.getSubstitute());
        this.useBuiltInFunction.setSelection(this.currentSelection.isUseBuiltInFunction());
        this.substitutionExtensionClassText.setText(this.currentSelection.getSubstitutionExtensionClass() == null ? "" : this.currentSelection.getSubstitutionExtensionClass());
        this.timeFormatText.setText(this.currentSelection.getTimeFormat() == null ? "" : this.currentSelection.getTimeFormat());
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (SubstitutionRuleType)currentSelection;
        this.currentSelection.setPositions(this.positionsText.getText());
        this.currentSelection.setMatch(this.matchText.getText());
        this.currentSelection.setSubstitute(this.substituteText.getText());
        this.currentSelection.setSubstitutionExtensionClass(this.substitutionExtensionClassText.getText());
        this.currentSelection.setTimeFormat(this.timeFormatText.getText());
        this.currentSelection.setUseBuiltInFunction(this.useBuiltInFunction.getSelection());
        return false;
    }

    public void setFocusToText() {
        this.substituteText.setFocus();
        this.substituteText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.matchText) {
            String text2 = this.matchText.getText();
            if (!text2.equals(this.currentSelection.getMatch())) {
                if (text2.length() == 0 && this.currentSelection.getMatch() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.MATCH);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.positionsText) {
            String text3 = this.positionsText.getText();
            if (!text3.equals(this.currentSelection.getPositions())) {
                if (text3.length() == 0 && this.currentSelection.getPositions() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.POSITIONS);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text3);
                }
            }
        } else if (e.getSource() == this.substituteText) {
            String text4 = this.substituteText.getText();
            if (!text4.equals(this.currentSelection.getSubstitute())) {
                if (text4.length() == 0 && this.currentSelection.getSubstitute() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.SUBSTITUTE);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text4);
                }
            }
        } else if (e.getSource() == this.substitutionExtensionClassText) {
            String text5 = this.substitutionExtensionClassText.getText();
            if (!text5.equals(this.currentSelection.getSubstitutionExtensionClass())) {
                if (text5.length() == 0 && this.currentSelection.getSubstitutionExtensionClass() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.SUBSTITUTION_EXTENSION_CLASS);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text5);
                }
            }
        } else if (e.getSource() == this.timeFormatText && !(text = this.timeFormatText.getText()).equals(this.currentSelection.getTimeFormat())) {
            if (text.length() == 0 && this.currentSelection.getTimeFormat() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.TIME_FORMAT);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetSelected(SelectionEvent e) {
        IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, SubstitutionRuleTypeItemProvider.MATCH);
        this.currentSelection.setUseBuiltInFunction(this.useBuiltInFunction.getSelection());
        String oldValue = this.currentSelection.getMatch();
        if (descriptor != null) {
            descriptor.setPropertyValue((Object)this.currentSelection, (Object)oldValue);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

