/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.LogView;

public class AcadGuiModelManager {
    private static HashMap modelMap = new HashMap();
    private static AcadGuiModel currentModel;

    public static final void disposeModel(IFile file) {
        if (file == null || modelMap == null) {
            return;
        }
        String fileName = file.getFullPath().toOSString();
        Object[] keys = modelMap.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            ContextInstanceType context = (ContextInstanceType)keys[i];
            if (context.eResource() == null) {
                Object model = modelMap.get(context);
                if (model != null) {
                    ((AcadGuiModel)model).dispose();
                    if (currentModel == model) {
                        currentModel = null;
                    }
                    modelMap.remove(context);
                }
            } else {
                Object model;
                Path ipath;
                String path = context.eResource().getURI().path();
                if (path.startsWith("/resource")) {
                    path = path.substring(9);
                }
                if ((ipath = new Path(path)).toOSString().equals(fileName) && (model = modelMap.get(context)) != null) {
                    ((AcadGuiModel)model).dispose();
                    if (currentModel == model) {
                        currentModel = null;
                    }
                    modelMap.remove(context);
                }
            }
            ++i;
        }
    }

    public static boolean isCurrentModel(IFile file) {
        if (file == null || modelMap == null) {
            return false;
        }
        String fileName = file.getFullPath().toOSString();
        Object[] keys = modelMap.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Path ipath;
            ContextInstanceType context = (ContextInstanceType)keys[i];
            String path = context.eResource().getURI().path();
            if (path.startsWith("/resource")) {
                path = path.substring(9);
            }
            if ((ipath = new Path(path)).toOSString().equals(fileName)) {
                Object model = modelMap.get(context);
                return model == currentModel;
            }
            ++i;
        }
        return false;
    }

    public static final void setCurrentModel(ContextInstanceType context) {
        boolean isNewModel = false;
        AcadGuiModel model = null;
        Object obj = modelMap.get(context);
        if (obj == null) {
            model = new AcadGuiModel();
            model.setContextInstance(context);
            modelMap.put(context, model);
            isNewModel = true;
        } else {
            model = (AcadGuiModel)obj;
        }
        if (currentModel != null && currentModel.getContextInstance() == model.getContextInstance()) {
            return;
        }
        currentModel = model;
        model.updateTestShow();
        model.updateResult();
        LogView logView = LogView.getLogView(true);
        if (logView != null) {
            logView.set_Title();
        }
    }

    public static final AcadGuiModel getCurrentModel() {
        return currentModel;
    }

    public static final AcadGuiModel getModel(ContextInstanceType context) {
        if (context == null) {
            return null;
        }
        return (AcadGuiModel)modelMap.get(context);
    }

    public static final SensorConfigType getLogForConfiguration(AcadGuiModel model) {
        if (model == null || model.getContextInstance() == null || model.getContextInstance().eContainer() == null) {
            return null;
        }
        return model.getContextInstance().getSensor();
    }
}

