/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.views;

import java.io.File;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.SensorConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.PropertyType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.actions.ActionHandlerListener;
import org.eclipse.hyades.logging.adapter.ui.internal.presentation.AdaptorEditor;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.ResultQueueEntry;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModel;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.hyades.logging.adapter.ui.internal.views.ContentView;
import org.eclipse.hyades.logging.adapter.ui.internal.views.ResultView;
import org.eclipse.hyades.logging.adapter.ui.preferences.AcadEditorPreferencePage;
import org.eclipse.hyades.logging.core.ISerializableAsXml;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart
implements IPartListener {
    private final String LOG_TITLE = AcadEditorPlugin.getPlugin().getString("TEMPLATE_LOG");
    private TextViewer eventsViewer;
    Action createRuleAction;
    Action guessRuleAction;
    Action selectAllAction;
    Action nextEventAction;
    Action previousEventAction;
    Action firstEventAction;
    Action lastEventAction;
    Action refreshAction;
    Action showLog;
    Action showPreferenceAction;
    Menu menu = null;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        this.enableEditActions();
    }

    public void createPartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayout((Layout)new FillLayout());
        this.eventsViewer = new TextViewer((Composite)sashForm, 2882);
        this.eventsViewer.setEditable(false);
        this.createActions();
        this.createToolbar();
        this.createContextMenu();
        this.set_Title();
        WorkbenchHelp.setHelp((Control)parent, (String)ContextIds.ACAD_EDITOR_LOGVIEW);
    }

    public void setFocus() {
        if (this.eventsViewer != null && this.eventsViewer.getControl() != null && this.eventsViewer.getControl().isDisposed()) {
            this.eventsViewer.getControl().setFocus();
        }
    }

    public void createActions() {
        this.showLog = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LOG_ACTION")){

            public void run() {
                LogView.this.showLog();
            }
        };
        this.showLog.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LOG_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.showLog, "lcl16", "show_log_exec.gif");
        this.nextEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_NEXTE_ACTION")){

            public void run() {
                LogView.this.showNextEvent();
            }
        };
        this.nextEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_NEXTE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.nextEventAction, "lcl16", "next_event_exec.gif");
        this.previousEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_PREVE_ACTION")){

            public void run() {
                LogView.this.showPreviousEvent();
            }
        };
        this.previousEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_PREVE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.previousEventAction, "lcl16", "previous_event_exec.gif");
        this.firstEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_FIRSTE_ACTION")){

            public void run() {
                LogView.this.showFirstEvent();
            }
        };
        this.firstEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_FIRSTE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.firstEventAction, "lcl16", "first_event_exec.gif");
        this.lastEventAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LASTE_ACTION")){

            public void run() {
                LogView.this.showLastEvent();
            }
        };
        this.lastEventAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_LASTE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.lastEventAction, "lcl16", "last_event_exec.gif");
        this.showPreferenceAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_SHOW_PREFERENCE_ACTION")){

            public void run() {
                AcadEditorPreferencePage page = new AcadEditorPreferencePage();
                page.setTitle(AcadEditorPlugin.getPlugin().getString("STR_PREF_GLA_EDITOR"));
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PreferenceDialog dialog = new PreferenceDialog(Display.getDefault().getActiveShell(), mgr);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
            }
        };
        this.showPreferenceAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_SHOW_PREFERENCE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.showPreferenceAction, "lcl16", "showglapref_co.gif");
        this.refreshAction = new Action(AcadEditorPlugin.getPlugin().getString("STR_RERUN_ACTION"), 4){

            public void runWithEvent(Event e) {
                if (e.detail != 4) {
                    AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
                    if (model != null) {
                        model.setStartRecord(0);
                        LogView.this.refreshData();
                    }
                    return;
                }
                Widget item = e.widget;
                ToolItem ti = (ToolItem)item;
                Menu m = new Menu((Control)ti.getParent());
                if (m != null) {
                    AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
                    MenuItem i1 = new MenuItem(m, 0);
                    i1.setImage(AcadEditorPluginImages.getImage("reapply_exec.gif"));
                    i1.setText(AcadEditorPlugin.getPlugin().getString("STR_RERUN_ACTION"));
                    i1.addListener(13, new Listener(this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void handleEvent(Event e) {
                            AcadGuiModelManager.getCurrentModel().setStartRecord(0);
                            7.access$300(this.this$1).refreshData();
                        }
                    });
                    if (model == null) {
                        i1.setEnabled(false);
                    }
                    MenuItem i2 = new MenuItem(m, 0);
                    i2.setImage(AcadEditorPluginImages.getImage("runtoline.gif"));
                    i2.setText(AcadEditorPlugin.getPlugin().getString("STR_SETSTART_ACTION"));
                    i2.addListener(13, new Listener(this){
                        private final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void handleEvent(Event e) {
                            boolean rc = 7.access$300(this.this$1).openSetStartRecordDlg();
                            if (rc) {
                                7.access$300(this.this$1).refreshData();
                            }
                        }
                    });
                    if (model == null) {
                        i2.setEnabled(false);
                    }
                    Rectangle b = ti.getBounds();
                    Point p = ti.getParent().toDisplay(new Point(b.x, b.y + b.height));
                    m.setLocation(p.x, p.y);
                    m.setVisible(true);
                }
            }

            static /* synthetic */ LogView access$300(7 x0) {
                return x0.LogView.this;
            }
        };
        this.refreshAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("STR_RERUN_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.refreshAction, "lcl16", "reapply_exec.gif");
        this.createRuleAction = new Action(AcadEditorPlugin.getPlugin().getString("ADD_HASH_ACTION")){

            public void run() {
                LogView.this.createRule();
            }
        };
        this.createRuleAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("ADD_HASH_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.createRuleAction, "lcl16", "create_rule_exec.gif");
        this.guessRuleAction = new Action(AcadEditorPlugin.getPlugin().getString("GUESS_RULE_ACTION")){

            public void run() {
                LogView.this.guessRule();
            }
        };
        this.guessRuleAction.setToolTipText(AcadEditorPlugin.getPlugin().getString("GUESS_RULE_ACTION"));
        AcadEditorPluginImages.setImageDescriptors((IAction)this.guessRuleAction, "lcl16", "guess_rule_exec.gif");
        this.eventsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LogView.this.updateActionEnablement();
            }
        });
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.refreshAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.firstEventAction);
        mgr.add((IAction)this.previousEventAction);
        mgr.add((IAction)this.nextEventAction);
        mgr.add((IAction)this.lastEventAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.showLog);
        mgr.add((IAction)this.showPreferenceAction);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LogView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.eventsViewer.getControl());
        this.eventsViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.eventsViewer);
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectAllAction);
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.guessRuleAction);
        this.eventsViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && LogView.this.guessRuleAction.isEnabled()) {
                    LogView.this.guessRuleAction.run();
                }
            }
        });
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    private void updateActionEnablement() {
        TextSelection sel = (TextSelection)this.eventsViewer.getSelection();
        this.createRuleAction.setEnabled(!sel.isEmpty());
        this.guessRuleAction.setEnabled(!sel.isEmpty());
    }

    private void showNextEvent() {
        ResultView resultsView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry result = AcadGuiModelManager.getCurrentModel().getNextEvent();
        if (result == null) {
            this.set_Title();
            this.enableActions();
            result = AcadGuiModelManager.getCurrentModel().getPreviousEvent();
            return;
        }
        String extractorOutput = ((MessageString)result.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(extractorOutput));
        if (result.formatterOutput != null && (resultsView = ResultView.getResultView(true)) != null) {
            resultsView.setResult(((ISerializableAsXml)result.formatterOutput).externalizeCanonicalXmlString());
        }
        this.set_Title();
        this.enableActions();
        ContentView contentView = ContentView.getContentView(false);
        if (contentView != null) {
            contentView.showLog();
        }
    }

    private void showPreviousEvent() {
        ResultView resultsView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry result = AcadGuiModelManager.getCurrentModel().getPreviousEvent();
        String extractorOutput = ((MessageString)result.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(extractorOutput));
        if (result.formatterOutput != null && (resultsView = ResultView.getResultView(true)) != null) {
            resultsView.setResult(((ISerializableAsXml)result.formatterOutput).externalizeCanonicalXmlString());
        }
        this.set_Title();
        this.enableActions();
    }

    protected void refreshData() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
                if (model != null) {
                    model.loadTemplateFile();
                }
            }
        });
    }

    public void set_Title() {
        ResultView resultView;
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        StringBuffer title = new StringBuffer(this.LOG_TITLE).append(" ");
        if (model != null) {
            long currentEvent = model.getCurrentCount();
            currentEvent = currentEvent >= 0L ? ++currentEvent : 0L;
            long l = currentEvent = currentEvent > model.getEventCount() ? currentEvent - 1L : currentEvent;
            if (model.getContextInstance() == null || model.getContextInstance().eContainer() == null) {
                title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_EXTRACTOR"));
            } else {
                SensorConfigType sensor = AcadGuiModelManager.getLogForConfiguration(model);
                if (sensor != null) {
                    PropertyType fileName = AcadGuiModel.getProperty(sensor, "fileName");
                    PropertyType directory = AcadGuiModel.getProperty(sensor, "directory");
                    if (fileName != null && directory != null) {
                        title.append(directory.getPropertyValue()).append(File.separator).append(fileName.getPropertyValue());
                    } else {
                        title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                    }
                    String msg = AcadEditorPlugin.getPlugin().getString("STR_LOG_TITLE", new Object[]{String.valueOf(currentEvent), String.valueOf(model.getEventCount())});
                    title.append(" ").append(msg);
                } else {
                    title.append(AcadEditorPlugin.getPlugin().getString("STR_NO_SENSOR"));
                }
            }
        }
        super.setTitle(title.toString());
        ContentView contentView = ContentView.getContentView(false);
        if (contentView != null) {
            contentView.set_Title();
        }
        if ((resultView = ResultView.getResultView(false)) != null) {
            resultView.set_Title();
        }
    }

    public boolean openSetStartRecordDlg() {
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        if (model == null) {
            return false;
        }
        SetStartRecordDlg dialog = new SetStartRecordDlg(Display.getDefault().getActiveShell(), model.getStartRecord());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            model.setStartRecord(dialog.getRecordNumber());
            return true;
        }
        this.set_Title();
        this.enableActions();
        return false;
    }

    public void showFirstEvent() {
        ResultView resultsView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry result = AcadGuiModelManager.getCurrentModel().getFirstEvent();
        String extractorOutput = ((MessageString)result.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(extractorOutput));
        if (result.formatterOutput != null && (resultsView = ResultView.getResultView(true)) != null) {
            resultsView.setResult(((ISerializableAsXml)result.formatterOutput).externalizeCanonicalXmlString());
        }
        this.set_Title();
        this.enableActions();
    }

    private void showLastEvent() {
        ResultView resultsView;
        if (AcadGuiModelManager.getCurrentModel() == null) {
            return;
        }
        ResultQueueEntry result = AcadGuiModelManager.getCurrentModel().getLastEvent();
        String extractorOutput = ((MessageString)result.extractorOutput).getValue();
        this.eventsViewer.setDocument((IDocument)new Document(extractorOutput));
        if (result.formatterOutput != null && (resultsView = ResultView.getResultView(true)) != null) {
            resultsView.setResult(((ISerializableAsXml)result.formatterOutput).externalizeCanonicalXmlString());
        }
        this.set_Title();
        this.enableActions();
    }

    private void createRule() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)AcadEditorPlugin.getPlugin().getString("STR_GLA_MESSAGE"), (String)AcadEditorPlugin.getPlugin().getString("STR_NOT_IMPLEMENTED"));
    }

    private void guessRule() {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)AcadEditorPlugin.getPlugin().getString("STR_GLA_MESSAGE"), (String)AcadEditorPlugin.getPlugin().getString("STR_NOT_IMPLEMENTED"));
    }

    public void dispose() {
        super.dispose();
    }

    public void setContent(String content) {
        if (this.eventsViewer != null) {
            this.eventsViewer.setDocument((IDocument)new Document(content));
        }
    }

    public String getText() {
        return ((StyledText)this.eventsViewer.getControl()).getText();
    }

    public static final LogView getLogView(boolean show) {
        try {
            IWorkbenchPage page = AcadEditorPlugin.getDefault().getActivePage();
            if (page == null) {
                return null;
            }
            IViewPart view = page.findView("org.eclipse.hyades.logging.adapter.ui.views.logview");
            if (view != null) {
                if (show) {
                    page.showView("org.eclipse.hyades.logging.adapter.ui.views.logview");
                }
            } else if (show) {
                page.showView("org.eclipse.hyades.logging.adapter.ui.views.logview");
            }
            if (view instanceof LogView) {
                page.addPartListener((IPartListener)((LogView)view));
                return (LogView)view;
            }
        }
        catch (Exception exc) {
            return null;
        }
        return null;
    }

    public void reset() {
        ContentView contentView;
        this.setContent("");
        ResultView resultView = ResultView.getResultView(false);
        if (resultView != null) {
            resultView.reset();
        }
        if ((contentView = ContentView.getContentView(false)) != null) {
            contentView.reset();
        }
    }

    public Action getCreateRuleAction() {
        return this.createRuleAction;
    }

    public void enableActions() {
        AcadGuiModel model = AcadGuiModelManager.getCurrentModel();
        if (model == null || model.getContextInstance() == null) {
            this.previousEventAction.setEnabled(false);
            this.nextEventAction.setEnabled(false);
            this.firstEventAction.setEnabled(false);
            this.lastEventAction.setEnabled(false);
            this.createRuleAction.setEnabled(false);
            this.refreshAction.setEnabled(false);
            this.showLog.setEnabled(false);
            return;
        }
        this.refreshAction.setEnabled(true);
        this.firstEventAction.setEnabled(model.getEventCount() > 0L);
        this.lastEventAction.setEnabled(model.getEventCount() > 0L);
        this.createRuleAction.setEnabled(true);
        this.showLog.setEnabled(true);
        this.previousEventAction.setEnabled(model.hasPrevious());
        this.nextEventAction.setEnabled(model.hasNext());
    }

    protected void enableEditActions() {
        ActionHandlerListener.DEFAULT.connectPart((IWorkbenchPart)this);
    }

    protected void showLog() {
        ContentView view = ContentView.getContentView(true);
        if (view != null) {
            view.showLog();
        }
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        boolean rc;
        if (part instanceof AdaptorEditor && (rc = AcadGuiModelManager.isCurrentModel(((AdaptorEditor)part).getFile()))) {
            super.setTitle(this.LOG_TITLE);
            this.setContent("");
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    class SetStartRecordDlg
    extends Dialog
    implements ModifyListener {
        protected int _recordNb;
        protected Text _recordText;

        public SetStartRecordDlg(Shell shell, int recordNb) {
            super(shell);
            this._recordNb = recordNb;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(AcadEditorPlugin.getPlugin().getString("STR_SETSTART_ACTION"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.verticalSpacing = 10;
            layout.marginWidth = 10;
            result.setLayout((Layout)layout);
            GridData data = GridUtil.createFill();
            data.widthHint = 300;
            result.setLayoutData((Object)data);
            Label label = new Label(result, 64);
            label.setText(AcadEditorPlugin.getPlugin().getString("STR_SETSTART_DESC"));
            data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 280;
            label.setLayoutData((Object)data);
            label = new Label(result, 0);
            label.setText(AcadEditorPlugin.getPlugin().getString("STR_REC_NUMBER"));
            this._recordText = new Text(result, 2048);
            this._recordText.setLayoutData((Object)GridUtil.createHorizontalFill());
            this._recordText.addModifyListener((ModifyListener)this);
            this._recordText.setText(String.valueOf(this._recordNb));
            return result;
        }

        public void modifyText(ModifyEvent e) {
            if (e.widget == this._recordText && this.getButton(0) != null) {
                this.getButton(0).setEnabled(this._recordText.getText().trim() != "");
            }
        }

        protected void okPressed() {
            try {
                this._recordNb = Integer.parseInt(this._recordText.getText().trim());
            }
            catch (NumberFormatException exc) {
                this._recordNb = 1;
            }
            super.okPressed();
        }

        public int getRecordNumber() {
            return this._recordNb;
        }
    }
}

