/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.Vector;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ControlTableListener;
import org.eclipse.hyades.statistical.ui.variableloader.internal.SDModifiableVariableRepresentation;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.TableAdapter;
import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.ZoomControlBar;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ControlTable
extends TableAdapter
implements SelectionListener,
FocusListener {
    public static final int VAL_CONTROL = 0;
    public static final int VAL_NAME = 1;
    public static final int VAL_DESC = 2;
    public static final int VAL_IMAGE = 3;
    public static final int VAL_SLIDER = 4;
    public static final int VAL_MODIFY = 5;
    public static final int COL_NAME = 0;
    public static final int COL_DESC = 1;
    public static final int COL_IMAGE = 2;
    public static final int COL_SLIDER = 3;
    public static final int COL_MODIFY = 4;
    private Vector datas = new Vector();
    private Vector listeners = new Vector();
    private Integer[] sliderChoices = new Integer[]{new Integer(1)};
    private String[] sliderChoicesString = new String[]{"1"};
    boolean has_focus = false;

    public void addListener(ControlTableListener newListener) {
        this.listeners.add(newListener);
    }

    public void notifyListenersEdit(ZoomControlBar b) {
        if (b != null) {
            int v = 0;
            while (v < this.listeners.size()) {
                ControlTableListener TCL = (ControlTableListener)this.listeners.elementAt(v);
                TCL.barEdited(b);
                ++v;
            }
        }
    }

    public void notifyListenersSelect(SDModifiableVariableRepresentation g) {
        int v = 0;
        while (v < this.listeners.size()) {
            ControlTableListener TCL = (ControlTableListener)this.listeners.elementAt(v);
            TCL.barSelected(g);
            ++v;
        }
    }

    public ControlTable(Composite parent) {
        super(parent);
        String[] names = new String[]{EditorPlugin.getString("TABLE_COLUMN_NAME"), EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"), EditorPlugin.getString("TABLE_COLUMN_IMAGE"), EditorPlugin.getString("TABLE_COLUMN_SLIDER"), EditorPlugin.getString("TABLE_COLUMN_VALUE")};
        int[] types = new int[]{0, 0, 0, 2, 1};
        this.setColumnNames(names);
        this.setColumnTypes(types);
        this.autoSizeOnContents = new boolean[]{true, false, false, true, true};
        this.columnExpands = new boolean[]{true, false, false, true, true};
        this.configure();
        this.getViewer().getTable().addFocusListener((FocusListener)this);
        this.getViewer().getTable().addSelectionListener((SelectionListener)this);
    }

    public void ensureControlsValid() {
        int i = 0;
        while (i < this.datas.size()) {
            BarElement element = (BarElement)this.datas.get(i);
            if (element.slider >= this.sliderChoices.length) {
                element.slider = new Integer(0);
            }
            ++i;
        }
        this.configure();
    }

    public void setSliderChoices(Integer[] values, String[] names) {
        this.sliderChoices = values;
        this.sliderChoicesString = names;
        this.ensureControlsValid();
        this.redraw();
    }

    public Object[] getElements(Object inputObject) {
        return this.datas.toArray();
    }

    public void setSelectedIndex(int i) {
        this.getViewer().getTable().setFocus();
        this.getViewer().getTable().setSelection(i);
        this.getViewer().getTable().showSelection();
        this.getViewer().getTable().redraw();
    }

    public void setControlValues(Object[][] values) {
        int i = 0;
        while (i < this.datas.size()) {
            try {
                BarElement ge = (BarElement)this.datas.get(i);
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        this.datas.clear();
        int i2 = 0;
        while (i2 < values.length) {
            this.datas.add(new BarElement((ZoomControlBar)values[i2][0], (String)values[i2][1], (String)values[i2][2], (Image)values[i2][3], (Integer)values[i2][4], (SDModifiableVariableRepresentation)values[i2][5]));
            ++i2;
        }
        this.configure();
    }

    public Object[][] getControlValues() {
        Object[][] result = new Object[this.datas.size()][6];
        int v = 0;
        while (v < this.datas.size()) {
            result[v][0] = ((BarElement)this.datas.get((int)v)).bar;
            result[v][1] = ((BarElement)this.datas.get((int)v)).name;
            result[v][2] = ((BarElement)this.datas.get((int)v)).description;
            result[v][3] = ((BarElement)this.datas.get((int)v)).image;
            result[v][4] = ((BarElement)this.datas.get((int)v)).slider;
            result[v][5] = ((BarElement)this.datas.get((int)v)).rep;
            ++v;
        }
        return result;
    }

    public String[] getComboChoices(Object element, int columnIndex) {
        BarElement el = (BarElement)element;
        if (columnIndex == 3) {
            return this.sliderChoicesString;
        }
        if (element == null) {
            return new String[]{"this is big enough"};
        }
        if (el.rep.getEnumerationValues() != null) {
            return el.rep.getEnumerationValues();
        }
        return new String[0];
    }

    public int getColumnType(Object element, int column) {
        BarElement el = (BarElement)element;
        if (column != 4) {
            return super.getColumnType(element, column);
        }
        if (el.rep.getModifierType() == 4) {
            return 2;
        }
        return 1;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        BarElement el = (BarElement)element;
        if (columnIndex == 2) {
            return el.image;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        BarElement el = (BarElement)element;
        if (columnIndex == 0) {
            return el.name;
        }
        if (columnIndex == 1) {
            return el.description;
        }
        if (columnIndex == 2) {
            return "";
        }
        if (columnIndex == 3) {
            int index = el.slider;
            if (index >= 0 && index < this.sliderChoicesString.length) {
                return this.sliderChoicesString[index];
            }
            return "error";
        }
        if (columnIndex == 4) {
            return "" + el.rep.getLastRequestedValue();
        }
        return "";
    }

    public void valueChanged(Object element, int column, String newValue) throws InvalidTableValueException {
        try {
            BarElement el = (BarElement)element;
            double d = Double.parseDouble(newValue);
            d = Math.min(d, el.rep.getMaxBound());
            d = Math.max(d, el.rep.getMinBound());
            el.rep.setRequestedValue(System.currentTimeMillis(), d);
            this.notifyListenersEdit(el.bar);
        }
        catch (Throwable e) {
            EditorPlugin.DBG.warning("invalid table value entered " + newValue);
            throw new InvalidTableValueException(e.toString());
        }
    }

    public void valueChanged(Object element, int column, Integer newValue) throws InvalidTableValueException {
        if (column == 3) {
            try {
                BarElement el = (BarElement)element;
                el.slider = this.sliderChoices[newValue];
                this.notifyListenersEdit(el.bar);
            }
            catch (Throwable e) {
                EditorPlugin.DBG.warning("invalid table value entered " + newValue);
                throw new InvalidTableValueException(e.toString());
            }
        }
        if (column == 4) {
            try {
                BarElement el = (BarElement)element;
                String s = el.rep.getEnumerationValues()[newValue];
                el.rep.setRequestedValue(System.currentTimeMillis(), s);
                this.notifyListenersEdit(el.bar);
            }
            catch (Throwable e) {
                EditorPlugin.DBG.warning("invalid table value entered " + newValue);
                throw new InvalidTableValueException(e.toString());
            }
        }
        this.configure();
    }

    public SDModifiableVariableRepresentation getSelectedRep() {
        if (!this.has_focus) {
            return null;
        }
        int n = this.getViewer().getTable().getSelectionIndex();
        if (n == -1) {
            return null;
        }
        BarElement element = (BarElement)this.datas.get(n);
        return element.rep;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        SDModifiableVariableRepresentation g = this.getSelectedRep();
        if (g != null) {
            this.notifyListenersSelect(g);
        }
    }

    public void focusLost(FocusEvent e) {
        this.has_focus = false;
    }

    public void focusGained(FocusEvent e) {
        this.has_focus = true;
    }

    public class BarElement {
        public ZoomControlBar bar;
        public String name;
        public String description;
        public Integer slider;
        public Image image;
        public SDModifiableVariableRepresentation rep;

        public BarElement(ZoomControlBar bar, String name, String description, Image image, Integer slider, SDModifiableVariableRepresentation rep) {
            this.bar = bar;
            this.name = name;
            this.description = description;
            this.image = image;
            this.slider = slider;
            this.rep = rep;
        }

        public void update() {
        }
    }
}

