/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.monitoractions.internal.email;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.InvalidDataException;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.email.EmailActionProvider;
import org.eclipse.hyades.statistical.ui.monitoractions.internal.email.EmailAlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertAction;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.AlertActionControl;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EmailControl
extends AlertActionControl
implements SelectionListener {
    EmailAlertAction action;
    String host = "mail";
    int port = 25;
    String sender;
    String recipients;
    String localhostDomain;
    Group sender_panel;
    Label sender_label;
    Text sender_address;
    Group recipient_panel;
    Label recipient_label;
    Text recipient_address;
    Group smtp_panel;
    Label smtp_host_label;
    Text smtp_host;
    Label smtp_port_label;
    Text smtp_port;
    Group domain_panel;
    Label domain_label;
    Text domain_address;
    Button defaults;

    public EmailControl(Composite c, EmailAlertAction action) {
        super(c, 0);
        this.action = action;
        this.initGraphics();
        this.initEventHandling();
        this.readFromAction(action);
    }

    private void initGraphics() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.sender_panel = new Group((Composite)this, 0);
        this.sender_panel.setLayout((Layout)new GridLayout(2, false));
        this.sender_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.sender_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SENDER_TITLE"));
        this.sender_label = new Label((Composite)this.sender_panel, 0);
        this.sender_label.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 1));
        this.sender_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SENDER"));
        this.sender_address = new Text((Composite)this.sender_panel, 2048);
        this.sender_address.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.recipient_panel = new Group((Composite)this, 0);
        this.recipient_panel.setLayout((Layout)new GridLayout(2, false));
        this.recipient_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.recipient_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_RECIPIENT_TITLE"));
        this.recipient_label = new Label((Composite)this.recipient_panel, 0);
        this.recipient_label.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 1));
        this.recipient_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_RECIPIENT"));
        this.recipient_address = new Text((Composite)this.recipient_panel, 2048);
        this.recipient_address.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.smtp_panel = new Group((Composite)this, 0);
        this.smtp_panel.setLayout((Layout)new GridLayout(2, false));
        this.smtp_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.smtp_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SMTP_TITLE"));
        this.smtp_host_label = new Label((Composite)this.smtp_panel, 0);
        this.smtp_host_label.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 1));
        this.smtp_host_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SMTPHOST"));
        this.smtp_host = new Text((Composite)this.smtp_panel, 2048);
        this.smtp_host.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.smtp_port_label = new Label((Composite)this.smtp_panel, 0);
        this.smtp_port_label.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 1));
        this.smtp_port_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_SMTPPORT"));
        this.smtp_port = new Text((Composite)this.smtp_panel, 2048);
        this.smtp_port.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.domain_panel = new Group((Composite)this, 0);
        this.domain_panel.setLayout((Layout)new GridLayout(2, false));
        this.domain_panel.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.domain_panel.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_DOMAIN_TITLE"));
        this.domain_label = new Label((Composite)this.domain_panel, 0);
        this.domain_label.setLayoutData((Object)GData.getGridData(false, false, -1, -1, 1, 1, 1, 1));
        this.domain_label.setText(EditorPlugin.getString("ALERT_ACTION_EMAIL_DOMAIN"));
        this.domain_address = new Text((Composite)this.domain_panel, 2048);
        this.domain_address.setLayoutData((Object)GData.getGridData(true, false, -1, -1, 1, 1, 4, 4));
        this.defaults = new Button((Composite)this, 0);
        this.defaults.setText(EditorPlugin.getString("RESTORE_DEFAULTS"));
    }

    void setDefaultsButtonOn(boolean on) {
        if (!on) {
            try {
                this.defaults.dispose();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.layout(true);
            this.redraw();
        }
    }

    public void restoreDefaults() {
        EmailActionProvider provider = new EmailActionProvider();
        this.readFromAction(provider.fromPreferenceStore(EditorPlugin.getDefault().getPreferenceStore()));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Object o = e.getSource();
        if (o == this.defaults) {
            this.restoreDefaults();
        }
    }

    private void initEventHandling() {
        this.defaults.addSelectionListener((SelectionListener)this);
    }

    public void readFromAction(AlertAction tmp) {
        EmailAlertAction eaction = (EmailAlertAction)tmp;
        this.sender_address.setText(eaction.sender);
        this.recipient_address.setText(eaction.recipients);
        this.smtp_host.setText(eaction.host);
        this.smtp_port.setText("" + eaction.port);
        this.domain_address.setText(eaction.localhostDomain);
    }

    public void writeToAction(AlertAction tmp) throws InvalidDataException {
        String sender = this.sender_address.getText();
        if (sender.length() == 0) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_SENDER"));
        }
        if (sender.indexOf(64) == -1) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_SENDER"));
        }
        String recipient = this.recipient_address.getText();
        if (recipient.length() == 0) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_RECIPIENT"));
        }
        if (recipient.indexOf(64) == -1) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_RECIPIENT"));
        }
        String host = this.smtp_host.getText();
        if (host.length() == 0) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_HOST"));
        }
        String portstr = this.smtp_port.getText();
        if (portstr.length() == 0) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_PORT"));
        }
        int port = 0;
        try {
            port = Integer.parseInt(portstr);
        }
        catch (Exception e) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_PORT"));
        }
        if (port < 1 || port > 65535) {
            throw new InvalidDataException(EditorPlugin.getString("ERROR_ALERT_EMAIL_PORT"));
        }
        String domain = this.domain_address.getText();
        EmailAlertAction eaction = (EmailAlertAction)tmp;
        eaction.sender = sender;
        eaction.recipients = recipient;
        eaction.host = host;
        eaction.port = port;
        eaction.localhostDomain = domain;
    }

    public AlertAction writeToClonedAction() throws InvalidDataException {
        EmailAlertAction clone = (EmailAlertAction)this.action.clone();
        this.writeToAction(clone);
        return clone;
    }

    public AlertAction writeToOriginalAction() throws InvalidDataException {
        this.writeToAction(this.action);
        return this.action;
    }

    public String getDescription() {
        return EditorPlugin.getString("ALERT_ACTION_NAME_EMAIL");
    }
}

