/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.Iterator;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractProfileActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate,
ISelectionListener {
    private IAction fAction;
    private IViewPart fViewPart;
    private IStructuredSelection fSelection;
    private boolean fInitialized = false;

    public void dispose() {
        UIPlugin.getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer", (ISelectionListener)this);
        this.fAction = null;
        this.fViewPart = null;
        this.fSelection = null;
    }

    public void init(IWorkbenchWindow window) {
        window.getSelectionService().addSelectionListener("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer", (ISelectionListener)this);
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        final Iterator iterator = selection.iterator();
        String pluginId = "org.eclipse.hyades.trace.ui";
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    try {
                        AbstractProfileActionDelegate.this.doAction(element);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean wasInitialized = this.initialize(action, s);
        if (!wasInitialized && this.getView() != null) {
            this.update(action, s);
        }
    }

    protected void update(IAction action, ISelection s) {
        if (action == null || s == null) {
            return;
        }
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            action.setEnabled(this.getEnableStateForSelection(ss));
            this.setSelection(ss);
        } else {
            action.setEnabled(false);
            this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        }
    }

    protected boolean getEnableStateForSelection(IStructuredSelection selection) {
        if (selection.size() == 0) {
            return false;
        }
        Iterator iterator = selection.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            if (++count > 1 && !this.enableForMultiSelection()) {
                return false;
            }
            Object element = iterator.next();
            if (this.isEnabledFor(element)) continue;
            return false;
        }
        return true;
    }

    protected boolean enableForMultiSelection() {
        return true;
    }

    protected abstract void doAction(Object var1) throws Exception;

    protected abstract boolean isEnabledFor(Object var1);

    public void init(IViewPart view) {
        this.fViewPart = view;
    }

    protected IViewPart getView() {
        return this.fViewPart;
    }

    protected boolean initialize(IAction action, ISelection selection) {
        if (!this.isInitialized()) {
            this.setAction(action);
            this.update(action, selection);
            this.setInitialized(true);
            return true;
        }
        return false;
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }

    private void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.update(this.getAction(), selection);
    }

    protected void setView(IViewPart viewPart) {
        this.fViewPart = viewPart;
    }

    protected boolean isInitialized() {
        return this.fInitialized;
    }

    protected void setInitialized(boolean initialized) {
        this.fInitialized = initialized;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }
}

