/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileAttachDelegate;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.hyades.trace.ui.internal.util.CTree;
import org.eclipse.hyades.trace.ui.internal.util.ErrorItem;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;
import org.eclipse.hyades.trace.ui.internal.util.ProfilingProcessList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DoubleCTree
extends AbstractChangeable {
    Composite _group;
    Composite groupWidget;
    private CTree sourceList;
    private CTree targetList;
    private ProfilingProcessList sourceProcessList = new ProfilingProcessList();
    private ProfilingProcessList targetProcessList = new ProfilingProcessList();
    private boolean _needToResetAgentLists = false;
    private boolean _treesLoaded = false;
    public Label targetListLabel;
    public Label sourceListLabel;
    public Button add;
    public Button remove;
    public Button addAll;
    public Button removeAll;
    private WizardPage _wizardPage;
    private ILaunchConfiguration _conf;

    private boolean isRetrievingList() {
        Object[] items = this.sourceList.getItems();
        if (items.length == 0) {
            return false;
        }
        return items[0] instanceof IWorkbenchAdapter;
    }

    protected void addAgentsToTargetList(Object[] items) {
        ProcessTreeItem pti;
        if (this.isRetrievingList()) {
            return;
        }
        if (this.sourceList.getItemCount() > 0 && (pti = (ProcessTreeItem)this.sourceList.getItems()[0]).getData() instanceof ErrorItem) {
            return;
        }
        this.targetList.setRedraw(false);
        this.sourceList.setRedraw(false);
        Vector<Object> dataToBeSelected = new Vector<Object>();
        int i = 0;
        while (i < items.length) {
            if (this.vaildItemtoAdd(items[i])) {
                dataToBeSelected.addElement(items[i]);
                this.targetProcessList.addProcess(items[i]);
                this.sourceProcessList.removeProcess(items[i]);
            }
            ++i;
        }
        this.sourceList.resetTree(this.sourceProcessList);
        this.targetList.resetTree(this.targetProcessList);
        this.sourceList.clearSelection();
        if (dataToBeSelected.size() > 0) {
            this.targetList.setSelectionFromData(dataToBeSelected.toArray());
        }
        this.targetList.setRedraw(true);
        this.sourceList.setRedraw(true);
        if (this._wizardPage != null && this.getSelectedItems().length > 0) {
            this._wizardPage.setPageComplete(true);
        }
    }

    protected void removeAgentsFromTargetList(Object[] items) {
        if (this.isRetrievingList()) {
            return;
        }
        this.targetList.setRedraw(false);
        this.sourceList.setRedraw(false);
        int i = 0;
        while (i < items.length) {
            this.targetProcessList.removeProcess(items[i]);
            this.sourceProcessList.addProcess(items[i]);
            ++i;
        }
        this.targetList.clearSelection();
        if (this._wizardPage != null && this.getSelectedItems().length > 0) {
            this._wizardPage.setPageComplete(true);
        }
        this.sourceList.resetTree(this.sourceProcessList);
        this.targetList.resetTree(this.targetProcessList);
        this.targetList.setRedraw(true);
        this.sourceList.setRedraw(true);
    }

    private boolean vaildItemtoAdd(Object item) {
        return item != null && !(item instanceof IWorkbenchAdapter);
    }

    public Object[] getTargetItems() {
        return this.targetList.getItems();
    }

    public void removeAll() {
        this.sourceProcessList.initializeFromProcesses(new Object[0]);
        this.targetProcessList.initializeFromProcesses(new Object[0]);
        this.sourceList.setRedraw(false);
        this.targetList.setRedraw(false);
        this.sourceList.resetTree(this.sourceProcessList);
        this.targetList.resetTree(this.targetProcessList);
        this.sourceList.setRedraw(true);
        this.targetList.setRedraw(true);
    }

    public void setWizardPage(WizardPage wizardPage) {
        this._wizardPage = wizardPage;
    }

    public DoubleCTree(Composite parent, int style, String groupText, String sourceTextID, String targetTextID) {
        this._group = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = -10;
        layout.horizontalSpacing = 0;
        this._group.setLayout((Layout)layout);
        this._group.setLayoutData((Object)GridUtil.createFill());
        this.createDoubleTree(this._group, sourceTextID, targetTextID);
        this.add.addListener(13, (Listener)new ButtonListener());
        this.remove.addListener(13, (Listener)new ButtonListener());
        this.addAll.addListener(13, (Listener)new ButtonListener());
        this.removeAll.addListener(13, (Listener)new ButtonListener());
        this.sourceList.addSelectionListener(new TreeSelListener());
        this.targetList.addSelectionListener(new TreeSelListener());
    }

    public void createDoubleTree(Composite parent, String sourceTextID, String targetTextID) {
        this._conf = null;
        this.groupWidget = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.groupWidget.setLayout((Layout)layout);
        this.sourceList = new CTree(this.groupWidget, sourceTextID);
        Composite buttonWidget = new Composite(this.groupWidget, 0);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout((Layout)blayout);
        Label label = new Label(buttonWidget, 8);
        label.setText("");
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.add = new Button(buttonWidget, 8);
        this.add.setText(UIPlugin.getResourceString("LEFT_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.add.setLayoutData((Object)spec);
        this.remove = new Button(buttonWidget, 8);
        this.remove.setText(UIPlugin.getResourceString("RIGHT_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.remove.setLayoutData((Object)spec);
        new Label(buttonWidget, 0);
        this.addAll = new Button(buttonWidget, 8);
        this.addAll.setText(UIPlugin.getResourceString("LEFT_ALL_TO_RIGHT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.addAll.setLayoutData((Object)spec);
        this.removeAll = new Button(buttonWidget, 8);
        this.removeAll.setText(UIPlugin.getResourceString("RIGHT_ALL_TO_LEFT"));
        spec = new GridData();
        spec.horizontalAlignment = 4;
        this.removeAll.setLayoutData((Object)spec);
        Label label1 = new Label(buttonWidget, 8);
        label1.setText("");
        spec = new GridData();
        spec.grabExcessVerticalSpace = true;
        spec.verticalAlignment = 4;
        label.setLayoutData((Object)spec);
        this.targetList = new CTree(this.groupWidget, targetTextID);
        this.sourceList.setUIListener(new TreeUpdatedListener());
        this.targetList.setUIListener(new TreeUpdatedListener());
    }

    public Control getControl() {
        return this._group;
    }

    public Object[] getSelectedItems() {
        return this.targetList.getSelectedItems();
    }

    public Object[] getSelectedItemsForProfiling() {
        return this.targetList.getItems();
    }

    public Composite getWidget() {
        return this.groupWidget;
    }

    public void initializeLaunchConfiguration(ILaunchConfiguration conf) {
        this._conf = conf;
    }

    public void initialize() {
        this.sourceList.initializeTree(this._conf);
        this.sourceProcessList.initializeFromProcesses(this.sourceList.getItems());
        this.targetProcessList.initializeFromProcesses(this.targetList.getItems());
        this._needToResetAgentLists = true;
    }

    private boolean listContains(Object[] objects, Object obj) {
        int i = 0;
        while (i < objects.length) {
            if (obj.equals(objects[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public List getAttributeProcesses() {
        if (this._conf != null) {
            try {
                return ProfileAttachDelegate.getAttributeProcesses(this._conf);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new ArrayList();
    }

    private Object[] getTargetPIDList() {
        if (this.treesLoaded()) {
            return this.targetProcessList.getPIDs();
        }
        return ProfileAttachDelegate.createMap(this.getAttributeProcesses()).keySet().toArray();
    }

    private Object[] getTargetSelectedPIDList() {
        if (this.treesLoaded()) {
            ProfilingProcessList selectedAgents = new ProfilingProcessList();
            selectedAgents.initializeFromProcesses(this.getSelectedItems());
            return selectedAgents.getPIDs();
        }
        return ProfileAttachDelegate.createMap(this.getAttributeProcesses()).keySet().toArray();
    }

    public boolean treesLoaded() {
        return this._treesLoaded;
    }

    public void resetAgentLists() {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this._needToResetAgentLists && (this.sourceList.getItemCount() == 0 || !this.isRetrievingList())) {
            ProcessTreeItem pti;
            this._needToResetAgentLists = false;
            this.sourceProcessList.initializeFromProcesses(this.sourceList.getItems());
            if (this.sourceList.getItemCount() > 0 && (pti = (ProcessTreeItem)this.sourceList.getItems()[0]).getData() instanceof ErrorItem) {
                this.targetProcessList.initializeFromProcesses(new Object[0]);
                this.targetList.resetTree(this.targetProcessList);
                return;
            }
            Object[] PIDList = this.getTargetPIDList();
            Object[] selectedPIDList = this.getTargetSelectedPIDList();
            if (PIDList.length > 0) {
                Vector<Object> processesInTarget = new Vector<Object>();
                Vector<Object> dataToBeSelected = new Vector<Object>();
                int i = 0;
                while (i < PIDList.length) {
                    Object agentFromSource = this.sourceProcessList.getProcessForPID(PIDList[i].toString());
                    if (agentFromSource != null) {
                        processesInTarget.addElement(agentFromSource);
                        this.sourceProcessList.removeProcess(agentFromSource);
                        if (this.listContains(selectedPIDList, PIDList[i].toString())) {
                            dataToBeSelected.addElement(agentFromSource);
                        }
                    }
                    ++i;
                }
                this.targetProcessList.initializeFromProcesses(processesInTarget.toArray());
                this.sourceList.setRedraw(false);
                this.targetList.setRedraw(false);
                this.sourceList.resetTree(this.sourceProcessList);
                this.targetList.resetTree(this.targetProcessList);
                if (dataToBeSelected.size() > 0) {
                    this.targetList.setSelectionFromData(dataToBeSelected.toArray());
                }
                this.sourceList.setRedraw(true);
                this.targetList.setRedraw(true);
            }
            this._treesLoaded = true;
            this.changed();
        }
    }

    class ButtonListener
    implements Listener {
        ButtonListener() {
        }

        public void handleEvent(Event e) {
            DoubleCTree.this.sourceProcessList.initializeFromProcesses(DoubleCTree.this.sourceList.getItems());
            if (e.widget == DoubleCTree.this.add) {
                DoubleCTree.this.addAgentsToTargetList(DoubleCTree.this.sourceList.getSelectedItems());
            } else if (e.widget == DoubleCTree.this.addAll) {
                DoubleCTree.this.addAgentsToTargetList(DoubleCTree.this.sourceList.getItems());
            } else if (e.widget == DoubleCTree.this.remove) {
                DoubleCTree.this.removeAgentsFromTargetList(DoubleCTree.this.targetList.getSelectedItems());
            } else if (e.widget == DoubleCTree.this.removeAll) {
                DoubleCTree.this.removeAgentsFromTargetList(DoubleCTree.this.targetList.getItems());
            }
            DoubleCTree.this.changed();
        }
    }

    class TreeSelListener
    implements SelectionListener {
        TreeSelListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            DoubleCTree.this.sourceProcessList.initializeFromProcesses(DoubleCTree.this.sourceList.getItems());
            if (DoubleCTree.this.sourceList.hasWidget(e.widget) && DoubleCTree.this.sourceList.getSelectedItems().length != 0) {
                DoubleCTree.this.targetList.clearSelection();
            } else if (DoubleCTree.this.targetList.hasWidget(e.widget) && DoubleCTree.this.targetList.getSelectedItems().length != 0) {
                DoubleCTree.this.sourceList.clearSelection();
            }
            DoubleCTree.this.changed();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object[] items;
            DoubleCTree.this.sourceProcessList.initializeFromProcesses(DoubleCTree.this.sourceList.getItems());
            if (DoubleCTree.this.sourceList.hasWidget(e.widget)) {
                Object[] items2 = DoubleCTree.this.sourceList.getSelectedItems();
                if (items2.length > 0) {
                    DoubleCTree.this.addAgentsToTargetList(items2);
                    DoubleCTree.this.changed();
                }
            } else if (DoubleCTree.this.targetList.hasWidget(e.widget) && (items = DoubleCTree.this.targetList.getSelectedItems()).length > 0) {
                DoubleCTree.this.removeAgentsFromTargetList(items);
                DoubleCTree.this.changed();
            }
        }
    }

    class TreeUpdatedListener
    implements Listener {
        TreeUpdatedListener() {
        }

        public void handleEvent(Event event) {
            DoubleCTree.this.resetAgentLists();
        }
    }
}

