/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.ErrorItem;
import org.eclipse.swt.graphics.Image;

public class ProcessTreeItem
implements IAdaptable {
    private Object _adapter;
    private Object _data;
    private ProcessTreeItem _parent;

    public ProcessTreeItem(Object data, ProcessTreeItem parent) {
        this._data = data;
        this._parent = parent;
    }

    public Object getData() {
        return this._data;
    }

    public ProcessTreeItem getParent() {
        return this._parent;
    }

    public Object getAdapter(Class adapter) {
        return this._adapter;
    }

    public void setAdapter(Object adapter) {
        this._adapter = adapter;
    }

    public String getLabelText() {
        if (this._data == null) {
            return "";
        }
        if (this._data instanceof Process) {
            String text = ((Process)this._data).getName();
            if (text == null) {
                text = ((Process)this._data).getExecutable();
            }
            try {
                text = text + "[" + UIPlugin.getResourceString("PROCESS_ID") + ":" + ((Process)this._data).getProcessId() + "]";
            }
            catch (InactiveProcessException exc) {
                // empty catch block
            }
            return text;
        }
        if (this._data instanceof Agent) {
            return ((Agent)this._data).getName();
        }
        if (this._data instanceof ErrorItem) {
            return ((ErrorItem)this._data).getMessage();
        }
        return "";
    }

    public Image getImage() {
        if (this._data == null) {
            return null;
        }
        if (this._data instanceof Process) {
            return PDPluginImages.getImage("process_obj.gif");
        }
        if (this._data instanceof Agent) {
            return PDPluginImages.getImage("agent_detach_obj.gif");
        }
        if (this._data instanceof ErrorItem) {
            return PDPluginImages.getImage("error_tsk.gif");
        }
        return null;
    }
}

