/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.events.cbe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.AvailableSituation;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.ConnectSituation;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.CreateSituation;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.OtherSituation;
import org.eclipse.hyades.logging.events.cbe.ReportSituation;
import org.eclipse.hyades.logging.events.cbe.RequestSituation;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.StartSituation;
import org.eclipse.hyades.logging.events.cbe.StopSituation;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;
import org.eclipse.hyades.logging.events.cbe.util.SAXEventHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class EventFormatter {
    private static final String COMMON_BASE_EVENT_SCHEMA_NAME = "commonbaseevent1_0_1.xsd";
    private static final String COMMON_BASE_EVENT_SCHEMA_LOCATION_URL = EventFormatter.resolveCommonBaseEventSchemaLocation();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static synchronized String toCanonicalXMLDocString(AssociationEngine associationEngine) {
        return EventFormatter.toCanonicalXMLDocString(associationEngine, true);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngine[] associationEngineArray) {
        return EventFormatter.toCanonicalXMLDocString(associationEngineArray, true);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngine associationEngine, boolean bl) {
        return EventFormatter.toCanonicalXMLDocString(new AssociationEngine[]{associationEngine}, bl);
    }

    public static synchronized String toCanonicalXMLDocString(AssociationEngine[] associationEngineArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append("\t");
        }
        if (associationEngineArray != null) {
            int n = 0;
            while (n < associationEngineArray.length) {
                stringBuffer.append(EventFormatter.toCanonicalXMLString(associationEngineArray[n]));
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                }
                ++n;
            }
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized String toCanonicalXMLString(AssociationEngine associationEngine) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("<AssociationEngine");
        String string = associationEngine.getId();
        if (string != null) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = associationEngine.getName()) != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = associationEngine.getType()) != null) {
            stringBuffer.append(" type=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLDocString(AssociationEngine associationEngine, String string) {
        try {
            AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(string);
            if (associationEngine != null && associationEngineArray != null && associationEngineArray[0] != null) {
                associationEngine.setId(associationEngineArray[0].getId());
                associationEngine.setName(associationEngineArray[0].getName());
                associationEngine.setType(associationEngineArray[0].getType());
            } else {
                associationEngine = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(String string) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(string, false);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(String string, boolean bl) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new StringReader(string)), bl);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputSource inputSource) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(inputSource, false);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputSource inputSource, boolean bl) throws FormattingException {
        return EventFormatter.parse(inputSource, bl).getAssociationEngines();
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputStream inputStream) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(inputStream, false);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(InputStream inputStream, boolean bl) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(inputStream), bl);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(Document document) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(document, false);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(Document document, boolean bl) throws FormattingException {
        try {
            return EventFormatter.associationEnginesFromCanonicalXMLDoc(XmlUtility.serialize((Document)document), bl);
        }
        catch (SerializationException serializationException) {
            throw new FormattingException((Exception)((Object)serializationException));
        }
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(File file) throws FormattingException {
        return EventFormatter.associationEnginesFromCanonicalXMLDoc(file, false);
    }

    public static synchronized AssociationEngine[] associationEnginesFromCanonicalXMLDoc(File file, boolean bl) throws FormattingException {
        try {
            return EventFormatter.associationEnginesFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FormattingException(fileNotFoundException);
        }
    }

    public static synchronized void fromCanonicalXMLString(AssociationEngine associationEngine, String string) {
        try {
            AssociationEngine associationEngine2 = EventFormatter.associationEngineFromCanonicalXML(string);
            if (associationEngine != null && associationEngine2 != null) {
                associationEngine.setId(associationEngine2.getId());
                associationEngine.setName(associationEngine2.getName());
                associationEngine.setType(associationEngine2.getType());
            } else {
                associationEngine = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized AssociationEngine associationEngineFromCanonicalXML(String string) throws FormattingException {
        return EventFormatter.associationEngineFromCanonicalXML(string, false);
    }

    public static synchronized AssociationEngine associationEngineFromCanonicalXML(String string, boolean bl) throws FormattingException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        stringBuffer.append(string);
        stringBuffer.append("</CommonBaseEvents>");
        AssociationEngine[] associationEngineArray = EventFormatter.associationEnginesFromCanonicalXMLDoc(stringBuffer.toString(), bl);
        if (associationEngineArray != null) {
            return associationEngineArray[0];
        }
        return null;
    }

    public static synchronized String toCanonicalXMLDocString(CommonBaseEvent commonBaseEvent) {
        return EventFormatter.toCanonicalXMLDocString(commonBaseEvent, true);
    }

    public static synchronized String toCanonicalXMLDocString(CommonBaseEvent[] commonBaseEventArray) {
        return EventFormatter.toCanonicalXMLDocString(commonBaseEventArray, true);
    }

    public static synchronized String toCanonicalXMLDocString(CommonBaseEvent commonBaseEvent, boolean bl) {
        return EventFormatter.toCanonicalXMLDocString(new CommonBaseEvent[]{commonBaseEvent}, bl);
    }

    public static synchronized String toCanonicalXMLDocString(CommonBaseEvent[] commonBaseEventArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        if (commonBaseEventArray != null) {
            int n = 0;
            while (n < commonBaseEventArray.length) {
                Object object;
                EList eList = commonBaseEventArray[n].getAssociatedEvents();
                if (eList.size() > 0) {
                    object = null;
                    int n2 = 0;
                    while (n2 < eList.size()) {
                        object = ((AssociatedEvent)eList.get(n2)).getAssociationEngineInfo();
                        if (object != null) {
                            if (bl) {
                                stringBuffer.append("\t");
                            }
                            stringBuffer.append(EventFormatter.toCanonicalXMLString((AssociationEngine)object));
                            if (bl) {
                                stringBuffer.append(LINE_SEPARATOR);
                            }
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    object = new StringTokenizer(EventFormatter.toCanonicalXMLString(commonBaseEventArray[n], bl).trim(), LINE_SEPARATOR);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        stringBuffer.append("\t");
                        stringBuffer.append(((StringTokenizer)object).nextToken());
                        stringBuffer.append(LINE_SEPARATOR);
                    }
                } else {
                    stringBuffer.append(EventFormatter.toCanonicalXMLString(commonBaseEventArray[n], bl));
                }
                ++n;
            }
        }
        stringBuffer.append("</CommonBaseEvents>");
        return stringBuffer.toString();
    }

    public static synchronized String toCanonicalXMLString(CommonBaseEvent commonBaseEvent) {
        return EventFormatter.toCanonicalXMLString(commonBaseEvent, true);
    }

    public static synchronized String toCanonicalXMLString(CommonBaseEvent commonBaseEvent, boolean bl) {
        Object object;
        Situation situation;
        EObject eObject;
        Object object2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<CommonBaseEvent");
        if (commonBaseEvent.isSetCreationTime()) {
            stringBuffer.append(" creationTime=\"");
            stringBuffer.append(commonBaseEvent.getCreationTime());
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getExtensionName()) != null) {
            stringBuffer.append(" extensionName=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getGlobalInstanceId()) != null) {
            stringBuffer.append(" globalInstanceId=\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getLocalInstanceId()) != null) {
            stringBuffer.append(" localInstanceId=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getMsg()) != null) {
            stringBuffer.append(" msg=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetElapsedTime()) {
            stringBuffer.append(" elapsedTime=\"");
            stringBuffer.append(commonBaseEvent.getElapsedTime());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetPriority()) {
            stringBuffer.append(" priority=\"");
            stringBuffer.append(commonBaseEvent.getPriority());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetRepeatCount()) {
            stringBuffer.append(" repeatCount=\"");
            stringBuffer.append(commonBaseEvent.getRepeatCount());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetSequenceNumber()) {
            stringBuffer.append(" sequenceNumber=\"");
            stringBuffer.append(commonBaseEvent.getSequenceNumber());
            stringBuffer.append("\"");
        }
        if (commonBaseEvent.isSetSeverity()) {
            stringBuffer.append(" severity=\"");
            stringBuffer.append(commonBaseEvent.getSeverity());
            stringBuffer.append("\"");
        }
        if ((string = commonBaseEvent.getVersion()) != null) {
            stringBuffer.append(" version=\"");
            stringBuffer.append(XmlUtility.normalize((String)string));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        EList eList = commonBaseEvent.getContextDataElements();
        ContextDataElement contextDataElement = null;
        int n = 0;
        while (n < eList.size()) {
            contextDataElement = (ContextDataElement)eList.get(n);
            if (contextDataElement != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<contextDataElements");
                string = contextDataElement.getName();
                if (string != null) {
                    stringBuffer.append(" name=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                if ((string = contextDataElement.getType()) != null) {
                    stringBuffer.append(" type=\"");
                    stringBuffer.append(string);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                string = contextDataElement.getContextId();
                if (string != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<contextId>");
                    stringBuffer.append(string);
                    stringBuffer.append("</contextId>");
                } else {
                    string = contextDataElement.getContextValue();
                    if (string != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t");
                        }
                        stringBuffer.append("<contextValue>");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("</contextValue>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</contextDataElements>");
            }
            ++n;
        }
        EList eList2 = commonBaseEvent.getExtendedDataElements();
        int n2 = 0;
        while (n2 < eList2.size()) {
            stringBuffer.append(EventFormatter.getExtendedDataElementXML((ExtendedDataElement)eList2.get(n2), "extendedDataElements", bl, bl ? 1 : 0));
            ++n2;
        }
        EList eList3 = commonBaseEvent.getAssociatedEvents();
        AssociatedEvent associatedEvent = null;
        int n3 = 0;
        while (n3 < eList3.size()) {
            associatedEvent = (AssociatedEvent)eList3.get(n3);
            if (associatedEvent != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("<associatedEvents");
                object2 = associatedEvent.getResolvedEvents();
                if (object2 != null) {
                    stringBuffer.append(" resolvedEvents=\"");
                    stringBuffer.append((String)object2);
                    stringBuffer.append("\"");
                }
                stringBuffer.append(">");
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                if ((eObject = associatedEvent.getAssociationEngineInfo()) != null) {
                    stringBuffer.append("<associationEngineInfo");
                    stringBuffer.append(EventFormatter.toCanonicalXMLString((AssociationEngine)eObject).trim().substring(18));
                } else {
                    string = associatedEvent.getAssociationEngine();
                    if (string != null) {
                        stringBuffer.append("<associationEngine>");
                        stringBuffer.append(string);
                        stringBuffer.append("</associationEngine>");
                    }
                }
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append("</associatedEvents>");
            }
            ++n3;
        }
        object2 = commonBaseEvent.getReporterComponentId();
        if (object2 != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<reporterComponentId");
            string = object2.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            if ((string = object2.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getComponentType()) != null) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((object2 = commonBaseEvent.getSourceComponentId()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<sourceComponentId");
            string = object2.getApplication();
            if (string != null) {
                stringBuffer.append(" application=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getComponent()) != null) {
                stringBuffer.append(" component=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getComponentIdType()) != null) {
                stringBuffer.append(" componentIdType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getExecutionEnvironment()) != null) {
                stringBuffer.append(" executionEnvironment=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getInstanceId()) != null) {
                stringBuffer.append(" instanceId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getLocation()) != null) {
                stringBuffer.append(" location=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getLocationType()) != null) {
                stringBuffer.append(" locationType=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            if ((string = object2.getProcessId()) != null) {
                stringBuffer.append(" processId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getSubComponent()) != null) {
                stringBuffer.append(" subComponent=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getThreadId()) != null) {
                stringBuffer.append(" threadId=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            if ((string = object2.getComponentType()) != null) {
                stringBuffer.append(" componentType=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append("/>");
        }
        if ((eObject = commonBaseEvent.getMsgDataElement()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<msgDataElement");
            string = eObject.getMsgLocale();
            if (string != null) {
                stringBuffer.append(" msgLocale=\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            situation = eObject.getMsgCatalogTokens();
            object = null;
            int n4 = 0;
            while (n4 < situation.size()) {
                object = (MsgCatalogToken)situation.get(n4);
                if (object != null && object.getValue() != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("<msgCatalogTokens value=\"");
                    stringBuffer.append(XmlUtility.normalize((String)object.getValue()));
                    stringBuffer.append("\"/>");
                }
                ++n4;
            }
            string = eObject.getMsgId();
            if (string != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgId>");
            }
            if ((string = eObject.getMsgIdType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgIdType>");
                stringBuffer.append(string);
                stringBuffer.append("</msgIdType>");
            }
            if ((string = eObject.getMsgCatalogId()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogId>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalogId>");
            }
            if ((string = eObject.getMsgCatalogType()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalogType>");
                stringBuffer.append(string);
                stringBuffer.append("</msgCatalogType>");
            }
            if ((string = eObject.getMsgCatalog()) != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<msgCatalog>");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("</msgCatalog>");
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</msgDataElement>");
        }
        if ((situation = commonBaseEvent.getSituation()) != null) {
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("<situation");
            string = situation.getCategoryName();
            if (string != null) {
                stringBuffer.append(" categoryName=\"");
                stringBuffer.append(XmlUtility.normalize((String)string));
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            object = situation.getSituationType();
            if (object != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t\t");
                }
                stringBuffer.append("<situationType xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                string = object.getReasoningScope();
                if (object instanceof StartSituation) {
                    stringBuffer.append(" xsi:type=\"StartSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StartSituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StartSituation)object).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof StopSituation) {
                    stringBuffer.append(" xsi:type=\"StopSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StopSituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((StopSituation)object).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof ConnectSituation) {
                    stringBuffer.append(" xsi:type=\"ConnectSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ConnectSituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ConnectSituation)object).getSituationDisposition()) != null) {
                        stringBuffer.append(" situationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof ReportSituation) {
                    stringBuffer.append(" xsi:type=\"ReportSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ReportSituation)object).getReportCategory()) != null) {
                        stringBuffer.append(" reportCategory=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof FeatureSituation) {
                    stringBuffer.append(" xsi:type=\"FeatureSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((FeatureSituation)object).getFeatureDisposition()) != null) {
                        stringBuffer.append(" featureDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof ConfigureSituation) {
                    stringBuffer.append(" xsi:type=\"ConfigureSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((ConfigureSituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof DependencySituation) {
                    stringBuffer.append(" xsi:type=\"DependencySituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((DependencySituation)object).getDependencyDisposition()) != null) {
                        stringBuffer.append(" dependencyDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof CreateSituation) {
                    stringBuffer.append(" xsi:type=\"CreateSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((CreateSituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof DestroySituation) {
                    stringBuffer.append(" xsi:type=\"DestroySituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((DestroySituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof AvailableSituation) {
                    stringBuffer.append(" xsi:type=\"AvailableSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((AvailableSituation)object).getOperationDisposition()) != null) {
                        stringBuffer.append(" operationDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((AvailableSituation)object).getProcessingDisposition()) != null) {
                        stringBuffer.append(" processingDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((AvailableSituation)object).getAvailabilityDisposition()) != null) {
                        stringBuffer.append(" availabilityDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof RequestSituation) {
                    stringBuffer.append(" xsi:type=\"RequestSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((RequestSituation)object).getSuccessDisposition()) != null) {
                        stringBuffer.append(" successDisposition=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    if ((string = ((RequestSituation)object).getSituationQualifier()) != null) {
                        stringBuffer.append(" situationQualifier=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append("/>");
                } else if (object instanceof OtherSituation) {
                    stringBuffer.append(" xsi:type=\"OtherSituation\"");
                    if (string != null) {
                        stringBuffer.append(" reasoningScope=\"");
                        stringBuffer.append(XmlUtility.normalize((String)string));
                        stringBuffer.append("\"");
                    }
                    stringBuffer.append(">");
                    String string2 = ((OtherSituation)object).getAny();
                    if (string2 != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            stringBuffer.append("\t\t\t");
                        }
                        stringBuffer.append(string2);
                    }
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        stringBuffer.append("\t\t");
                    }
                    stringBuffer.append("</situationType>");
                } else {
                    stringBuffer.append("/>");
                }
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                stringBuffer.append("\t");
            }
            stringBuffer.append("</situation>");
        }
        object = commonBaseEvent.getAny();
        String string3 = null;
        int n5 = 0;
        while (n5 < object.size()) {
            string3 = (String)object.get(n5);
            if (string3 != null) {
                if (bl) {
                    stringBuffer.append(LINE_SEPARATOR);
                    stringBuffer.append("\t");
                }
                stringBuffer.append(string3);
            }
            ++n5;
        }
        if (bl) {
            stringBuffer.append(LINE_SEPARATOR);
        }
        stringBuffer.append("</CommonBaseEvent>");
        return stringBuffer.toString();
    }

    public static synchronized void fromCanonicalXMLDocString(CommonBaseEvent commonBaseEvent, String string) {
        try {
            CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(string);
            if (commonBaseEvent != null && commonBaseEventArray != null && commonBaseEventArray[0] != null) {
                TemplateContentHandlerImpl templateContentHandlerImpl = new TemplateContentHandlerImpl();
                templateContentHandlerImpl.setTemplateEvent(commonBaseEventArray[0]);
                commonBaseEvent.setContentHandler(templateContentHandlerImpl);
                commonBaseEvent.complete();
                commonBaseEvent.setContentHandler(null);
            } else {
                commonBaseEvent = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(String string) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(string, false);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(String string, boolean bl) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new StringReader(string)), bl);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(Document document) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(document, false);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(Document document, boolean bl) throws FormattingException {
        try {
            return EventFormatter.eventsFromCanonicalXMLDoc(XmlUtility.serialize((Document)document), bl);
        }
        catch (SerializationException serializationException) {
            throw new FormattingException((Exception)((Object)serializationException));
        }
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputSource inputSource) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(inputSource, false);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputSource inputSource, boolean bl) throws FormattingException {
        return EventFormatter.parse(inputSource, bl).getCommonBaseEvents();
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputStream inputStream) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(inputStream, false);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(InputStream inputStream, boolean bl) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(inputStream), bl);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(File file) throws FormattingException {
        return EventFormatter.eventsFromCanonicalXMLDoc(file, false);
    }

    public static synchronized CommonBaseEvent[] eventsFromCanonicalXMLDoc(File file, boolean bl) throws FormattingException {
        try {
            return EventFormatter.eventsFromCanonicalXMLDoc(new InputSource(new FileInputStream(file)), bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FormattingException(fileNotFoundException);
        }
    }

    public static synchronized void fromCanonicalXMLString(CommonBaseEvent commonBaseEvent, String string) {
        try {
            CommonBaseEvent commonBaseEvent2 = EventFormatter.eventFromCanonicalXML(string);
            if (commonBaseEvent != null && commonBaseEvent2 != null) {
                TemplateContentHandlerImpl templateContentHandlerImpl = new TemplateContentHandlerImpl();
                templateContentHandlerImpl.setTemplateEvent(commonBaseEvent2);
                commonBaseEvent.setContentHandler(templateContentHandlerImpl);
                commonBaseEvent.complete();
                commonBaseEvent.setContentHandler(null);
            } else {
                commonBaseEvent = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized CommonBaseEvent eventFromCanonicalXML(String string) throws FormattingException {
        return EventFormatter.eventFromCanonicalXML(string, false);
    }

    public static synchronized CommonBaseEvent eventFromCanonicalXML(String string, boolean bl) throws FormattingException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuffer.append("<CommonBaseEvents xmlns=\"http://www.ibm.com/AC/commonbaseevent1_0_1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.ibm.com/AC/commonbaseevent1_0_1 commonbaseevent1_0_1.xsd\">");
        stringBuffer.append(string);
        stringBuffer.append("</CommonBaseEvents>");
        CommonBaseEvent[] commonBaseEventArray = EventFormatter.eventsFromCanonicalXMLDoc(stringBuffer.toString(), bl);
        if (commonBaseEventArray != null) {
            return commonBaseEventArray[0];
        }
        return null;
    }

    private static String getExtendedDataElementXML(ExtendedDataElement extendedDataElement, String string, boolean bl, int n) {
        if (extendedDataElement != null) {
            int n2;
            String string2;
            StringBuffer stringBuffer = new StringBuffer(512);
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append("\t");
                    ++n3;
                }
            }
            stringBuffer.append("<");
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("extendedDataElements");
            }
            String string3 = extendedDataElement.getName();
            if (string3 != null) {
                stringBuffer.append(" name=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\"");
            }
            if ((string3 = extendedDataElement.getType()) != null) {
                stringBuffer.append(" type=\"");
                stringBuffer.append(string3);
                stringBuffer.append("\"");
            }
            stringBuffer.append(">");
            if (extendedDataElement.getTypeAsInt() == 19) {
                string2 = extendedDataElement.getHexValue();
                if (string2 != null) {
                    if (bl) {
                        stringBuffer.append(LINE_SEPARATOR);
                        int n4 = 0;
                        while (n4 < n + 1) {
                            stringBuffer.append("\t");
                            ++n4;
                        }
                    }
                    stringBuffer.append("<hexValue>");
                    stringBuffer.append(string2);
                    stringBuffer.append("</hexValue>");
                }
            } else {
                string2 = extendedDataElement.getValues();
                String string4 = null;
                n2 = 0;
                while (n2 < string2.size()) {
                    string4 = (String)string2.get(n2);
                    if (string4 != null) {
                        if (bl) {
                            stringBuffer.append(LINE_SEPARATOR);
                            int n5 = 0;
                            while (n5 < n + 1) {
                                stringBuffer.append("\t");
                                ++n5;
                            }
                        }
                        stringBuffer.append("<values>");
                        stringBuffer.append(XmlUtility.normalize((String)string4));
                        stringBuffer.append("</values>");
                    }
                    ++n2;
                }
            }
            string2 = extendedDataElement.getChildren();
            int n6 = 0;
            while (n6 < string2.size()) {
                stringBuffer.append(EventFormatter.getExtendedDataElementXML((ExtendedDataElement)string2.get(n6), "children", bl, bl ? n + 1 : 0));
                ++n6;
            }
            if (bl) {
                stringBuffer.append(LINE_SEPARATOR);
                n2 = 0;
                while (n2 < n) {
                    stringBuffer.append("\t");
                    ++n2;
                }
            }
            stringBuffer.append("</");
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("extendedDataElements");
            }
            stringBuffer.append(">");
            return stringBuffer.toString();
        }
        return "";
    }

    private static String resolveCommonBaseEventSchemaLocation() {
        URL uRL = null;
        try {
            uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return this.getClass().getClassLoader().getResource(EventFormatter.COMMON_BASE_EVENT_SCHEMA_NAME);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (uRL == null) {
            try {
                uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return ClassLoader.getSystemClassLoader().getResource(EventFormatter.COMMON_BASE_EVENT_SCHEMA_NAME);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (uRL == null) {
                try {
                    uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return Thread.currentThread().getContextClassLoader().getResource(EventFormatter.COMMON_BASE_EVENT_SCHEMA_NAME);
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (uRL != null) {
            return uRL.toExternalForm();
        }
        return null;
    }

    private static SAXEventHandler parse(InputSource inputSource, boolean bl) throws FormattingException {
        try {
            SAXEventHandler sAXEventHandler = new SAXEventHandler();
            XMLReader xMLReader = null;
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(sAXEventHandler);
            xMLReader.setErrorHandler(sAXEventHandler);
            xMLReader.setFeature("http://xml.org/sax/features/validation", bl);
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", bl);
            if (bl) {
                try {
                    xMLReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    xMLReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.ibm.com/AC/commonbaseevent1_0_1 ".concat(COMMON_BASE_EVENT_SCHEMA_LOCATION_URL));
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    xMLReader.setFeature("http://xml.org/sax/features/validation", false);
                    xMLReader.setFeature("http://xml.org/sax/features/namespaces", false);
                }
            }
            xMLReader.parse(inputSource);
            return sAXEventHandler;
        }
        catch (Exception exception) {
            throw new FormattingException(exception);
        }
    }
}

