/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.EMFUtil;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class LogContentProvider
implements ITreeContentProvider,
IDisposable {
    public static final String SD_FILE_EXTENSION = "trcdbxmi";
    public static final String SYMPTOM_FILE_EXTENSION = "symptom";
    private TreeViewer treeViewer;
    private LogicalFolder logFolder;
    private LogicalFolder sdFolder;
    private LogicalFolder corrFolder;
    private boolean filesLoaded = false;
    private LogNavigator navigator;

    public LogContentProvider() {
    }

    public LogContentProvider(LogNavigator navigator) {
        this.navigator = navigator;
    }

    public void dispose() {
        if (this.logFolder != null) {
            this.logFolder.dispose();
        }
        if (this.sdFolder != null) {
            this.sdFolder.dispose();
        }
        this.treeViewer = null;
    }

    public ResourceSet getResourceSet() {
        return HierarchyResourceSetImpl.getInstance();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void loadFiles() {
        String[] extensions = new String[]{SD_FILE_EXTENSION, SYMPTOM_FILE_EXTENSION, "trcmxmi"};
        Map filesByExtension = ResourceUtil.getFiles((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot(), (String[])extensions, null);
        this.getSDFolder().getChildren().addAll((List)filesByExtension.get(SD_FILE_EXTENSION));
        this.getSDFolder().getChildren().addAll((List)filesByExtension.get(SYMPTOM_FILE_EXTENSION));
        EObject[] resourceSetObj = EMFUtil.loadMonitorsFromResourceSet(this.getResourceSet());
        this.loadIntoFolders(resourceSetObj);
        Iterator i = ((List)filesByExtension.get("trcmxmi")).iterator();
        while (i.hasNext()) {
            EObject[] eObjects = EMFUtil.load(this.getResourceSet(), (IFile)i.next());
            this.loadIntoFolders(eObjects);
        }
        this.filesLoaded = true;
    }

    private void loadIntoFolders(EObject[] eObjects) {
        int j = 0;
        int maxj = eObjects.length;
        while (j < maxj) {
            if (eObjects[j] instanceof TRCMonitor) {
                this.getCorrelationFolder().getChildren().addAll(((TRCMonitor)eObjects[j]).getCorrelationContainerProxies());
                Iterator k = ((TRCMonitor)eObjects[j]).getNodes().iterator();
                while (k.hasNext()) {
                    TRCNode node = (TRCNode)k.next();
                    this.getLogFolder().getChildren().add(node);
                }
            }
            ++j;
        }
    }

    public void refreshFromLocal() {
        this.filesLoaded = false;
        this.clearFolders();
        this.getTreeViewer().refresh();
    }

    public LogicalFolder getLogFolder() {
        if (this.logFolder == null) {
            this.logFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_LOGFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.logFolder;
    }

    public LogicalFolder getSDFolder() {
        if (this.sdFolder == null) {
            this.sdFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_SDFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.sdFolder;
    }

    public LogicalFolder getCorrelationFolder() {
        if (this.corrFolder == null) {
            this.corrFolder = new LogicalFolder(LogUIPlugin.getResourceString("LOG_NAV_CORRFLD")){

                protected List createChildren() {
                    return new UniqueEList();
                }
            };
        }
        return this.corrFolder;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearFolders();
        if (viewer instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)viewer;
        }
    }

    public Object getParent(Object element) {
        if (element instanceof TRCAgentProxy) {
            return this.getLogFolder();
        }
        if (element instanceof CorrelationContainerProxy) {
            return this.getCorrelationFolder();
        }
        if (element instanceof IFile && (SD_FILE_EXTENSION.equals(((IFile)element).getFileExtension()) || SYMPTOM_FILE_EXTENSION.equals(((IFile)element).getFileExtension()))) {
            return this.getSDFolder();
        }
        if (element instanceof LogicalFolder) {
            return ((LogicalFolder)element).getParent();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<LogicalFolder> list = new ArrayList<LogicalFolder>();
        list.add(this.getLogFolder());
        list.add(this.getSDFolder());
        list.add(this.getCorrelationFolder());
        list.addAll(NavigatorExtensionUtil.getAllChildren((Object)inputElement, (String)this.navigator.getID()));
        return list.toArray();
    }

    public boolean hasChildren(Object element) {
        if (NavigatorExtensionUtil.hasChildren((Object)element, (String)this.navigator.getID())) {
            return true;
        }
        if (element instanceof LogicalFolder) {
            if (!this.filesLoaded) {
                this.loadFiles();
            }
            return !((LogicalFolder)element).getChildren().isEmpty();
        }
        if (element instanceof CorrelationContainerProxy) {
            return ((CorrelationContainerProxy)element).getCorrelatedAgents().size() > 0;
        }
        if (element instanceof TRCNode) {
            return EMFUtil.getLogAgentsFromNode((TRCNode)element).size() > 0;
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList list = new ArrayList();
        if (parentElement == this.getLogFolder()) {
            this.getLogFolder().getChildren().clear();
            this.getLogFolder().getChildren().addAll(this.getNodesFromResourceSet());
            list.addAll(this.getLogFolder().getChildren());
        } else if (parentElement instanceof LogicalFolder) {
            list.addAll(((LogicalFolder)parentElement).getChildren());
        } else if (parentElement instanceof CorrelationContainerProxy) {
            list.addAll(((CorrelationContainerProxy)parentElement).getCorrelatedAgents());
        }
        if (parentElement instanceof TRCNode) {
            list.addAll(EMFUtil.getLogAgentsFromNode((TRCNode)parentElement));
        }
        list.addAll(NavigatorExtensionUtil.getAllChildren((Object)parentElement, (String)this.navigator.getID()));
        return list.toArray();
    }

    private void clearFolders() {
        if (this.logFolder != null) {
            this.logFolder.getChildren().clear();
        }
        if (this.sdFolder != null) {
            this.sdFolder.getChildren().clear();
        }
        if (this.corrFolder != null) {
            this.corrFolder.getChildren().clear();
        }
    }

    private List getNodesFromResourceSet() {
        EList resources = this.getResourceSet().getResources();
        int size = resources.size();
        ArrayList<TRCNode> nodes = new ArrayList<TRCNode>();
        int idx = 0;
        while (idx < size) {
            Resource res = (Resource)resources.get(idx);
            EList ext = res.getContents();
            Iterator iter = ext.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof TRCMonitor)) continue;
                Iterator iterator = ((TRCMonitor)obj).getNodes().iterator();
                while (iterator.hasNext()) {
                    TRCNode node = (TRCNode)iterator.next();
                    if (EMFUtil.getLogAgentsFromNode(node).size() <= 0 || nodes.contains(node)) continue;
                    nodes.add(node);
                }
            }
            ++idx;
        }
        return nodes;
    }
}

