/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.NewCorrelationWizard;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.views.navigator.ResourceNavigatorMessages;

public class NewActionGroup
extends NavigatorActionGroup {
    private static final int WIZARD_WIDTH = 500;
    private static final int WIZARD_HEIGHT = 400;
    private Action newSymptomDBAction;
    private Action newCorrelationAction;

    public NewActionGroup(Navigator navigator) {
        super((INavigator)navigator);
    }

    protected void createActions() {
        if (LogUIPlugin.getDefault().getNewSymDBWizard() != null) {
            this.newSymptomDBAction = new Action(){

                public void run() {
                    INewWizard wiz = LogUIPlugin.getDefault().getNewSymDBWizard();
                    wiz.init(HyadesUIPlugin.getInstance().getWorkbench(), NewActionGroup.this.getNavigator().getStructuredSelection());
                    WizardDialog dialog = new WizardDialog(NewActionGroup.this.getNavigator().getSite().getWorkbenchWindow().getShell(), (IWizard)wiz);
                    dialog.setPageSize(500, 400);
                    dialog.open();
                }
            };
            this.newSymptomDBAction.setText(LogUIPlugin.getResourceString("STR_NEW_SYMPTOM_DATABASE_TOOLTIP"));
            this.newSymptomDBAction.setToolTipText(LogUIPlugin.getResourceString("STR_NEW_SYMPTOM_DATABASE_TOOLTIP"));
            this.newSymptomDBAction.setImageDescriptor(this.getImageDescriptor("obj16/new_symptomdb_obj.gif"));
            this.newSymptomDBAction.setHoverImageDescriptor(this.getImageDescriptor("obj16/new_symptomdb_obj.gif"));
        }
        this.newCorrelationAction = new Action(){

            public void run() {
                NewCorrelationWizard wiz = new NewCorrelationWizard();
                wiz.init(HyadesUIPlugin.getInstance().getWorkbench(), NewActionGroup.this.getNavigator().getStructuredSelection());
                WizardDialog dialog = new WizardDialog(NewActionGroup.this.getNavigator().getSite().getWorkbenchWindow().getShell(), (IWizard)wiz);
                dialog.setPageSize(500, 400);
                dialog.open();
            }
        };
        this.newCorrelationAction.setText(LogUIPlugin.getResourceString("STR_NEW_CORR_MENUITEM"));
        this.newCorrelationAction.setToolTipText(LogUIPlugin.getResourceString("STR_NEW_CORR_TOOLTIP"));
        this.newCorrelationAction.setImageDescriptor(this.getImageDescriptor("etool16/newcorrelation_wiz.gif"));
        this.newCorrelationAction.setHoverImageDescriptor(this.getImageDescriptor("etool16/newcorrelation_wiz.gif"));
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            URL installURL = new URL(LogUIPlugin.getDefault().getBundle().getEntry("/"), "icons/full/");
            URL url = new URL(installURL, relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this.getContext().getSelection();
        if (this.getNavigator().isShowingFolders()) {
            if (!this.hasLogicalFolder(structuredSelection)) {
                MenuManager newMenu = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.new"));
                menu.appendToGroup("group.additions", (IContributionItem)newMenu);
                new NewWizardMenu((IMenuManager)newMenu, this.getNavigator().getSite().getWorkbenchWindow(), false);
                if (this.newSymptomDBAction != null) {
                    newMenu.insert(0, (IContributionItem)new ActionContributionItem((IAction)this.newSymptomDBAction));
                    newMenu.insert(1, (IContributionItem)new Separator());
                }
            }
        } else {
            LogicalFolder logicalFolder;
            Object selection;
            MenuManager newMenu = null;
            if (structuredSelection.size() > 0) {
                boolean selAgents = true;
                Iterator iter = structuredSelection.iterator();
                while (iter.hasNext()) {
                    if (iter.next() instanceof TRCAgentProxy) continue;
                    selAgents = false;
                    break;
                }
                if (selAgents) {
                    newMenu = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.new"));
                    menu.appendToGroup("group.additions", (IContributionItem)newMenu);
                    newMenu.add((IAction)this.newCorrelationAction);
                }
            }
            if (structuredSelection.size() == 1 && (selection = structuredSelection.getFirstElement()) instanceof LogicalFolder && (logicalFolder = (LogicalFolder)selection).getParent() == null) {
                String name = logicalFolder.getName();
                if (name.equals(LogUIPlugin.getResourceString("LOG_NAV_SDFLD"))) {
                    newMenu = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.new"));
                    menu.appendToGroup("group.additions", (IContributionItem)newMenu);
                    if (this.newSymptomDBAction != null) {
                        newMenu.add((IAction)this.newSymptomDBAction);
                    }
                }
                if (name.equals(LogUIPlugin.getResourceString("LOG_NAV_CORRFLD"))) {
                    newMenu = new MenuManager(ResourceNavigatorMessages.getString((String)"ResourceNavigator.new"));
                    menu.appendToGroup("group.additions", (IContributionItem)newMenu);
                    newMenu.add((IAction)this.newCorrelationAction);
                }
            }
        }
    }

    protected boolean hasLogicalFolder(IStructuredSelection structuredSelection) {
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof LogicalFolder)) continue;
            return true;
        }
        return false;
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolbar = actionBars.getToolBarManager();
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.newCorrelationAction);
        if (this.newSymptomDBAction != null) {
            toolbar.add((IAction)this.newSymptomDBAction);
        }
    }
}

