/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class LogUtil {
    static /* synthetic */ Class class$java$lang$String;

    public static boolean selectInLogNavigator(EObject object) {
        if (object != null) {
            Navigator nav = (Navigator)HyadesUtil.getActiveNavigator();
            Navigator part = null;
            IWorkbench workbench = LogUIPlugin.getDefault().getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            if (!(nav instanceof LogNavigator)) {
                try {
                    IWorkspaceRoot element;
                    if (page != null && !page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective") && (element = ResourcesPlugin.getWorkspace().getRoot()) != null) {
                        page = workbench.showPerspective("org.eclipse.hyades.trace.internal.ui.tracePerspective", workbench.getActiveWorkbenchWindow(), (IAdaptable)element);
                    }
                    part = page.findView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                part = nav;
            }
            EObject selection = object;
            Navigator fPart = part;
            IWorkbenchPage fPage = page;
            if (fPart != null) {
                Display.getDefault().asyncExec(new Runnable((IViewPart)fPart, selection, fPage){
                    private final /* synthetic */ IViewPart val$fPart;
                    private final /* synthetic */ EObject val$selection;
                    private final /* synthetic */ IWorkbenchPage val$fPage;
                    {
                        this.val$fPart = val$fPart;
                        this.val$selection = val$selection;
                        this.val$fPage = val$fPage;
                    }

                    public void run() {
                        block2: {
                            ((LogNavigator)this.val$fPart).selectReveal((ISelection)new StructuredSelection((Object)this.val$selection));
                            if (((LogNavigator)this.val$fPart).isActiveNavigator()) break block2;
                            try {
                                this.val$fPage.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
        return false;
    }

    public static void notifyViewSelectionChanged(Object source, Object selection) {
        UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).add(selection);
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource(source);
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    public static IPreferenceStore doGetPreferenceStore() {
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        try {
            String updated;
            String storeValue;
            String psValue;
            int i;
            String[] prefNames;
            PreferenceStore ps;
            IPath path = Platform.getPluginStateLocation((Plugin)ResourcesPlugin.getPlugin());
            File file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append("org.eclipse.hyades.sdb.prefs").toFile();
            if (!file.exists()) {
                file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.hyades.sdb").addTrailingSeparator().append("pref_store.ini").toFile();
            }
            if (file.exists()) {
                ps = new PreferenceStore(file.getAbsolutePath());
                ps.load();
                prefNames = ps.preferenceNames();
                i = 0;
                while (i < prefNames.length) {
                    if (!store.contains(prefNames[i])) {
                        store.putValue(prefNames[i], ps.getString(prefNames[i]));
                    } else {
                        psValue = ps.getString(prefNames[i]);
                        storeValue = store.getString(prefNames[i]);
                        updated = storeValue + LogUtil.updatePreferenceStore(storeValue, psValue);
                        store.putValue(prefNames[i], updated);
                    }
                    ++i;
                }
                LogUIPlugin.getDefault().savePluginPreferences();
                file.delete();
            }
            if ((file = (path = Platform.getPluginStateLocation((Plugin)ResourcesPlugin.getPlugin())).removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append("com.ibm.etools.symptom.editor.prefs").toFile()).exists()) {
                ps = new PreferenceStore(file.getAbsolutePath());
                ps.load();
                prefNames = ps.preferenceNames();
                i = 0;
                while (i < prefNames.length) {
                    if (!store.contains(prefNames[i])) {
                        store.putValue(prefNames[i], ps.getString(prefNames[i]));
                    } else {
                        psValue = ps.getString(prefNames[i]);
                        storeValue = store.getString(prefNames[i]);
                        updated = storeValue + LogUtil.updatePreferenceStore(storeValue, psValue);
                        store.putValue(prefNames[i], updated);
                    }
                    ++i;
                }
                LogUIPlugin.getDefault().savePluginPreferences();
                file.delete();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return store;
    }

    public static void initializePreferenceStore(IPreferenceStore store) {
        try {
            ArrayList sort = new ArrayList(40);
            ArrayList filter = new ArrayList(70);
            LogUtil.createSortAndFilterList(sort, filter, (EClassifier)CBEPackage.eINSTANCE.getCBECommonBaseEvent());
            sort.remove("timeZone");
            StringBuffer pdSortKey = new StringBuffer();
            LogUtil.generatePreferenceString(pdSortKey, sort, new String[]{"creationTime", "sequenceNumber"});
            store.setDefault("pd_sort_log_options", pdSortKey.toString().trim());
            filter.remove("timeZone");
            StringBuffer pdKey = new StringBuffer();
            Collections.sort(filter);
            LogUtil.generatePreferenceString(pdKey, filter, null);
            store.setDefault("pd_filter_options", pdKey.toString().trim());
            store.setDefault("pd_adv_filter_options", "");
            store.setDefault("pd_src_filter_options", "");
            store.setDefault("pd_src_direction_options", "1");
            store.setDefault("pd_filter_show_correlation_only", "1");
            String url = LogUIPlugin.getResourceString("STR_StdURL_NAME") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + LogUIPlugin.getResourceString("STR_AdvURL_NAME") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/adv/symptomdb.xml" + "\n" + LogUIPlugin.getResourceString("STR_StdURL_NAME_V5") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + LogUIPlugin.getResourceString("STR_StdURL_NAME_V6") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + LogUIPlugin.getResourceString("STR_AdvURL_NAME_V5") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/adv/symptomdb.xml";
            store.setDefault("symptom_db_url", url);
            store.setDefault("symptom_db_url_3.2", url);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        store.setDefault("LogAnalyzer.DateFormat", LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT);
        store.setDefault("LogAnalyzer.TimeFormat", LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT);
    }

    private static void generatePreferenceString(StringBuffer key, ArrayList list, String[] pref) {
        String keyVal = "";
        if (pref == null) {
            keyVal = ":1 ";
        } else {
            keyVal = ":1 ";
            int s = pref.length;
            int i = 0;
            while (i < s) {
                key.append(pref[i]);
                key.append(keyVal);
                list.remove(pref[i]);
                ++i;
            }
            keyVal = ":0 ";
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            key.append(element);
            key.append(keyVal);
        }
    }

    private static void createSortAndFilterList(List sort, List filter, EClassifier base) {
        ArrayList list = new ArrayList(30);
        EList metaObj = CBEPackage.eINSTANCE.getEClassifiers();
        int size = metaObj.size();
        int i = 0;
        while (i < size) {
            EClassifier elem = (EClassifier)metaObj.get(i);
            LogUtil.getEObjectAttributes((EClass)elem, list);
            int listSize = list.size();
            boolean isSort = ((EClass)elem).getEAllSuperTypes().contains((Object)base) || elem == base;
            int j = 0;
            while (j < listSize) {
                String element = (String)list.get(j);
                if (isSort && !sort.contains(element)) {
                    sort.add(element);
                }
                if (!filter.contains(element)) {
                    filter.add(element);
                }
                ++j;
            }
            list.clear();
            ++i;
        }
    }

    private static void getEObjectAttributes(EClass eClass, List list) {
        EList attributes = eClass.getEAttributes();
        boolean isArrayOfObj = false;
        int k = 0;
        while (k < attributes.size()) {
            EAttribute attribute = (EAttribute)attributes.get(k);
            boolean bl = attribute.isMany() && attribute.getEType().getInstanceClass() != (class$java$lang$String == null ? LogUtil.class$("java.lang.String") : class$java$lang$String) && !attribute.getEType().getInstanceClassName().equals("byte") && !attribute.getEType().getInstanceClassName().equals("short") ? true : (isArrayOfObj = false);
            if (!isArrayOfObj) {
                list.add(attribute.getName());
            }
            ++k;
        }
    }

    private static String updatePreferenceStore(String str1, String str2) {
        if (str1 == null || str1.trim().length() == 0) {
            return "\n" + str2;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return "";
        }
        String[] urls1 = str1.split("\n");
        Hashtable<String, String> table = new Hashtable<String, String>();
        int i = 0;
        while (i < urls1.length) {
            String[] strs = urls1[i].split("\t");
            strs[0] = strs[0].trim();
            if (strs[0].length() != 0) {
                table.put(strs[0], strs[1]);
            }
            ++i;
        }
        String[] urls2 = str2.split("\n");
        String rc = "";
        int i2 = 0;
        while (i2 < urls2.length) {
            String[] strs = urls2[i2].split("\t");
            strs[0] = strs[0].trim();
            if (strs[0].length() != 0 && !table.containsKey(strs[0])) {
                rc = rc + "\n" + urls2[i2];
            }
            ++i2;
        }
        return rc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

