/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TableItem;

public class LogHostUI
extends TraceHostUI {
    public LogHostUI(WizardPage wp) {
        super(wp);
    }

    public LogHostUI() {
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        ((ImportLogWizardPage)this.getWizardPage()).getDialog().setOKButtonEnabled(this.isTabItemComplete());
        ((ImportLogWizardPage)this.getWizardPage()).initLocation();
    }

    public void initialize(LogFileElement element) {
        String host = element.getHost();
        int port = element.getPort();
        if (host != null) {
            this.selectHost(host, port);
        }
    }

    public boolean isTabItemComplete() {
        return this.getHost() != null;
    }

    public void selectHost(String hostname, int port) {
        if (port == 0) {
            port = 10002;
        }
        super.selectHost(hostname + ":" + port);
    }

    public boolean finish() {
        LogFileElement element = ((ImportLogWizardPage)this.getWizardPage()).getSelectedElement();
        element.setHost(this.getHost());
        element.setPort(this.getPort());
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String hosts = "";
        TableItem[] items = this.getHosts();
        if (items.length == 0) {
            return false;
        }
        int idx = 0;
        while (idx < items.length) {
            hosts = hosts + "," + items[idx].getText().trim();
            ++idx;
        }
        if (hosts.startsWith(",") && hosts.length() > 1) {
            hosts = hosts.substring(1);
        }
        store.setValue("use_host", hosts);
        return true;
    }
}

