/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FilteredContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private ITreeContentProvider _tree;
    private IStructuredContentProvider _structured;
    private IContentProvider _provider;
    private String _navigatorID;
    private Viewer _viewer;

    public FilteredContentProvider(IContentProvider provider, String navigatorID, Viewer viewer) {
        this._provider = provider;
        if (provider instanceof IStructuredContentProvider) {
            this._structured = (IStructuredContentProvider)provider;
        }
        if (provider instanceof ITreeContentProvider) {
            this._tree = (ITreeContentProvider)provider;
        }
        this._navigatorID = navigatorID;
        this._viewer = viewer;
    }

    public Object[] getChildren(Object parentElement) {
        if (this._tree != null) {
            Object[] e = this._tree.getChildren(parentElement);
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < e.length) {
                if (NavigatorExtensionUtil.select(this._viewer, parentElement, e[i], this._navigatorID, false)) {
                    list.addAll(Arrays.asList(this.getChildren(e[i])));
                } else if (!NavigatorExtensionUtil.select(this._viewer, parentElement, e[i], this._navigatorID, true)) {
                    list.add(e[i]);
                }
                ++i;
            }
            return list.toArray();
        }
        return EMPTY;
    }

    public Object getParent(Object element) {
        Object parent;
        if (this._tree != null && (parent = this._tree.getParent(element)) != null) {
            Object grandParent = this._tree.getParent(parent);
            if (NavigatorExtensionUtil.select(this._viewer, grandParent, parent, this._navigatorID)) {
                return this.getParent(parent);
            }
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this._tree != null) {
            if (!this._tree.hasChildren(element)) {
                return false;
            }
            return this.getChildren(element).length > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (this._structured != null) {
            Object[] e = this._structured.getElements(inputElement);
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < e.length) {
                if (NavigatorExtensionUtil.select(this._viewer, inputElement, e[i], this._navigatorID, false)) {
                    list.addAll(Arrays.asList(this.getChildren(e[i])));
                } else if (!NavigatorExtensionUtil.select(this._viewer, inputElement, e[i], this._navigatorID, true)) {
                    list.add(e[i]);
                }
                ++i;
            }
            return list.toArray();
        }
        return EMPTY;
    }

    public void dispose() {
        this._provider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._provider.inputChanged(viewer, oldInput, newInput);
    }
}

