/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser.provider;


import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPluginImages;

/**
 * This is the item provider adpater for a {@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RuleAttributeTypeItemProvider
	extends ItemProviderAdapter
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
			
	public static final String NAME = AcadEditorPlugin.getPlugin().getString("STR_ATTR_NAME");
	public static final Object DEFAULT_VALUE = AcadEditorPlugin.getPlugin().getString("STR_DEFAULT_VALUE");
	public static final Object USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT = AcadEditorPlugin.getPlugin().getString("STR_USE_PREV_ATTR");		
	public final static String REQUIRED_BY_PARENT = AcadEditorPlugin.getPlugin().getString("STR_REQUIRE_BY_PARENT");

	
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuleAttributeTypeItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public List getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addDefaultValuePropertyDescriptor(object);
			addNamePropertyDescriptor(object);
			addUsePreviousMatchSubstitutionAsDefaultPropertyDescriptor(object);
			addIsRequiredByParentPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Default Value feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDefaultValuePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("_UI_RuleAttributeType_defaultValue_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_RuleAttributeType_defaultValue_feature", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_DefaultValue(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Id feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIdPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ATTR_ID"),
				 getString("_UI_PropertyDescriptor_description", "STR_ATTR_ID", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_Id(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Index feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addIndexPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ATTR_INDEX"),
				 getString("_UI_PropertyDescriptor_description", "STR_ATTR_INDEX", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_Index(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Is Required By Parent feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIsRequiredByParentPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_REQUIRE_BY_PARENT"),
				 getString("_UI_PropertyDescriptor_description", "STR_REQUIRE_BY_PARENT", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_IsRequiredByParent(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Name feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addNamePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_ATTR_NAME"),
				 getString("_UI_PropertyDescriptor_description", "STR_ATTR_NAME", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_Name(),
				 true,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE));
	}

	/**
	 * This adds a property descriptor for the Use Previous Match Substitution As Default feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addUsePreviousMatchSubstitutionAsDefaultPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(new ItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getString("STR_USE_PREV_ATTR"),
				 getString("_UI_PropertyDescriptor_description", "STR_USE_PREV_ATTR", "_UI_RuleAttributeType_type"),
				 ParserPackage.eINSTANCE.getRuleAttributeType_UsePreviousMatchSubstitutionAsDefault(),
				 true,
				 ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE));
	}

	/**
	 * This specifies how to implement {@link #getChildren} and is used to deduce an appropriate feature for an
	 * {@link org.eclipse.emf.edit.command.AddCommand}, {@link org.eclipse.emf.edit.command.RemoveCommand} or
	 * {@link org.eclipse.emf.edit.command.MoveCommand} in {@link #createCommand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection getChildrenFeatures(Object object) {
		if (childrenFeatures == null) {
			super.getChildrenFeatures(object);
			childrenFeatures.add(ParserPackage.eINSTANCE.getRuleAttributeType_SubstitutionRule());
		}
		return childrenFeatures;
	}


	/**
	 * This returns RuleAttributeType.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Object getImage(Object object) {
		if(object instanceof SubstitutionRuleType)
			return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_RULE);
		
		return AcadEditorPluginImages.getImage(AcadEditorPluginImages.IMG_UI_ATTRIBUTE);
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getText(Object object) {
		String label = ((RuleAttributeType)object).getName();
		return label == null || label.length() == 0 ?
			"" : label;
	}

	/**
	 * This handles notification by calling {@link #fireNotifyChanged fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void notifyChanged(Notification notification) {
		switch (notification.getFeatureID(RuleAttributeType.class)) {
			case ParserPackage.RULE_ATTRIBUTE_TYPE__DEFAULT_VALUE:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__ID:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__INDEX:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__NAME:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__USE_PREVIOUS_MATCH_SUBSTITUTION_AS_DEFAULT:
			case ParserPackage.RULE_ATTRIBUTE_TYPE__SUBSTITUTION_RULE: {
				fireNotifyChanged(notification);
				return;
			}
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds to the collection of {@link org.eclipse.emf.edit.command.CommandParameter}s
	 * describing all of the children that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
		
        SubstitutionRuleType subs = ParserFactory.eINSTANCE.createSubstitutionRuleType();
        subs.setUseBuiltInFunction(true);
        subs.setUseBuiltInFunction(false);
		newChildDescriptors.add
			(createChildParameter
				(ParserPackage.eINSTANCE.getRuleAttributeType_SubstitutionRule(),
				 subs));
	}

	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection)
	{
	  return getImage(child);
	}
	
	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return AcadEditorPlugin.INSTANCE;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#factorAddCommand(org.eclipse.emf.edit.domain.EditingDomain, org.eclipse.emf.edit.command.CommandParameter)
	 */
	protected Command factorAddCommand(EditingDomain domain, CommandParameter commandParameter) {
		if(!isValidTarget(commandParameter))
			return UnexecutableCommand.INSTANCE;
		else
			return super.factorAddCommand(domain, commandParameter);
	}

	/**
	 * @param commandParameter
	 * @return
	 */
	protected boolean isValidTarget(CommandParameter commandParameter) {
		if(commandParameter.getCollection()==null)
			return false;
		for (Iterator iter = commandParameter.getList().iterator(); iter.hasNext();) {
			EObject element = (EObject) iter.next();
			if (!(element instanceof SubstitutionRuleType)) {
				return false;
			}
		}
		return true;

	}	
}
