/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterConfigTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class OutputterSection extends Composite
								implements IDetails, ModifyListener, SelectionListener
										   , INotifyChangedListener
{
	protected CCombo typeCombo;
	protected Label uniqueIDText;		
	protected Text descriptionText;		
	
    protected boolean isDisplaying;
    protected OutputterConfigType currentSelection;
    protected OutputterConfigTypeItemProvider itemProvider;
    protected OutputterItemProviderAdapterFactory itemFactory;
	
	
	public OutputterSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new OutputterItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_Outputter_Type"), SWT.NONE);	
		typeCombo = factory.createCombo(this, SWT.READ_ONLY);
		typeCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		typeCombo.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
		initializeTypeCombo();	

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_OUT_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.NULL);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_OUT_ID"), SWT.NONE);	
		uniqueIDText = factory.createLabel(this, "", SWT.NULL);
		uniqueIDText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

	
		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		descriptionText.addModifyListener(this);
		typeCombo.addSelectionListener(this);
		
		itemProvider = (OutputterConfigTypeItemProvider)itemFactory.createOutputterConfigTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * 
	 */
	protected void initializeTypeCombo() {
		for (int i = 0; i < OutputterType.VALUES.size(); i++) {
			typeCombo.add(((OutputterType)OutputterType.VALUES.get(i)).getName());
		}
	}

	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
        
		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer());
        
		if(currentSelection == object)
		  return;
        
		if(uniqueIDText.isFocusControl()
		   || descriptionText.isFocusControl())
		   
		  return;
        
		currentSelection = (OutputterConfigType)object;
		isDisplaying = true;
		
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		uniqueIDText.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());

		typeCombo.select(OutputterType.VALUES.indexOf(currentSelection.getType()));
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (OutputterConfigType)currentSelection;
		
		this.currentSelection.setUniqueID(uniqueIDText.getText());
		this.currentSelection.setDescription(descriptionText.getText());
				
		return false;

	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						OutputterConfigTypeItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
		else if(e.getSource() == uniqueIDText)
		{
			String text = uniqueIDText.getText();
			if(!text.equals(currentSelection.getUniqueID()))
			{
				if(text.length() == 0 && currentSelection.getUniqueID() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						OutputterConfigTypeItemProvider.UNIQUE_ID);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}		
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		
	}
	
	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == typeCombo)
		{
			String sel = typeCombo.getText();
			if(!sel.equals(currentSelection.getType().getName()))
			{
				currentSelection.setType(OutputterType.get(sel));				
			}			
			
		}
		
	}
}
