/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.Vector;

/**
 * @author rduggan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResultQueue {


	private Vector entries= new Vector();
	private Vector partialResults=new Vector();
	
	private boolean valid;
	private int lockCount=0;

	private int maxSize=10;
	
	/**
	 * 
	 */
	public ResultQueue() {
		super();
		valid=true;
	}

	public void insertExtractorResult(Object entry) {
		ResultQueueEntry pair=new ResultQueueEntry();
		pair.extractorOutput=entry;
		partialResults.add(pair);
	}

	public void insertFormatterResult(Object entry) {
		ResultQueueEntry pair=(ResultQueueEntry)partialResults.remove(0);
		pair.formatterOutput=entry;
		insert(pair);
	}
	
	public Object get(int index) {
		
		int loopCount = 200;		
		synchronized(this) {
			lockCount++;
			while(index>=entries.size() && valid && loopCount > 0) {
				
				loopCount --;
				try {
					synchronized(this) {
						this.wait(10);
					}
				}
				catch(InterruptedException eprme) {
				}
			}
			lockCount--;
			if(index >= entries.size())
			{
				return null;
			}
			else
				return entries.get(index);	
		}	
	}
	
	public Object getFirstEntry() {
		
		if(entries.size() > 0)
			return entries.firstElement();
			
		return "";	
	}
	
	public Object getLastEntry() {
		
		if(entries.size() > 0)
			return entries.lastElement();
		return "";	
	}

	private void insert(Object entry) {
		synchronized(this) {
			lockCount++;
			while(this.isFull() && valid) {
				synchronized(this) {
					try {
						this.wait(1000);
					}
					catch(InterruptedException e) {
					}
				}
			}
			if(!isFull() && valid)	{
				entries.add(entry);
			}
			lockCount--;
		}	
	}

	public Object remove() {
		boolean isFull=this.isFull();
		Object result=entries.remove(0);
		if(isFull) {
			synchronized(this) {
				this.notifyAll();
			}	
		}
		return result;
	}
	
	public void undoRemove(Object o){
		entries.insertElementAt(o, 0);
		boolean isFull = this.isFull();
		if(isFull) {
			synchronized(this) {
				this.notifyAll();
			}	
		}
	}
	
	public void flush() {
		synchronized(this) {
			partialResults.removeAllElements();
			entries.removeAllElements();
			valid=false;
			while(lockCount-->0) {
				this.notifyAll();
			}
		}
		
		
	}

	public boolean isFull() {
		return entries.size()>=maxSize;	
	}
	
	public void setMaxSize(int size) {
		this.maxSize=size;
	}
	
	public int getSize() {
		return entries.size();
	}
	
	public int getMaxSize() {
		return maxSize;
	}
}
