/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.parser.ParserConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.RuleElementType;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.RuleElementTypeItemProvider;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class RuleElementSection extends Composite
								implements IDetails
										   , INotifyChangedListener, SelectionListener
{
	protected Label nameText;			
	protected Label uniqueId;
	
	protected Label indexText;
	
	protected Button requireByParentBtn;
	protected Button isChildChoicBtn;
	
    protected boolean isDisplaying;
    protected RuleElementType currentSelection;
    protected RuleElementTypeItemProvider itemProvider;
    protected ParserItemProviderAdapterFactory itemFactory;
	
	
	public RuleElementSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		this.itemFactory = new ParserItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
				
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ELEM_NAME"), SWT.NONE);	
		nameText = factory.createLabel(this, "");
		nameText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ELEM_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "unspecified");
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);		

		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_ELEM_INDEX"), SWT.NONE);	
		indexText = factory.createLabel(this, "");
		indexText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));	

		label = factory.createLabel(this, "", SWT.NONE);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);			

		requireByParentBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_REQUIRE_BY_PARENT"), SWT.CHECK);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		requireByParentBtn.setLayoutData(data);		

		isChildChoicBtn = factory.createButton(this, AcadEditorPlugin.getPlugin().getString("STR_CHILD_CHOICE"), SWT.CHECK);	
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		isChildChoicBtn.setLayoutData(data);		
		
		isChildChoicBtn.addSelectionListener(this);
		requireByParentBtn.addSelectionListener(this);

		itemProvider = (RuleElementTypeItemProvider)itemFactory.createRuleElementTypeAdapter();
		itemProvider.addListener(this);

	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
    
		if(currentSelection == object)
		  return;
        
		if(nameText.isFocusControl())		   
		  return;
        
		currentSelection = (RuleElementType)object;
		isDisplaying = true;
			
		nameText.setText(currentSelection.getName()==null?"":currentSelection.getName());
		uniqueId.setText(currentSelection.getId()==null?"unspecified":currentSelection.getId().toString());
		indexText.setText(currentSelection.getIndex()==null?"":currentSelection.getIndex());
		requireByParentBtn.setSelection(currentSelection.isIsRequiredByParent());
		isChildChoicBtn.setSelection(currentSelection.isIsChildChoice());
		
		showCheckBoxs(!(currentSelection.eContainer() instanceof ParserConfigType));
		
		isDisplaying = false;
	}

	private void showCheckBoxs(boolean enable) {
		requireByParentBtn.setVisible(enable);
		isChildChoicBtn.setVisible(enable);
	}
	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (RuleElementType)currentSelection;
		this.currentSelection.setIsChildChoice(isChildChoicBtn.getSelection());
		this.currentSelection.setIsRequiredByParent(requireByParentBtn.getSelection());		
		return false;

	}
	
	public void setFocusToText(){
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}
	

	public void widgetSelected(SelectionEvent e)
	{
		if(e.getSource() == requireByParentBtn)
		{
			boolean value = requireByParentBtn.getSelection();
			if(value  != currentSelection.isIsRequiredByParent())
			{
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						RuleElementTypeItemProvider.REQUIRED_BY_PARENT);
				
				currentSelection.setIsRequiredByParent(value);
				
				Boolean oldValue = Boolean.valueOf(currentSelection.isIsRequiredByParent());		
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, oldValue);	
					
				
			}
		}
		else if(e.getSource() == isChildChoicBtn)
		{
			boolean value = isChildChoicBtn.getSelection();
			if(value  != currentSelection.isIsChildChoice())
			{
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						RuleElementTypeItemProvider.CHILD_CHOICE);
				
				currentSelection.setIsChildChoice(value);
				
				Boolean oldValue = Boolean.valueOf(currentSelection.isIsChildChoice());		
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, oldValue);	
					
				
			}
		}
		
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
	}

}
