/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.preferences;

import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AcadEditorPreferencePage extends PreferencePage
	implements IWorkbenchPreferencePage{

	public static int MAX_SIZE = 100;
	public static int DEFAULT_SIZE = 10;
	public static final String BUFFER_SIZE = "buffer_size";
	private Text sizeText;
	protected static PreferencePage INSTANCE;
	/**
	 * Constructor for PluginPreferencePage.
	 */
	public AcadEditorPreferencePage()
	{
		super();
		INSTANCE = this;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite= new Composite(parent, SWT.NONE);	
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 10;	
		layout.numColumns= 1;
		layout.verticalSpacing = 20;		
		composite.setLayout(layout);
		
		Label prefDesc = new Label(composite, SWT.WRAP);
		prefDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_MESSAGE", new Object[] {String.valueOf(MAX_SIZE)}));
		GridData data = GridDataUtil.createHorizontalFill();
		data.widthHint = 400;
		prefDesc.setLayoutData(data);

		Composite content = new Composite(composite, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.verticalSpacing = 5;		
		layout.makeColumnsEqualWidth = false;
		content.setLayout(layout);
		content.setLayoutData(GridDataUtil.createHorizontalFill());

		Label textDesc = new Label(content, SWT.NULL);
		textDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_BUFFER_SIZE")); //$NON-NLS-1$
		sizeText = new Text(content, SWT.BORDER);
		data = GridDataUtil.createFill();
		data.widthHint = 50;
		data.horizontalAlignment = SWT.BEGINNING;
		sizeText.setLayoutData(data);
		sizeText.setFocus();
		sizeText.addModifyListener(new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				String value = sizeText.getText();
				String errorMessage = null;
				try{
					int size = Integer.parseInt(value);
					if (size > MAX_SIZE)
						errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_TOO_LARGE", new Object[] {String.valueOf(MAX_SIZE)});
					else if (size < 0)
						errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NEGATIVE");
					else if (size == 0)
						errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
				}catch(Exception exp){
					errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
				}
				AcadEditorPreferencePage.INSTANCE.setErrorMessage(errorMessage);
				AcadEditorPreferencePage.INSTANCE.setValid(errorMessage==null);
			}});

		initializeValues();

		//WorkbenchHelp.setHelp(tableViewer.getControl(), ContextIds.LOGGING_PREF_PLUGIN_LEVEL);
		return composite;
	}
	
	public void initializeValues(){
		int size =  AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(BUFFER_SIZE);
		sizeText.setText(Integer.toString(size));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		return true;
	}
	
	/*
	 * @see PreferencePage#performDefaults()
	 */
	protected void performDefaults()
	{
		super.performDefaults();
		AcadEditorPlugin.getPlugin().getPluginPreferences().setToDefault(BUFFER_SIZE);
		this.sizeText.setText(""+AcadEditorPlugin.getPlugin().getPluginPreferences().getDefaultInt(BUFFER_SIZE));
	}

	private void storeValues(){
		int size = -1;
		try{
			size = Integer.parseInt(sizeText.getText());
		}catch(Exception e){}
		AcadEditorPlugin.getPlugin().getPluginPreferences().setValue(BUFFER_SIZE, size);
		// since there is no preferenceStore, the preferences can not be saved by preferenceStore.save()
		// have to call this Plugin.savePluginPreferences() to save the data.
		AcadEditorPlugin.getPlugin().savePluginPreferences();
	}
	
}
