/**********************************************************************
 * Copyright (c) 2003,2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: GenerateConstants.java,v 1.9 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupService;

/**
 * @author slavescu
 */
public class GenerateConstants {
	//~ Static fields/initializers -----------------------------------------------------------------

	private static Class[] classes =
		{ 
			TraceXMLLoadersFactory.class, 
			TraceXMLFragmentLoader.class, 
			XMLobjAllocLoader.class, 
			XMLclassDefLoader.class,
			XMLmethodDefLoader.class,
			TraceMethodBaseLoader.class,
			XMLmethodEntryLoader.class,
			XMLmethodExitLoader.class,
			XMLthreadStartLoader.class,
			XMLheapDumpDefLoader.class,
			XMLobjReferenceLoader.class,
			XMLgcRootLoader.class,
			XMLmonWaitLoader.class,
			XMLmonContendedEnterLoader.class,
			XMLtraceStartLoader.class,
			XMLmethodInvocationsLoader.class
		};
	private static Class[] lookUpServiceClasses =
		{
			TraceLookupService.class
		};

	//~ Methods ------------------------------------------------------------------------------------

	public static void main(String[] args) {
		GenerateConstants generateConstants = new GenerateConstants();
		generateConstants.processClasses();
	}

	private void processClasses() {
		List list = new ArrayList();

		for (int i = 0; i < classes.length; i++) {
			addFieldsName(classes[i], list);
		}

		for (int i = 0; i < lookUpServiceClasses.length; i++) {
			addLookUpServiceName(lookUpServiceClasses[i], list);
		}


		Collections.sort(list,new Comparator(){
			/**
			 *
			 */

			public int compare(Object o1, Object o2) {
				return ((String[])o1)[0].compareTo(((String[])o2)[0]);
			}

		});

		//		System.out.println("// "+ theClass.getName() +" related constants");
		String prevName = "";
		PrintWriter out=null;
		try {
			out =
				new PrintWriter(
					new FileWriter("E:\\test\\workspaces\\defects\\hyades-3.1\\org.eclipse.hyades.models.trace\\src\\org\\eclipse\\hyades\\loaders\\trace\\TraceConstants.java"));
			out.println(
				"/**********************************************************************\n"
					+ " * Copyright (c) 2003,2004 Hyades project.\n"
					+ " * All rights reserved.   This program and the accompanying materials\n"
					+ " * are made available under the terms of the Eclipse Public License v1.0\n"
					+ " * which accompanies this distribution, and is available at\n"
					+ " * http://www.eclipse.org/legal/epl-v10.html\n"
					+ " *\n"
					+ " * Contributors:\n"
					+ " * IBM - Initial API and implementation\n"
					+ " *\n"
					+ " * $Id: GenerateConstants.java,v 1.9 2004/11/22 21:48:51 slavescu Exp $\n"
					+ " **********************************************************************/\n"
					+ "package org.eclipse.hyades.loaders.trace;\n"
					+ "\n"
					+ "/**\n"
					+ " * @author slavescu\n"
					+ " */\n"
					+ "public class TraceConstants {\n");

			Set processed = new HashSet();
			for (Iterator iter = list.iterator(); iter.hasNext();) {
				String[] field = (String[]) iter.next();
				if(processed.contains(field[0]))
					continue;
				processed.add(field[0]);
//				if (!field[0].equals(prevName)) {
				
					out.println(
						"\tprotected static final int "
							+ field[0]
							+ "_int = "
							+ LoadersUtils.getHashCode(field[1])
							+ ";");
//					prevName = field[0];
//				}
			}
			out.println("}\n");
			out.close();
		} catch (IOException e) {
			if(out!=null)
				out.close();
			LoadersUtils.log(e);
		}
	}

	private void addLookUpServiceName(Class class1, List list) {
		try {
			LookupService lookupService = (LookupService)class1.newInstance();
			for (Iterator iter = lookupService.getSupportedTypes().iterator(); iter.hasNext();) {
				Class element = (Class) iter.next();
				String name = element.getName();
//				name = name.replace('.','_');
				if(name.lastIndexOf('.')>0)
					name = name.substring(name.lastIndexOf('.')+1); 
				list.add(new String[]{name,element.getName()});
			}
		} catch (InstantiationException e) {
			LoadersUtils.log(e);
		} catch (IllegalAccessException e) {
			LoadersUtils.log(e);
		}
		
	}

	private void addFieldsName(Class theClass, List list) {
		try {
			Field[] fields = theClass.getDeclaredFields();
			for (int i = 0; i < fields.length; i++) {
				int mod = fields[i].getModifiers();
				if (Modifier.isProtected(mod) && Modifier.isStatic(mod) && Modifier.isFinal(mod) && fields[i].getType()==String.class)
				{
					Object value = fields[i].get(null);
					if(value!=null)
						list.add(new String[]{fields[i].getName(),value.toString()});
				}
			}
		} catch (Exception e) {
			LoadersUtils.log(e);
		}
	}
}
